/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.selection;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.data.selection.SelectionListener;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public interface SelectionModel<C extends Component, T>
extends Serializable {
    public Set<T> getSelectedItems();

    public Optional<T> getFirstSelectedItem();

    public void select(T var1);

    public void deselect(T var1);

    public void deselectAll();

    default public boolean isSelected(T item) {
        return this.getSelectedItems().contains(item);
    }

    public Registration addSelectionListener(SelectionListener<C, T> var1);

    public static interface Multi<C extends Component, T>
    extends SelectionModel<C, T> {
        @Override
        default public void select(T item) {
            Objects.requireNonNull(item);
            this.selectItems(item);
        }

        default public void selectItems(T ... items) {
            Objects.requireNonNull(items);
            Stream.of(items).forEach(Objects::requireNonNull);
            this.updateSelection(new LinkedHashSet<T>(Arrays.asList(items)), Collections.emptySet());
        }

        @Override
        default public void deselect(T item) {
            this.deselectItems(item);
        }

        default public void deselectItems(T ... items) {
            Objects.requireNonNull(items);
            Stream.of(items).forEach(Objects::requireNonNull);
            this.updateSelection(Collections.emptySet(), new LinkedHashSet<T>(Arrays.asList(items)));
        }

        public void updateSelection(Set<T> var1, Set<T> var2);

        @Override
        default public Optional<T> getFirstSelectedItem() {
            return this.getSelectedItems().stream().findFirst();
        }

        public void selectAll();
    }

    public static interface Single<C extends Component, T>
    extends SelectionModel<C, T> {
        @Override
        public void select(T var1);

        public Optional<T> getSelectedItem();

        default public void setSelectedItem(T item) {
            if (item != null) {
                this.select(item);
            } else {
                this.getSelectedItem().ifPresent(this::deselect);
            }
        }

        @Override
        default public void deselectAll() {
            this.setSelectedItem(null);
        }

        @Override
        default public Set<T> getSelectedItems() {
            return this.getSelectedItem().map(Collections::singleton).orElse(Collections.emptySet());
        }

        @Override
        default public Optional<T> getFirstSelectedItem() {
            return this.getSelectedItem();
        }

        public void setDeselectAllowed(boolean var1);

        public boolean isDeselectAllowed();
    }
}

