/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dsi.dataengine.utilities;

import com.vertica.dsi.dataengine.utilities.ColumnMetadata;
import com.vertica.dsi.dataengine.utilities.Nullable;
import com.vertica.dsi.dataengine.utilities.ParameterType;
import com.vertica.dsi.dataengine.utilities.TypeMetadata;
import com.vertica.dsi.exceptions.NumericOverflowException;
import com.vertica.support.exceptions.ErrorException;

public class ParameterMetadata {
    protected int m_parameterNumber;
    protected ParameterType m_parameterType;
    protected TypeMetadata m_typeMetadata;
    protected long m_columnLength;
    protected String m_name;
    protected boolean m_isCaseSensitive;
    protected Nullable m_nullable;
    private boolean m_convertInputToString = false;

    public ParameterMetadata(int parameterNumber, ParameterType parameterType, int sqlType) throws ErrorException {
        this.m_parameterNumber = parameterNumber;
        this.m_parameterType = parameterType;
        this.m_typeMetadata = TypeMetadata.createTypeMetadata(sqlType);
        this.m_columnLength = 0L;
        this.m_name = null;
        this.m_isCaseSensitive = false;
        this.m_nullable = Nullable.NULLABLE;
    }

    public ParameterMetadata(int parameterNumber, ParameterType parameterType, int sqlType, boolean isSigned) throws ErrorException {
        this.m_parameterNumber = parameterNumber;
        this.m_parameterType = parameterType;
        this.m_typeMetadata = TypeMetadata.createTypeMetadata(sqlType, isSigned);
        this.m_columnLength = 0L;
        this.m_name = null;
        this.m_isCaseSensitive = false;
        this.m_nullable = Nullable.NULLABLE;
    }

    public ParameterMetadata(int parameterNumber, ParameterType parameterType, TypeMetadata typeMetadata, long columnLength, String name, boolean caseSensitive, Nullable nullable) {
        this.m_parameterNumber = parameterNumber;
        this.m_parameterType = parameterType;
        this.m_typeMetadata = typeMetadata;
        this.m_columnLength = columnLength;
        this.m_name = name;
        this.m_isCaseSensitive = caseSensitive;
        this.m_nullable = nullable;
    }

    public ColumnMetadata getEquivalentColumnMeta() {
        ColumnMetadata col = new ColumnMetadata(this.m_typeMetadata);
        col.setCaseSensitive(this.m_isCaseSensitive);
        col.setName(this.m_name);
        col.setNullable(this.m_nullable);
        try {
            col.setColumnLength(this.m_columnLength);
        }
        catch (NumericOverflowException e) {
            assert (false);
            e.printStackTrace();
        }
        return col;
    }

    public long getColumnLength() {
        return this.m_columnLength;
    }

    public String getName() {
        return this.m_name;
    }

    public Nullable getNullable() {
        return this.m_nullable;
    }

    public int getParameterNumber() {
        return this.m_parameterNumber;
    }

    public ParameterType getParameterType() {
        return this.m_parameterType;
    }

    public TypeMetadata getTypeMetadata() {
        return this.m_typeMetadata;
    }

    public boolean isCaseSensitive() {
        return this.m_isCaseSensitive;
    }

    public boolean isUnnamed() {
        return null == this.m_name;
    }

    public void setCaseSensitive(boolean isCaseSensitive) {
        this.m_isCaseSensitive = isCaseSensitive;
    }

    public void setColumnLength(long length) {
        this.m_columnLength = length;
    }

    public void setConvertInputToString(boolean inputToString) {
        this.m_convertInputToString = inputToString;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setNullable(Nullable nullable) {
        this.m_nullable = nullable;
    }

    public boolean shouldConvertInputToString() {
        return this.m_convertInputToString;
    }
}

