/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc.common;

import com.vertica.dsi.core.impl.DSIDriver;
import com.vertica.dsi.core.impl.DSIDriverSingleton;
import com.vertica.dsi.core.impl.DSILogger;
import com.vertica.dsi.core.interfaces.IConnection;
import com.vertica.dsi.core.interfaces.IStatement;
import com.vertica.dsi.core.utilities.ClientInfoData;
import com.vertica.dsi.core.utilities.PropertyUtilities;
import com.vertica.dsi.core.utilities.Variant;
import com.vertica.dsi.dataengine.utilities.ParameterGeneratedValues;
import com.vertica.dsi.utilities.DSIMessageKey;
import com.vertica.exceptions.ExceptionConverter;
import com.vertica.exceptions.JDBCMessageKey;
import com.vertica.jdbc.common.JDBCObjectFactory;
import com.vertica.jdbc.common.SCallableStatement;
import com.vertica.jdbc.common.SDatabaseMetaData;
import com.vertica.jdbc.common.SPreparedStatement;
import com.vertica.jdbc.common.SSavepoint;
import com.vertica.jdbc.common.SStatement;
import com.vertica.jdbc.common.STransactionStateListener;
import com.vertica.jdbc.common.SWarningListener;
import com.vertica.jdbc.common.utilities.WrapperUtilities;
import com.vertica.support.ILogger;
import com.vertica.support.IWarningListener;
import com.vertica.support.LogUtilities;
import com.vertica.support.Warning;
import com.vertica.support.exceptions.ClientInfoException;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.support.exceptions.ExceptionType;
import com.vertica.support.exceptions.FailedPropertiesReason;
import com.vertica.support.exceptions.GeneralException;
import com.vertica.utilities.FunctionID;
import java.lang.ref.WeakReference;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.Callable;

public abstract class SConnection
implements Connection {
    protected int m_maxVarcharSize = 256;
    protected int m_maxVarbinarySize = 256;
    protected ILogger m_logger = null;
    private volatile boolean m_isClosed = false;
    protected final Object m_closingLock = new Object();
    private String m_URL = "";
    private List<WeakReference<SStatement>> m_stmtReferences = new ArrayList<WeakReference<SStatement>>();
    private SDatabaseMetaData m_databaseMetaData = null;
    private final Object m_databaseMetadataLock = new Object();
    protected IConnection m_connection = null;
    protected SWarningListener m_warningListener = null;
    private boolean m_isInTransaction = false;
    private Stack<SSavepoint> m_savepoints = new Stack();
    private int m_savepointId = 1;
    private boolean m_allowTransactionCallbacks = true;
    protected final Object m_transactionLock = new Object();
    private boolean m_areMaxSizesAreSet = false;
    private boolean m_autoCommitDisabledInNotifyBegin = false;

    protected SConnection(IConnection conn, String url) throws SQLException {
        try {
            this.m_logger = conn.getConnectionLog();
            if (null == this.m_logger) {
                this.m_logger = new DSILogger("SimbaJDBC_Connection.log");
            }
            LogUtilities.logFunctionEntrance(this.m_logger, conn);
            this.m_URL = url;
            this.m_connection = conn;
            this.m_connection.registerTransactionStateListener(new STransactionStateListener(this));
            this.m_warningListener = new SWarningListener(this.m_connection.getMessageSource(), FunctionID.CONNECTION_UPDATE_SETTINGS);
            this.m_warningListener.setLocale(conn.getLocale());
            for (Warning warning : this.m_connection.getWarningListener().getWarnings()) {
                this.m_warningListener.postWarning(warning);
            }
            this.m_connection.registerWarningListener(this.m_warningListener);
            try {
                Variant driverVer = DSIDriverSingleton.getInstance().getProperty(5);
                LogUtilities.logInfo("Driver version is: " + driverVer.getString(), this.m_logger);
                Variant datasourceVer = this.m_connection.getProperty(170);
                LogUtilities.logInfo("Datasource version is: " + datasourceVer.getString(), this.m_logger);
            }
            catch (ErrorException e) {
                LogUtilities.logInfo("Wasn't able to retrieve driver/datasource version.", this.m_logger);
                LogUtilities.logInfo(e, this.m_logger);
            }
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            this.m_warningListener.clear();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        Object object = this.m_closingLock;
        synchronized (object) {
            if (!this.m_isClosed) {
                this.abortInternal();
                this.m_isClosed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void commit() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.checkIfOpen();
        Object object = this.m_transactionLock;
        synchronized (object) {
            try {
                if (this.getAutoCommit()) {
                    if (!this.isDataSourceReadOnly()) throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.COMMIT_AUTOCOMMIT, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
                    return;
                }
                if (!this.m_isInTransaction) {
                    return;
                }
                this.m_allowTransactionCallbacks = false;
                this.m_savepoints.clear();
                this.handleTransactionBehavior(37);
                this.m_connection.commit();
                this.m_isInTransaction = false;
            }
            catch (Exception e) {
                throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
            }
            finally {
                this.m_allowTransactionCallbacks = true;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statement createStatement() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            IStatement iStmt = this.m_connection.createStatement();
            SStatement stmt = JDBCObjectFactory.getInstance().createStatement(iStmt, this, 1007);
            List<WeakReference<SStatement>> list = this.m_stmtReferences;
            synchronized (list) {
                this.m_stmtReferences.add(new WeakReference<SStatement>(stmt));
            }
            return stmt;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, resultSetType, resultSetConcurrency);
        this.checkIfOpen();
        if (1003 != resultSetType || this.getConcurrency() < resultSetConcurrency || resultSetConcurrency != 1007 && resultSetConcurrency != 1008) {
            SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
            LogUtilities.logError(exception, this.m_logger);
            throw exception;
        }
        try {
            IStatement iStmt = this.m_connection.createStatement();
            SStatement stmt = JDBCObjectFactory.getInstance().createStatement(iStmt, this, resultSetConcurrency);
            List<WeakReference<SStatement>> list = this.m_stmtReferences;
            synchronized (list) {
                this.m_stmtReferences.add(new WeakReference<SStatement>(stmt));
            }
            return stmt;
        }
        catch (ErrorException e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener);
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.checkIfOpen();
        if (this.getHoldability() == resultSetHoldability) {
            return this.createStatement(resultSetType, resultSetConcurrency);
        }
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(exception, this.m_logger);
        throw exception;
    }

    public Object getAttribute(int key) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (!this.m_connection.isCustomProperty(key)) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_ATTRIBUTE, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, String.valueOf(key));
            }
            Variant attribute = this.m_connection.getCustomProperty(key);
            switch (attribute.getType()) {
                case 5: {
                    return attribute.getShort();
                }
                case 2: {
                    return Character.valueOf(attribute.getChar());
                }
                case 6: {
                    return attribute.getInt();
                }
                case 3: 
                case 7: {
                    return attribute.getLong();
                }
                case 4: {
                    return attribute.getBigInteger();
                }
            }
            return attribute.getString();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            Variant var = this.m_connection.getProperty(19);
            return 1L == var.getLong();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (!PropertyUtilities.hasCatalogSupport(this.m_connection)) {
                return null;
            }
            Variant var = this.m_connection.getProperty(22);
            return var.getString();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    public IConnection getDSIConnection() {
        return this.m_connection;
    }

    public IConnection getConnection() {
        return this.m_connection;
    }

    @Override
    public int getHoldability() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            long holdability = -1L;
            Variant var = this.m_connection.getProperty(37);
            holdability = var.getLong();
            if (1L == holdability || 0L == holdability) {
                return 2;
            }
            if (2L == holdability) {
                return 1;
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.UNKNOWN_HOLDABILITY, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, String.valueOf(holdability));
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            Object object = this.m_databaseMetadataLock;
            synchronized (object) {
                if (null == this.m_databaseMetaData) {
                    this.m_databaseMetaData = JDBCObjectFactory.getInstance().createDatabaseMetaData(this, this.m_logger);
                }
                return this.m_databaseMetaData;
            }
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            Variant var = this.m_connection.getProperty(26);
            long txnIsolation = var.getLong();
            if (0L == txnIsolation) {
                return 0;
            }
            if (2L == txnIsolation) {
                return 2;
            }
            if (1L == txnIsolation) {
                return 1;
            }
            if (4L == txnIsolation) {
                return 4;
            }
            if (8L == txnIsolation) {
                return 8;
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.UNKNOWN_ISOLATION, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, String.valueOf(txnIsolation));
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return new HashMap();
        }
        catch (SQLException e) {
            LogUtilities.logError(e, this.m_logger);
            throw e;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return this.m_warningListener.getSQLWarnings();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    public IWarningListener getWarningListener() {
        return this.m_warningListener;
    }

    @Override
    public boolean isClosed() {
        return this.m_isClosed;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            Variant readOnly = this.m_connection.getProperty(16);
            return readOnly.getLong() == Long.valueOf(1L).longValue();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, sql);
            this.checkIfOpen();
            return this.m_connection.toNativeSQL(sql);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, sql);
            this.checkIfOpen();
            if (!PropertyUtilities.hasStoredProcedureSupport(this.m_connection)) {
                SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
                LogUtilities.logError(exception, this.m_logger);
                throw exception;
            }
            this.beginTransaction();
            IStatement iStmt = this.m_connection.createStatement();
            SCallableStatement stmt = JDBCObjectFactory.getInstance().createCallableStatement(sql, iStmt, this, 1007);
            List<WeakReference<SStatement>> list = this.m_stmtReferences;
            synchronized (list) {
                this.m_stmtReferences.add(new WeakReference<SCallableStatement>(stmt));
            }
            return stmt;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, sql, resultSetType, resultSetConcurrency);
        this.checkIfOpen();
        if (!PropertyUtilities.hasStoredProcedureSupport(this.m_connection)) {
            SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
            LogUtilities.logError(exception, this.m_logger);
            throw exception;
        }
        if (1003 != resultSetType || this.getConcurrency() < resultSetConcurrency || resultSetConcurrency != 1007 && resultSetConcurrency != 1008) {
            SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
            LogUtilities.logError(exception, this.m_logger);
            throw exception;
        }
        try {
            this.beginTransaction();
            IStatement iStmt = this.m_connection.createStatement();
            SCallableStatement stmt = JDBCObjectFactory.getInstance().createCallableStatement(sql, iStmt, this, resultSetConcurrency);
            List<WeakReference<SStatement>> list = this.m_stmtReferences;
            synchronized (list) {
                this.m_stmtReferences.add(new WeakReference<SCallableStatement>(stmt));
            }
            return stmt;
        }
        catch (ErrorException e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener);
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.checkIfOpen();
        if (!PropertyUtilities.hasStoredProcedureSupport(this.m_connection)) {
            SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
            LogUtilities.logError(exception, this.m_logger);
            throw exception;
        }
        if (this.getHoldability() == resultSetHoldability) {
            return this.prepareCall(sql, resultSetType, resultSetConcurrency);
        }
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(exception, this.m_logger);
        throw exception;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, (ParameterGeneratedValues)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PreparedStatement prepareStatement(String sql, ParameterGeneratedValues generatedParams) throws SQLException {
        IStatement iStmt = null;
        SPreparedStatement stmt = null;
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, sql);
            this.checkIfOpen();
            this.beginTransaction();
            iStmt = this.m_connection.createStatement();
            stmt = JDBCObjectFactory.getInstance().createPreparedStatement(sql, iStmt, this, 1007);
            stmt.setGeneratedValues(generatedParams);
            List<WeakReference<SStatement>> list = this.m_stmtReferences;
            synchronized (list) {
                this.m_stmtReferences.add(new WeakReference<SPreparedStatement>(stmt));
            }
            return stmt;
        }
        catch (Exception e) {
            try {
                if (null != stmt) {
                    stmt.close();
                } else if (null != iStmt) {
                    iStmt.close();
                }
            }
            catch (ErrorException e2) {
                LogUtilities.logError(e2, this.m_logger);
            }
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, sql, autoGeneratedKeys);
            this.checkIfOpen();
            if (autoGeneratedKeys != 1 && autoGeneratedKeys != 2) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_OBJECT, (IWarningListener)this.m_warningListener, ExceptionType.DATA, new Object[0]);
            }
            if (this.getMetaData().supportsGetGeneratedKeys()) {
                return this.prepareStatement(sql, new ParameterGeneratedValues(autoGeneratedKeys));
            }
            if (autoGeneratedKeys == 1) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
            }
            return this.prepareStatement(sql);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, sql, resultSetType, resultSetConcurrency);
        this.checkIfOpen();
        if (1003 != resultSetType || this.getConcurrency() < resultSetConcurrency || resultSetConcurrency != 1007 && resultSetConcurrency != 1008) {
            SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
            LogUtilities.logError(exception, this.m_logger);
            throw exception;
        }
        IStatement iStmt = null;
        SPreparedStatement stmt = null;
        try {
            this.beginTransaction();
            iStmt = this.m_connection.createStatement();
            stmt = JDBCObjectFactory.getInstance().createPreparedStatement(sql, iStmt, this, resultSetConcurrency);
            List<WeakReference<SStatement>> list = this.m_stmtReferences;
            synchronized (list) {
                this.m_stmtReferences.add(new WeakReference<SPreparedStatement>(stmt));
            }
            return stmt;
        }
        catch (Exception e) {
            try {
                if (null != stmt) {
                    stmt.close();
                } else if (null != iStmt) {
                    iStmt.close();
                }
            }
            catch (ErrorException e2) {
                LogUtilities.logError(e2, this.m_logger);
            }
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.checkIfOpen();
        if (this.getHoldability() == resultSetHoldability) {
            return this.prepareStatement(sql, resultSetType, resultSetConcurrency);
        }
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(exception, this.m_logger);
        throw exception;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, sql, columnIndexes);
            this.checkIfOpen();
            if (this.getMetaData().supportsGetGeneratedKeys()) {
                return this.prepareStatement(sql, new ParameterGeneratedValues(columnIndexes));
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, sql, columnNames);
            this.checkIfOpen();
            if (this.getMetaData().supportsGetGeneratedKeys()) {
                return this.prepareStatement(sql, new ParameterGeneratedValues(columnNames));
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, savepoint);
        this.checkIfOpen();
        Object object = this.m_transactionLock;
        synchronized (object) {
            try {
                if (this.getAutoCommit()) {
                    if (this.isDataSourceReadOnly()) {
                        return;
                    }
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.ROLLBACK_AUTOCOMMIT, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
                }
                if (!this.m_savepoints.contains(savepoint)) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_SAVEPOINT, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
                }
                if (((SSavepoint)savepoint).isNamed()) {
                    this.m_connection.releaseSavepoint(savepoint.getSavepointName());
                } else {
                    this.m_connection.releaseSavepoint(String.valueOf(savepoint.getSavepointId()));
                }
                while (this.m_savepoints.pop() != savepoint) {
                }
            }
            catch (Exception e) {
                throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void rollback() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.checkIfOpen();
        Object object = this.m_transactionLock;
        synchronized (object) {
            try {
                if (this.getAutoCommit()) {
                    if (!this.isDataSourceReadOnly()) throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.ROLLBACK_AUTOCOMMIT, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
                    return;
                }
                if (!this.m_isInTransaction) {
                    return;
                }
                this.m_allowTransactionCallbacks = false;
                this.m_savepoints.clear();
                this.handleTransactionBehavior(38);
                this.m_connection.rollback();
                this.m_isInTransaction = false;
            }
            catch (Exception e) {
                throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
            }
            finally {
                this.m_allowTransactionCallbacks = true;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, savepoint);
        this.checkIfOpen();
        Object object = this.m_transactionLock;
        synchronized (object) {
            try {
                if (this.getAutoCommit()) {
                    if (this.isDataSourceReadOnly()) {
                        return;
                    }
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.ROLLBACK_AUTOCOMMIT, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
                }
                this.m_allowTransactionCallbacks = false;
                if (!this.m_savepoints.contains(savepoint)) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_SAVEPOINT, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
                }
                assert (this.m_isInTransaction);
                this.handleTransactionBehavior(38);
                if (((SSavepoint)savepoint).isNamed()) {
                    this.m_connection.rollback(savepoint.getSavepointName());
                } else {
                    this.m_connection.rollback(String.valueOf(savepoint.getSavepointId()));
                }
                while (this.m_savepoints.pop() != savepoint) {
                }
            }
            catch (Exception e) {
                throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
            }
            finally {
                this.m_allowTransactionCallbacks = true;
            }
        }
    }

    public void setAttribute(int key, Object value) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (!this.m_connection.isCustomProperty(key)) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_ATTRIBUTE, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, String.valueOf(key));
            }
            int type = this.m_connection.getCustomPropertyType(key);
            this.m_connection.setCustomProperty(key, new Variant(type, value));
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, autoCommit);
        this.checkIfOpen();
        Object object = this.m_transactionLock;
        synchronized (object) {
            try {
                if (!autoCommit && !this.getMetaData().supportsTransactions()) {
                    if (this.isDataSourceReadOnly()) {
                        return;
                    }
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
                }
                this.m_allowTransactionCallbacks = false;
                Long aCommit = null;
                if (autoCommit) {
                    aCommit = 1L;
                    if (this.m_isInTransaction) {
                        this.handleTransactionBehavior(37);
                        this.m_connection.commit();
                    }
                    this.m_isInTransaction = false;
                } else {
                    aCommit = 0L;
                }
                Variant var = new Variant(3, aCommit);
                this.m_warningListener.clearAndSetFunction(FunctionID.CONNECTION_SET_PROPERTY);
                this.m_connection.setProperty(19, var);
            }
            catch (Exception e) {
                throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
            }
            finally {
                this.m_allowTransactionCallbacks = true;
            }
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, catalog);
            this.checkIfOpen();
            if (!PropertyUtilities.hasCatalogSupport(this.m_connection)) {
                return;
            }
            Variant currentCatalogVar = null;
            currentCatalogVar = null == catalog ? new Variant(0, "") : new Variant(0, catalog);
            this.m_warningListener.clearAndSetFunction(FunctionID.CONNECTION_SET_PROPERTY);
            this.m_connection.setProperty(22, currentCatalogVar);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, holdability);
            this.checkIfOpen();
            if (!this.getMetaData().supportsResultSetHoldability(holdability)) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.UNSUPPORTED_HOLDABILITY, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, String.valueOf(holdability));
            }
            Character hold = null;
            switch (holdability) {
                case 2: {
                    hold = Character.valueOf('\u0001');
                    break;
                }
                case 1: {
                    hold = Character.valueOf('\u0002');
                    break;
                }
                default: {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.UNKNOWN_HOLDABILITY, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, String.valueOf(holdability));
                }
            }
            Variant var = new Variant(2, hold);
            this.m_warningListener.clearAndSetFunction(FunctionID.CONNECTION_SET_PROPERTY);
            this.m_connection.setProperty(37, var);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, readOnly);
            this.checkIfOpen();
            if (this.m_isInTransaction) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.SETREADONLY_IN_TRANSACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            }
            Variant setReadOnly = readOnly ? new Variant(3, 1L) : new Variant(3, 0L);
            this.m_warningListener.clearAndSetFunction(FunctionID.CONNECTION_SET_PROPERTY);
            this.m_connection.setProperty(16, setReadOnly);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.checkIfOpen();
        Object object = this.m_transactionLock;
        synchronized (object) {
            try {
                if (this.getAutoCommit()) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.SAVEPOINT_AUTOCOMMIT, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
                }
                if (!this.m_isInTransaction && this.m_connection.getProperty(1009).getInt() == 0) {
                    this.m_connection.beginTransaction();
                    this.m_isInTransaction = true;
                }
                this.m_connection.createSavepoint(String.valueOf(this.m_savepointId));
                this.m_isInTransaction = true;
                SSavepoint savepoint = new SSavepoint(this.m_savepointId, this.m_logger, (IWarningListener)this.m_warningListener);
                ++this.m_savepointId;
                this.m_savepoints.push(savepoint);
                return savepoint;
            }
            catch (Exception e) {
                throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
            }
        }
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, name);
        this.checkIfOpen();
        Object object = this.m_transactionLock;
        synchronized (object) {
            try {
                if (this.getAutoCommit()) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.SAVEPOINT_AUTOCOMMIT, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
                }
                if (!this.m_isInTransaction && this.m_connection.getProperty(1009).getInt() == 0) {
                    this.m_connection.beginTransaction();
                    this.m_isInTransaction = true;
                }
                this.m_connection.createSavepoint(name);
                this.m_isInTransaction = true;
                SSavepoint savepoint = new SSavepoint(name, this.m_logger, (IWarningListener)this.m_warningListener);
                ++this.m_savepointId;
                this.m_savepoints.push(savepoint);
                return savepoint;
            }
            catch (Exception e) {
                throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
            }
        }
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, level);
            this.checkIfOpen();
            Long txnLevel = null;
            DatabaseMetaData dbMeta = this.getMetaData();
            switch (level) {
                case 1: {
                    if (dbMeta.supportsTransactionIsolationLevel(1)) {
                        txnLevel = 1L;
                        break;
                    }
                }
                case 2: {
                    if (dbMeta.supportsTransactionIsolationLevel(2)) {
                        txnLevel = 2L;
                        break;
                    }
                }
                case 4: {
                    if (dbMeta.supportsTransactionIsolationLevel(4)) {
                        txnLevel = 4L;
                        break;
                    }
                }
                case 8: {
                    if (dbMeta.supportsTransactionIsolationLevel(8)) {
                        txnLevel = 8L;
                        break;
                    }
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.UNSUPPORTED_TXN_ISOLATION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, String.valueOf(level));
                }
                default: {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.UNKNOWN_ISOLATION, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, String.valueOf(level));
                }
            }
            Variant var = new Variant(3, txnLevel);
            this.m_warningListener.clearAndSetFunction(FunctionID.CONNECTION_SET_PROPERTY);
            this.m_connection.setProperty(26, var);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, map);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, typeName, elements);
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(exception, this.m_logger);
        throw exception;
    }

    @Override
    public Blob createBlob() throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(exception, this.m_logger);
        throw exception;
    }

    @Override
    public Clob createClob() throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(exception, this.m_logger);
        throw exception;
    }

    @Override
    public NClob createNClob() throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(exception, this.m_logger);
        throw exception;
    }

    @Override
    public SQLXML createSQLXML() throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(exception, this.m_logger);
        throw exception;
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, typeName, attributes);
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(exception, this.m_logger);
        throw exception;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.checkIfOpen();
        Properties clientInfo = new Properties();
        Set<String> clientInfoProperties = this.m_connection.getClientInfoProperties().keySet();
        for (String propertyName : clientInfoProperties) {
            try {
                String propertyValue = this.m_connection.getClientInfo(propertyName);
                if (null == propertyValue) continue;
                clientInfo.setProperty(propertyName, propertyValue);
            }
            catch (ErrorException e) {
                throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
            }
        }
        return clientInfo;
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.checkIfOpen();
        try {
            return this.m_connection.getClientInfo(name);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean isValid(int timeout) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return WrapperUtilities.isWrapperFor(iface, this);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            this.checkIfOpen();
        }
        catch (SQLException e) {
            throw (SQLClientInfoException)ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONNECTION_CLOSED, (IWarningListener)this.m_warningListener, ExceptionType.CLIENT_INFO, new Object[0]);
        }
        Map<String, ClientInfoData> existingProperties = this.m_connection.getClientInfoProperties();
        for (Map.Entry<String, ClientInfoData> currentProperty : existingProperties.entrySet()) {
            String key = currentProperty.getKey();
            if (null != properties && properties.containsKey(key)) {
                this.setClientInfo(key, properties.getProperty(key));
                properties.remove(key);
                continue;
            }
            this.setClientInfo(key, null);
        }
        if (null != properties && 0 != properties.size()) {
            HashMap<String, FailedPropertiesReason> failures = new HashMap<String, FailedPropertiesReason>();
            Iterator<Object> i$ = properties.keySet().iterator();
            if (i$.hasNext()) {
                Object propertyName = i$.next();
                failures.put(propertyName.toString(), FailedPropertiesReason.UNKNOWN_PROPERTY);
                throw (SQLClientInfoException)ExceptionConverter.getInstance().toSQLException(DSIDriver.s_DSIMessages.createClientInfoException(DSIMessageKey.INVALID_PROPKEY.name(), propertyName.toString(), failures), this.m_warningListener, this.m_logger);
            }
        }
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            this.checkIfOpen();
        }
        catch (SQLException e) {
            throw (SQLClientInfoException)ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONNECTION_CLOSED, (IWarningListener)this.m_warningListener, ExceptionType.CLIENT_INFO, new Object[0]);
        }
        try {
            this.m_connection.setClientInfoProperty(name, value);
        }
        catch (ClientInfoException e) {
            throw (SQLClientInfoException)ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return WrapperUtilities.unwrap(iface, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void beginTransaction() throws SQLException {
        Object object = this.m_transactionLock;
        synchronized (object) {
            if (!this.getAutoCommit() && !this.m_isInTransaction) {
                try {
                    this.m_connection.beginTransaction();
                    this.m_isInTransaction = true;
                }
                catch (Exception e) {
                    throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeChildObjects() {
        Object object = this.m_transactionLock;
        synchronized (object) {
            if (this.m_isInTransaction) {
                try {
                    this.rollback();
                }
                catch (SQLException e) {
                    LogUtilities.logError(e, this.m_logger);
                }
            }
        }
        this.closeChildStatements();
        object = this.m_databaseMetadataLock;
        synchronized (object) {
            if (null != this.m_databaseMetaData) {
                try {
                    this.m_databaseMetaData.closeMetaData();
                }
                catch (Exception e) {
                    LogUtilities.logError(e, this.m_logger);
                }
                this.m_databaseMetaData = null;
            }
        }
    }

    String getURL() {
        return this.m_URL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isInTransaction() {
        Object object = this.m_transactionLock;
        synchronized (object) {
            return this.m_isInTransaction;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyBeginTransaction() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        Object object = this.m_transactionLock;
        synchronized (object) {
            try {
                if (!this.m_allowTransactionCallbacks) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.TRANSACTION_CALLBACKS_NOT_ALLOWED, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
                }
                if (this.m_isInTransaction) {
                    ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.TRANSACTION_ALREADY_STARTED, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
                }
                if (this.getAutoCommit()) {
                    Variant var = new Variant(3, 0L);
                    this.m_autoCommitDisabledInNotifyBegin = true;
                    this.m_warningListener.clearAndSetFunction(FunctionID.CONNECTION_SET_PROPERTY);
                    this.m_connection.setProperty(19, var);
                }
                this.m_isInTransaction = true;
            }
            catch (SQLException e) {
                throw new GeneralException(e.getLocalizedMessage(), e.getErrorCode(), (Throwable)e);
            }
            catch (Exception e) {
                throw new GeneralException(e.getLocalizedMessage(), 0, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyCommit() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        Object object = this.m_transactionLock;
        synchronized (object) {
            try {
                if (!this.m_allowTransactionCallbacks) {
                    ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.TRANSACTION_CALLBACKS_NOT_ALLOWED, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
                }
                if (this.getAutoCommit()) {
                    if (this.isDataSourceReadOnly()) {
                        return;
                    }
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.COMMIT_AUTOCOMMIT, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
                }
                assert (this.m_isInTransaction);
                this.m_savepoints.clear();
                this.handleTransactionBehavior(37);
                this.finishTransaction();
            }
            catch (SQLException e) {
                throw new GeneralException(e.getLocalizedMessage(), e.getErrorCode(), (Throwable)e);
            }
            catch (Exception e) {
                throw new GeneralException(e.getLocalizedMessage(), 0, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyCreateSavepoint(String name) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, name);
        Object object = this.m_transactionLock;
        synchronized (object) {
            try {
                if (!this.m_allowTransactionCallbacks) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.TRANSACTION_CALLBACKS_NOT_ALLOWED, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
                }
                if (this.getAutoCommit()) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.SAVEPOINT_AUTOCOMMIT, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
                }
                assert (this.m_isInTransaction);
                this.m_savepoints.push(new SSavepoint(name, this.m_logger, (IWarningListener)this.m_warningListener));
                ++this.m_savepointId;
            }
            catch (SQLException e) {
                throw new GeneralException(e.getLocalizedMessage(), e.getErrorCode(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyReleaseSavepoint(String name) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, name);
        Object object = this.m_transactionLock;
        synchronized (object) {
            try {
                if (!this.m_allowTransactionCallbacks) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.TRANSACTION_CALLBACKS_NOT_ALLOWED, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
                }
                if (this.getAutoCommit()) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.SAVEPOINT_AUTOCOMMIT, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
                }
                assert (this.m_isInTransaction);
                int savepointIndex = this.getSavepointIndex(name);
                while (this.m_savepoints.size() > savepointIndex) {
                    this.m_savepoints.pop();
                }
            }
            catch (SQLException e) {
                throw new GeneralException(e.getLocalizedMessage(), e.getErrorCode(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyRollback() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        Object object = this.m_transactionLock;
        synchronized (object) {
            try {
                if (!this.m_allowTransactionCallbacks) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.TRANSACTION_CALLBACKS_NOT_ALLOWED, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
                }
                if (this.getAutoCommit()) {
                    if (this.isDataSourceReadOnly()) {
                        return;
                    }
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.COMMIT_AUTOCOMMIT, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
                }
                assert (this.m_isInTransaction);
                this.m_savepoints.clear();
                this.handleTransactionBehavior(38);
                this.finishTransaction();
            }
            catch (SQLException e) {
                throw new GeneralException(e.getLocalizedMessage(), e.getErrorCode(), (Throwable)e);
            }
            catch (Exception e) {
                throw new GeneralException(e.getLocalizedMessage(), 0, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyRollbackSavepoint(String name) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, name);
        Object object = this.m_transactionLock;
        synchronized (object) {
            try {
                if (!this.m_allowTransactionCallbacks) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.TRANSACTION_CALLBACKS_NOT_ALLOWED, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
                }
                if (this.getAutoCommit()) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.SAVEPOINT_AUTOCOMMIT, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
                }
                assert (this.m_isInTransaction);
                int savepointIndex = this.getSavepointIndex(name);
                this.handleTransactionBehavior(38);
                while (this.m_savepoints.size() > savepointIndex) {
                    this.m_savepoints.pop();
                }
            }
            catch (SQLException e) {
                throw new GeneralException(e.getLocalizedMessage(), e.getErrorCode(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeStatement(SStatement statement) {
        List<WeakReference<SStatement>> list = this.m_stmtReferences;
        synchronized (list) {
            for (int i = this.m_stmtReferences.size() - 1; i >= 0; --i) {
                SStatement stmt;
                WeakReference<SStatement> stmtRef = this.m_stmtReferences.get(i);
                if (null == stmtRef || null != (stmt = (SStatement)stmtRef.get()) && stmt != statement) continue;
                this.m_stmtReferences.remove(i);
            }
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    private void finishTransaction() throws Exception {
        if (this.m_autoCommitDisabledInNotifyBegin) {
            Variant var = new Variant(3, 1L);
            this.m_warningListener.clearAndSetFunction(FunctionID.CONNECTION_SET_PROPERTY);
            this.m_connection.setProperty(19, var);
            this.m_autoCommitDisabledInNotifyBegin = false;
            this.m_isInTransaction = false;
        } else {
            this.m_connection.beginTransaction();
            this.m_isInTransaction = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setMaxTypeValues() throws SQLException {
        if (this.m_areMaxSizesAreSet) {
            return;
        }
        try {
            Variant v = this.m_connection.getProperty(1004);
            this.m_maxVarbinarySize = v.getInt();
            v = this.m_connection.getProperty(1005);
            this.m_maxVarcharSize = v.getInt();
        }
        catch (Exception e) {
            this.m_maxVarbinarySize = 0;
            this.m_maxVarcharSize = 0;
        }
        if (0 == this.m_maxVarbinarySize || 0 == this.m_maxVarcharSize) {
            ResultSet result = this.getMetaData().getTypeInfo();
            try {
                while (result.next()) {
                    int maxSize;
                    int type = result.getInt(2);
                    if (12 == type) {
                        maxSize = result.getInt(3);
                        if (!result.wasNull()) {
                            this.m_maxVarcharSize = maxSize;
                        }
                        if (0 == this.m_maxVarbinarySize) continue;
                    } else {
                        if (-3 != type) continue;
                        maxSize = result.getInt(3);
                        if (!result.wasNull()) {
                            this.m_maxVarbinarySize = maxSize;
                        }
                        if (0 == this.m_maxVarcharSize) continue;
                    }
                    break;
                }
            }
            finally {
                result.close();
            }
        }
        this.m_areMaxSizesAreSet = true;
    }

    protected void checkIfOpen() throws SQLException {
        if (this.isClosed()) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONNECTION_CLOSED, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT_CONNECTION, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void abortInternal() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            this.closeChildObjects();
        }
        finally {
            this.closeConnection();
        }
    }

    protected synchronized void markConnectionClosed() {
        this.m_isClosed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeChildStatements() {
        ArrayList<SStatement> statements = new ArrayList<SStatement>();
        List<WeakReference<SStatement>> list = this.m_stmtReferences;
        synchronized (list) {
            for (WeakReference<SStatement> stmtRef : this.m_stmtReferences) {
                SStatement stmt;
                if (null == stmtRef || null == (stmt = (SStatement)stmtRef.get())) continue;
                statements.add(stmt);
            }
            this.m_stmtReferences.clear();
        }
        for (SStatement stmt : statements) {
            try {
                stmt.close();
            }
            catch (Exception e) {}
        }
    }

    private void closeConnection() throws SQLException {
        if (null != this.m_connection) {
            try {
                this.m_connection.disconnect();
            }
            catch (ErrorException e) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONNECTION_CLOSED, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT_CONNECTION, new Object[0]);
            }
            finally {
                this.m_connection.close();
                this.m_connection = null;
            }
        }
    }

    private int getConcurrency() throws SQLException {
        try {
            Variant var = this.m_connection.getProperty(1001);
            if (0L != var.getLong()) {
                return 1008;
            }
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener);
        }
        return 1007;
    }

    private int getSavepointIndex(String name) throws SQLException {
        for (int i = this.m_savepoints.size() - 1; i >= 0; --i) {
            SSavepoint savepoint = (SSavepoint)this.m_savepoints.get(i);
            if ((!savepoint.isNamed() || !name.equals(savepoint.getSavepointName())) && (savepoint.isNamed() || !name.equals(String.valueOf(savepoint.getSavepointId())))) continue;
            return i;
        }
        throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_SAVEPOINT, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTransactionBehavior(int cursorTransactionKey) throws SQLException {
        block13: {
            try {
                Variant var = this.m_connection.getProperty(cursorTransactionKey);
                long cursorBehavior = var.getLong();
                if (1L == cursorBehavior) {
                    List<WeakReference<SStatement>> list = this.m_stmtReferences;
                    synchronized (list) {
                        for (int i = this.m_stmtReferences.size() - 1; i >= 0; --i) {
                            WeakReference<SStatement> stmtRef = this.m_stmtReferences.get(i);
                            if (null == stmtRef) continue;
                            SStatement statement = (SStatement)stmtRef.get();
                            if (null != statement) {
                                statement.closeResults();
                                continue;
                            }
                            this.m_stmtReferences.remove(i);
                        }
                        break block13;
                    }
                }
                if (0L != cursorBehavior) break block13;
                List<WeakReference<SStatement>> list = this.m_stmtReferences;
                synchronized (list) {
                    for (int i = this.m_stmtReferences.size() - 1; i >= 0; --i) {
                        WeakReference<SStatement> stmtRef = this.m_stmtReferences.get(i);
                        if (null == stmtRef) continue;
                        SStatement statement = (SStatement)stmtRef.get();
                        if (null != statement) {
                            statement.closeResults();
                            statement.closeIfPrepared();
                            continue;
                        }
                        this.m_stmtReferences.remove(i);
                    }
                }
            }
            catch (Exception e) {
                throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener);
            }
        }
    }

    private boolean isDataSourceReadOnly() {
        try {
            Variant readOnly = this.m_connection.getProperty(40);
            return readOnly.getString().equals("Y");
        }
        catch (ErrorException e) {
            LogUtilities.logError(e, this.m_logger);
            return true;
        }
    }

    protected static class Handler
    implements Callable<Boolean> {
        private IConnection m_connection;

        public Handler(IConnection connection) {
            this.m_connection = connection;
        }

        @Override
        public Boolean call() throws Exception {
            return this.m_connection.isAlive();
        }
    }
}

