/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc.jdbc42;

import com.vertica.dsi.core.interfaces.IConnection;
import com.vertica.dsi.dataengine.interfaces.IResultSet;
import com.vertica.exceptions.ExceptionConverter;
import com.vertica.exceptions.JDBCMessageKey;
import com.vertica.jdbc.jdbc42.S42Array;
import com.vertica.jdbc.jdbc42.S42ForwardResultSet;
import com.vertica.support.ILogger;
import com.vertica.support.IWarningListener;
import com.vertica.support.exceptions.ExceptionType;
import java.sql.SQLException;

public class S42ArrayResultSet
extends S42ForwardResultSet {
    private S42Array m_parentArray;

    public S42ArrayResultSet(S42Array array, IResultSet resultSet, ILogger logger) throws SQLException {
        super(null, resultSet, logger);
        this.m_parentArray = array;
        this.initializeColumnNameMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void checkIfOpen() throws SQLException {
        S42ArrayResultSet s42ArrayResultSet = this;
        synchronized (s42ArrayResultSet) {
            if (!this.m_isOpen) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.RESULTSET_CLOSED, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
            }
        }
    }

    @Override
    protected IConnection getParentConnection() throws SQLException {
        return this.m_parentArray.getParentConnection();
    }
}

