/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.service.sms.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.volcengine.error.SdkError;
import com.volcengine.model.ServiceInfo;
import com.volcengine.model.request.SmsBatchSendRequest;
import com.volcengine.model.request.SmsCheckVerifyCodeRequest;
import com.volcengine.model.request.SmsSendRequest;
import com.volcengine.model.request.SmsSendVerifyCodeRequest;
import com.volcengine.model.response.RawResponse;
import com.volcengine.model.response.ResponseMetadata;
import com.volcengine.model.response.SmsCheckVerifyCodeResponse;
import com.volcengine.model.response.SmsSendResponse;
import com.volcengine.service.BaseServiceImpl;
import com.volcengine.service.sms.SmsConfig;
import com.volcengine.service.sms.SmsService;
import java.util.ArrayList;
import org.apache.http.NameValuePair;

public class SmsServiceImpl
extends BaseServiceImpl
implements SmsService {
    private SmsServiceImpl() {
        super(SmsConfig.serviceInfoMap.get("cn-north-1"), SmsConfig.apiInfoList);
    }

    private SmsServiceImpl(ServiceInfo serviceInfo) {
        super(serviceInfo, SmsConfig.apiInfoList);
    }

    public static SmsService getInstance() {
        return new SmsServiceImpl();
    }

    public static SmsService getInstance(String region) throws Exception {
        ServiceInfo serviceInfo = SmsConfig.serviceInfoMap.get(region);
        if (serviceInfo == null) {
            throw new Exception("Edit not support region " + region);
        }
        return new SmsServiceImpl(serviceInfo);
    }

    public static SmsService newSmsService(ServiceInfo serviceInfo) throws Exception {
        if (serviceInfo == null) {
            throw new Exception("ServiceInfo is null");
        }
        return new SmsServiceImpl(serviceInfo);
    }

    @Override
    public SmsSendResponse send(SmsSendRequest smsSendRequest) throws Exception {
        RawResponse response = this.json("SendSms", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)smsSendRequest));
        if (response.getCode() == SdkError.EHTTP.getNumber()) {
            response = this.json("SendSms", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)smsSendRequest));
        }
        return this.getSmsSendResponse(response);
    }

    @Override
    public SmsSendResponse batchSend(SmsBatchSendRequest smsBatchSendRequest) throws Exception {
        RawResponse response = this.json("SendBatchSms", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)smsBatchSendRequest));
        if (response.getCode() == SdkError.EHTTP.getNumber()) {
            response = this.json("SendBatchSms", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)smsBatchSendRequest));
        }
        return this.getSmsSendResponse(response);
    }

    @Override
    public SmsSendResponse sendVerifyCode(SmsSendVerifyCodeRequest smsSendVerifyCodeRequest) throws Exception {
        RawResponse response = this.json("SendSmsVerifyCode", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)smsSendVerifyCodeRequest));
        return this.getSmsSendResponse(response);
    }

    @Override
    public SmsCheckVerifyCodeResponse checkVerifyCode(SmsCheckVerifyCodeRequest smsCheckVerifyCodeRequest) throws Exception {
        RawResponse response = this.json("CheckSmsVerifyCode", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)smsCheckVerifyCodeRequest));
        return this.getSmsCheckResponse(response);
    }

    private SmsSendResponse getSmsSendResponse(RawResponse response) throws Exception {
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        SmsSendResponse res = (SmsSendResponse)JSON.parseObject((byte[])response.getData(), SmsSendResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error: " + meta.getError().getMessage());
        }
        res.getResponseMetadata().setService("volcSMS");
        return res;
    }

    private SmsCheckVerifyCodeResponse getSmsCheckResponse(RawResponse response) throws Exception {
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        SmsCheckVerifyCodeResponse res = (SmsCheckVerifyCodeResponse)JSON.parseObject((byte[])response.getData(), SmsCheckVerifyCodeResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error:" + meta.getError().getMessage());
        }
        res.getResponseMetadata().setService("volcSMS");
        return res;
    }
}

