/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.service.vod.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.rholder.retry.RetryException;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.WaitStrategies;
import com.google.common.base.Predicates;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import com.volcengine.error.SdkError;
import com.volcengine.helper.Utils;
import com.volcengine.model.ServiceInfo;
import com.volcengine.model.beans.UploadCompleteInfo;
import com.volcengine.model.response.RawResponse;
import com.volcengine.model.sts2.Policy;
import com.volcengine.model.sts2.SecurityToken2;
import com.volcengine.model.sts2.Statement;
import com.volcengine.service.BaseServiceImpl;
import com.volcengine.service.vod.IVodService;
import com.volcengine.service.vod.VodConfig;
import com.volcengine.service.vod.model.business.VodUploadAddress;
import com.volcengine.service.vod.model.request.VodApplyUploadInfoRequest;
import com.volcengine.service.vod.model.request.VodCommitUploadInfoRequest;
import com.volcengine.service.vod.model.request.VodDeleteMediaRequest;
import com.volcengine.service.vod.model.request.VodDeleteTranscodesRequest;
import com.volcengine.service.vod.model.request.VodGetHlsDecryptionKeyRequest;
import com.volcengine.service.vod.model.request.VodGetMediaInfosRequest;
import com.volcengine.service.vod.model.request.VodGetMediaListRequest;
import com.volcengine.service.vod.model.request.VodGetPlayInfoRequest;
import com.volcengine.service.vod.model.request.VodGetPrivateDrmPlayAuthRequest;
import com.volcengine.service.vod.model.request.VodGetRecommendedPosterRequest;
import com.volcengine.service.vod.model.request.VodGetSubtitleInfoListRequest;
import com.volcengine.service.vod.model.request.VodQueryUploadTaskInfoRequest;
import com.volcengine.service.vod.model.request.VodStartWorkflowRequest;
import com.volcengine.service.vod.model.request.VodUpdateMediaInfoRequest;
import com.volcengine.service.vod.model.request.VodUpdateMediaPublishStatusRequest;
import com.volcengine.service.vod.model.request.VodUpdateSubtitleInfoRequest;
import com.volcengine.service.vod.model.request.VodUpdateSubtitleStatusRequest;
import com.volcengine.service.vod.model.request.VodUploadMaterialRequest;
import com.volcengine.service.vod.model.request.VodUploadMediaRequest;
import com.volcengine.service.vod.model.request.VodUrlUploadRequest;
import com.volcengine.service.vod.model.response.VodApplyUploadInfoResponse;
import com.volcengine.service.vod.model.response.VodCommitUploadInfoResponse;
import com.volcengine.service.vod.model.response.VodDeleteMediaResponse;
import com.volcengine.service.vod.model.response.VodDeleteTranscodesResponse;
import com.volcengine.service.vod.model.response.VodGetHlsDecryptionKeyResponse;
import com.volcengine.service.vod.model.response.VodGetMediaInfosResponse;
import com.volcengine.service.vod.model.response.VodGetMediaListResponse;
import com.volcengine.service.vod.model.response.VodGetPlayInfoResponse;
import com.volcengine.service.vod.model.response.VodGetPrivateDrmPlayAuthResponse;
import com.volcengine.service.vod.model.response.VodGetRecommendedPosterResponse;
import com.volcengine.service.vod.model.response.VodGetSubtitleInfoListResponse;
import com.volcengine.service.vod.model.response.VodQueryUploadTaskInfoResponse;
import com.volcengine.service.vod.model.response.VodStartWorkflowResponse;
import com.volcengine.service.vod.model.response.VodUpdateMediaInfoResponse;
import com.volcengine.service.vod.model.response.VodUpdateMediaPublishStatusResponse;
import com.volcengine.service.vod.model.response.VodUpdateSubtitleInfoResponse;
import com.volcengine.service.vod.model.response.VodUpdateSubtitleStatusResponse;
import com.volcengine.service.vod.model.response.VodUrlUploadResponse;
import com.volcengine.util.Sts2Utils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;

public class VodServiceImpl
extends BaseServiceImpl
implements IVodService {
    protected VodServiceImpl() {
        super(VodConfig.ServiceInfoMap.get("cn-north-1"), VodConfig.apiInfoList);
    }

    private VodServiceImpl(ServiceInfo serviceInfo) {
        super(serviceInfo, VodConfig.apiInfoList);
    }

    public static IVodService getInstance() {
        return new VodServiceImpl();
    }

    public static IVodService getInstance(String region) throws Exception {
        ServiceInfo serviceInfo = VodConfig.ServiceInfoMap.get(region);
        if (serviceInfo == null) {
            throw new Exception("Cant find the region, please check it carefully");
        }
        return new VodServiceImpl(serviceInfo);
    }

    @Override
    public String createSha1HlsDrmAuthToken(Long expireSeconds) throws Exception {
        return this.createHlsDrmAuthToken("HMAC-SHA1", expireSeconds);
    }

    public String createHlsDrmAuthToken(String dsa, Long expireSeconds) throws Exception {
        if (expireSeconds == null || expireSeconds == 0L) {
            throw new Exception("Invalid Expire");
        }
        String token = this.createAuth(dsa, expireSeconds);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("DrmAuthToken", token);
        return this.getSignUrl("GetHlsDecryptionKey", Utils.mapToPairList(params));
    }

    private String createAuth(String dsa, long expireSeconds) throws Exception {
        if (StringUtils.isBlank((CharSequence)this.getAccessKey())) {
            throw new Exception("Invalid Ak");
        }
        if (StringUtils.isBlank((CharSequence)this.getSecretKey())) {
            throw new Exception("Invalid Sk");
        }
        long deadline = System.currentTimeMillis() / 1000L + expireSeconds;
        TimeZone tz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        df.setTimeZone(tz);
        String deadlineDate = df.format(new Date(deadline * 1000L));
        String timestamp = String.valueOf(deadline);
        byte[] kDate = Utils.hmacSHA256(this.getSecretKey().getBytes(), deadlineDate);
        byte[] kRegion = Utils.hmacSHA256(kDate, this.getRegion());
        byte[] kService = Utils.hmacSHA256(kRegion, "vod");
        byte[] kCredentials = Utils.hmacSHA256(kService, "request");
        String key = Hex.encodeHexString((byte[])kCredentials);
        String signDataString = StringUtils.join((Object[])new String[]{dsa, "&", "2.0", "&", timestamp});
        String sign = "";
        switch (dsa) {
            case "HMAC-SHA1": {
                sign = Base64.encodeBase64String((byte[])Utils.hmacSHA1(key.getBytes(), signDataString));
                break;
            }
            case "HMAC-SHA256": {
                sign = Base64.encodeBase64String((byte[])Utils.hmacSHA256(key.getBytes(), signDataString));
                break;
            }
            default: {
                sign = Base64.encodeBase64String((byte[])"".getBytes());
            }
        }
        return StringUtils.join((Object[])new String[]{dsa, ":", "2.0", ":", timestamp, ":", this.getAccessKey(), ":", sign});
    }

    @Override
    public String getSubtitleAuthToken(VodGetSubtitleInfoListRequest input, Long expireSeconds) throws Exception {
        if (input.getVid() == "") {
            throw new Exception("\u4f20\u5165\u7684Vid\u4e3a\u7a7a");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Vid", input.getVid());
        params.put("Status", "Published");
        if (expireSeconds != null && expireSeconds > 0L) {
            params.put("X-Expires", expireSeconds.toString());
        }
        String getSubtitleAuthToken = this.getSignUrl("GetSubtitleInfoList", Utils.mapToPairList(params));
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("GetSubtitleAuthToken", getSubtitleAuthToken);
        String retStr = JSON.toJSONString(ret);
        Base64.Encoder encoder = java.util.Base64.getEncoder();
        return encoder.encodeToString(retStr.getBytes());
    }

    @Override
    public String getPlayAuthToken(VodGetPlayInfoRequest input, Long expireSeconds) throws Exception {
        Map<String, String> params = Utils.protoBufferToMap(input, false);
        if (expireSeconds != null && expireSeconds > 0L) {
            params.put("X-Expires", expireSeconds.toString());
        }
        String getPlayInfoToken = this.getSignUrl("GetPlayInfo", Utils.mapToPairList(params));
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("GetPlayInfoToken", getPlayInfoToken);
        ret.put("TokenVersion", "V2");
        String retStr = JSON.toJSONString(ret);
        Base64.Encoder encoder = java.util.Base64.getEncoder();
        return encoder.encodeToString(retStr.getBytes());
    }

    @Override
    public SecurityToken2 getUploadSts2() throws Exception {
        return this.getUploadSts2WithExpire(3600000L);
    }

    @Override
    public SecurityToken2 getUploadSts2WithExpire(long expire) throws Exception {
        Policy inlinePolicy = new Policy();
        ArrayList<String> actions = new ArrayList<String>();
        actions.add("vod:ApplyUploadInfo");
        actions.add("vod:CommitUploadInfo");
        ArrayList<String> resources = new ArrayList<String>();
        Statement statement = Sts2Utils.newAllowStatement(actions, resources);
        inlinePolicy.addStatement(statement);
        return this.signSts2(inlinePolicy, expire);
    }

    @Override
    public VodCommitUploadInfoResponse uploadMedia(VodUploadMediaRequest vodUploadMediaRequest) throws Exception {
        UploadCompleteInfo uploadCompleteInfo = this.uploadToB(vodUploadMediaRequest.getSpaceName(), vodUploadMediaRequest.getFilePath(), "media");
        VodCommitUploadInfoRequest vodCommitUploadInfoRequest = VodCommitUploadInfoRequest.newBuilder().setSpaceName(vodUploadMediaRequest.getSpaceName()).setSessionKey(uploadCompleteInfo.getSessionKey()).setFunctions(vodUploadMediaRequest.getFunctions()).setCallbackArgs(vodUploadMediaRequest.getCallbackArgs()).build();
        return this.commitUploadInfo(vodCommitUploadInfoRequest);
    }

    private UploadCompleteInfo uploadToB(String spaceName, String filePath, String fileType) throws Exception {
        File file = new File(filePath);
        if (!file.isFile() || !file.exists()) {
            throw new Exception(SdkError.getErrorDesc(SdkError.ENOFILE));
        }
        VodApplyUploadInfoRequest vodApplyUploadInfoRequest = VodApplyUploadInfoRequest.newBuilder().setSpaceName(spaceName).setFileType(fileType).build();
        VodApplyUploadInfoResponse vodApplyUploadInfoResponse = this.applyUploadInfo(vodApplyUploadInfoRequest);
        if (vodApplyUploadInfoResponse.getResponseMetadata().hasError()) {
            throw new Exception(vodApplyUploadInfoResponse.getResponseMetadata().getError().getMessage());
        }
        VodUploadAddress vodUploadAddress = vodApplyUploadInfoResponse.getResult().getData().getUploadAddress();
        if (!vodApplyUploadInfoResponse.hasResult() || vodUploadAddress.getStoreInfosCount() == 0) {
            throw new Exception("apply upload result is null");
        }
        String oid = vodUploadAddress.getStoreInfos(0).getStoreUri();
        String sessionKey = vodUploadAddress.getSessionKey();
        String auth = vodUploadAddress.getStoreInfos(0).getAuth();
        String host = vodUploadAddress.getUploadHosts(0);
        Retryer retryer = RetryerBuilder.newBuilder().retryIfException().retryIfResult(Predicates.equalTo((Object)false)).retryIfResult(Predicates.isNull()).withWaitStrategy(WaitStrategies.exponentialWait()).withStopStrategy(StopStrategies.stopAfterAttempt((int)3)).build();
        if (file.length() < 0x1400000L) {
            this.directUpload(host, oid, auth, file, retryer);
        } else {
            boolean isLargeFile = false;
            if (file.length() > 0x3200000L) {
                isLargeFile = true;
            }
            this.chunkUpload(host, oid, auth, file, isLargeFile, retryer);
        }
        UploadCompleteInfo uploadCompleteInfo = new UploadCompleteInfo(oid, sessionKey);
        return uploadCompleteInfo;
    }

    private void directUpload(String host, String oid, String auth, File file, Retryer retryer) throws Exception {
        String url = String.format("https://%s/%s", host, oid);
        byte[] bytes = Files.readAllBytes(Paths.get(file.getPath(), new String[0]));
        long crc32 = Utils.crc32(bytes);
        String checkSum = String.format("%08x", crc32);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", auth);
        headers.put("Content-CRC32", checkSum);
        retryer.call(() -> this.putData(url, bytes, headers));
    }

    private void chunkUpload(String host, String oid, String auth, File file, boolean isLargeFile, Retryer retryer) throws Exception {
        String uploadID = this.initUploadPart(host, oid, auth, isLargeFile, retryer);
        byte[] data = new byte[0x1400000];
        ArrayList<String> parts = new ArrayList<String>();
        long num = file.length() / 0x1400000L;
        long lastNum = num - 1L;
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));){
            for (long i = 0L; i < lastNum; ++i) {
                bis.read(data);
                parts.add(this.uploadPart(host, oid, auth, uploadID, i, data, isLargeFile, retryer));
            }
            long readCount = 0x1400000L * lastNum;
            int len = (int)(file.length() - readCount);
            byte[] lastPart = new byte[len];
            bis.read(lastPart);
            parts.add(this.uploadPart(host, oid, auth, uploadID, lastNum, lastPart, isLargeFile, retryer));
        }
        this.uploadMergePart(host, oid, auth, uploadID, (String[])parts.stream().toArray(String[]::new), isLargeFile, retryer);
    }

    private String initUploadPart(String host, String oid, String auth, boolean isLargeFile, Retryer retryer) throws ExecutionException, RetryException, IOException {
        HttpResponse httpResponse;
        String url = String.format("http://%s/%s?uploads", host, oid);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", auth);
        if (isLargeFile) {
            headers.put("X-Storage-Mode", "gateway");
        }
        if ((httpResponse = (HttpResponse)retryer.call(() -> this.putDataWithResponse(url, new byte[0], headers))) == null) {
            throw new RuntimeException("init part error,response is empty");
        }
        if (httpResponse.getStatusLine().getStatusCode() != 200) {
            throw new RuntimeException("http code is " + httpResponse.getStatusLine().getStatusCode());
        }
        String entity = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
        JSONObject result = JSONObject.parseObject((String)entity);
        return result.getJSONObject("payload").getInnerMap().get("uploadID").toString();
    }

    private String uploadPart(String host, String oid, String auth, String uploadID, long partNumber, byte[] data, boolean isLargeFile, Retryer retryer) throws Exception {
        String url = String.format("http://%s/%s?partNumber=%d&uploadID=%s", host, oid, partNumber, uploadID);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", auth);
        long crc32 = Utils.crc32(data);
        String checkSum = String.format("%08x", crc32);
        headers.put("Content-CRC32", checkSum);
        if (isLargeFile) {
            headers.put("X-Storage-Mode", "gateway");
        }
        retryer.call(() -> this.putData(url, data, headers));
        return checkSum;
    }

    private void uploadMergePart(String host, String oid, String auth, String uploadID, String[] checkSum, boolean isLargeFile, Retryer retryer) throws ExecutionException, RetryException {
        String url = String.format("http://%s/%s?uploadID=%s", host, oid, uploadID);
        String body = IntStream.range(0, checkSum.length).mapToObj(i -> String.format("%d:%s", i, checkSum[i])).collect(Collectors.joining(",", "", ""));
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", auth);
        if (isLargeFile) {
            headers.put("X-Storage-Mode", "gateway");
        }
        retryer.call(() -> this.putData(url, body.getBytes(), headers));
    }

    @Override
    public VodCommitUploadInfoResponse uploadMaterial(VodUploadMaterialRequest vodUploadMaterialRequest) throws Exception {
        UploadCompleteInfo uploadCompleteInfo = this.uploadToB(vodUploadMaterialRequest.getSpaceName(), vodUploadMaterialRequest.getFilePath(), vodUploadMaterialRequest.getFileType());
        VodCommitUploadInfoRequest vodCommitUploadInfoRequest = VodCommitUploadInfoRequest.newBuilder().setSpaceName(vodUploadMaterialRequest.getSpaceName()).setSessionKey(uploadCompleteInfo.getSessionKey()).setFunctions(vodUploadMaterialRequest.getFunctions()).setCallbackArgs(vodUploadMaterialRequest.getCallbackArgs()).build();
        return this.commitUploadInfo(vodCommitUploadInfoRequest);
    }

    @Override
    public VodGetPlayInfoResponse getPlayInfo(VodGetPlayInfoRequest input) throws Exception {
        RawResponse response = this.query("GetPlayInfo", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetPlayInfoResponse.Builder responseBuilder = VodGetPlayInfoResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodGetPrivateDrmPlayAuthResponse getPrivateDrmPlayAuth(VodGetPrivateDrmPlayAuthRequest input) throws Exception {
        RawResponse response = this.query("GetPrivateDrmPlayAuth", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetPrivateDrmPlayAuthResponse.Builder responseBuilder = VodGetPrivateDrmPlayAuthResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodGetHlsDecryptionKeyResponse getHlsDecryptionKey(VodGetHlsDecryptionKeyRequest input) throws Exception {
        RawResponse response = this.query("GetHlsDecryptionKey", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetHlsDecryptionKeyResponse.Builder responseBuilder = VodGetHlsDecryptionKeyResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodUrlUploadResponse uploadMediaByUrl(VodUrlUploadRequest input) throws Exception {
        RawResponse response = this.query("UploadMediaByUrl", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodUrlUploadResponse.Builder responseBuilder = VodUrlUploadResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodQueryUploadTaskInfoResponse queryUploadTaskInfo(VodQueryUploadTaskInfoRequest input) throws Exception {
        RawResponse response = this.query("QueryUploadTaskInfo", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodQueryUploadTaskInfoResponse.Builder responseBuilder = VodQueryUploadTaskInfoResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodApplyUploadInfoResponse applyUploadInfo(VodApplyUploadInfoRequest input) throws Exception {
        RawResponse response = this.query("ApplyUploadInfo", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodApplyUploadInfoResponse.Builder responseBuilder = VodApplyUploadInfoResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodCommitUploadInfoResponse commitUploadInfo(VodCommitUploadInfoRequest input) throws Exception {
        RawResponse response = this.query("CommitUploadInfo", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodCommitUploadInfoResponse.Builder responseBuilder = VodCommitUploadInfoResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodUpdateMediaInfoResponse updateMediaInfo(VodUpdateMediaInfoRequest input) throws Exception {
        RawResponse response = this.query("UpdateMediaInfo", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodUpdateMediaInfoResponse.Builder responseBuilder = VodUpdateMediaInfoResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodUpdateMediaPublishStatusResponse updateMediaPublishStatus(VodUpdateMediaPublishStatusRequest input) throws Exception {
        RawResponse response = this.query("UpdateMediaPublishStatus", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodUpdateMediaPublishStatusResponse.Builder responseBuilder = VodUpdateMediaPublishStatusResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodGetMediaInfosResponse getMediaInfos(VodGetMediaInfosRequest input) throws Exception {
        RawResponse response = this.query("GetMediaInfos", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetMediaInfosResponse.Builder responseBuilder = VodGetMediaInfosResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodGetRecommendedPosterResponse getRecommendedPoster(VodGetRecommendedPosterRequest input) throws Exception {
        RawResponse response = this.query("GetRecommendedPoster", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetRecommendedPosterResponse.Builder responseBuilder = VodGetRecommendedPosterResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodDeleteMediaResponse deleteMedia(VodDeleteMediaRequest input) throws Exception {
        RawResponse response = this.query("DeleteMedia", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodDeleteMediaResponse.Builder responseBuilder = VodDeleteMediaResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodDeleteTranscodesResponse deleteTranscodes(VodDeleteTranscodesRequest input) throws Exception {
        RawResponse response = this.query("DeleteTranscodes", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodDeleteTranscodesResponse.Builder responseBuilder = VodDeleteTranscodesResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodGetMediaListResponse getMediaList(VodGetMediaListRequest input) throws Exception {
        RawResponse response = this.query("GetMediaList", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetMediaListResponse.Builder responseBuilder = VodGetMediaListResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodGetSubtitleInfoListResponse getSubtitleInfoList(VodGetSubtitleInfoListRequest input) throws Exception {
        RawResponse response = this.query("GetSubtitleInfoList", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetSubtitleInfoListResponse.Builder responseBuilder = VodGetSubtitleInfoListResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodUpdateSubtitleStatusResponse updateSubtitleStatus(VodUpdateSubtitleStatusRequest input) throws Exception {
        RawResponse response = this.query("UpdateSubtitleStatus", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodUpdateSubtitleStatusResponse.Builder responseBuilder = VodUpdateSubtitleStatusResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodUpdateSubtitleInfoResponse updateSubtitleInfo(VodUpdateSubtitleInfoRequest input) throws Exception {
        RawResponse response = this.query("UpdateSubtitleInfo", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodUpdateSubtitleInfoResponse.Builder responseBuilder = VodUpdateSubtitleInfoResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodStartWorkflowResponse StartWorkflow(VodStartWorkflowRequest input) throws Exception {
        RawResponse response = this.query("StartWorkflow", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodStartWorkflowResponse.Builder responseBuilder = VodStartWorkflowResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }
}

