/*
 * Decompiled with CFR 0.152.
 */
package com.wuwenze.poi;

import com.wuwenze.poi.exception.ExcelKitRuntimeException;
import com.wuwenze.poi.factory.ExcelMappingFactory;
import com.wuwenze.poi.handler.ExcelReadHandler;
import com.wuwenze.poi.pojo.ExcelMapping;
import com.wuwenze.poi.util.POIUtil;
import com.wuwenze.poi.xlsx.ExcelXlsxReader;
import com.wuwenze.poi.xlsx.ExcelXlsxWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ExcelKit {
    private Class<?> mClass = null;
    private HttpServletResponse mResponse = null;
    private OutputStream mOutputStream = null;
    private Integer mMaxSheetRecords = 50000;
    private String mCurrentOptionMode = "$MODE_EXPORT$";
    private static final String MODE_EXPORT = "$MODE_EXPORT$";
    private static final String MODE_BUILD = "$MODE_BUILD$";
    private static final String MODE_IMPORT = "$MODE_IMPORT$";

    public static ExcelKit $Export(Class<?> clazz, HttpServletResponse response) {
        return new ExcelKit(clazz, response);
    }

    public void downXlsx(List<?> data, boolean isTemplate) {
        if (!this.mCurrentOptionMode.equals(MODE_EXPORT)) {
            throw new ExcelKitRuntimeException("\u8bf7\u4f7f\u7528com.wuwenze.poi.ExcelKit.$Export(Class<?> clazz, HttpServletResponse response)\u6784\u9020\u5668\u521d\u59cb\u5316\u53c2\u6570.");
        }
        try {
            ExcelMapping excelMapping = ExcelMappingFactory.get(this.mClass);
            ExcelXlsxWriter excelXlsxWriter = new ExcelXlsxWriter(excelMapping, this.mMaxSheetRecords);
            SXSSFWorkbook workbook = excelXlsxWriter.generateXlsxWorkbook(data, isTemplate);
            String fileName = isTemplate ? excelMapping.getName() + "-\u5bfc\u5165\u6a21\u677f.xlsx" : excelMapping.getName() + "-\u5bfc\u51fa\u7ed3\u679c.xlsx";
            POIUtil.download(workbook, this.mResponse, URLEncoder.encode(fileName, "UTF-8"));
        }
        catch (Throwable e) {
            throw new ExcelKitRuntimeException("downXlsx error", e);
        }
    }

    public static ExcelKit $Builder(Class<?> clazz, OutputStream outputStream) {
        return new ExcelKit(clazz, outputStream);
    }

    public void writeXlsx(List<?> data, boolean isTemplate) {
        if (!this.mCurrentOptionMode.equals(MODE_BUILD)) {
            throw new ExcelKitRuntimeException("\u8bf7\u4f7f\u7528com.wuwenze.poi.ExcelKit.$Builder(Class<?> clazz, OutputStream outputStream)\u6784\u9020\u5668\u521d\u59cb\u5316\u53c2\u6570.");
        }
        ExcelMapping excelMapping = ExcelMappingFactory.get(this.mClass);
        ExcelXlsxWriter excelXlsxWriter = new ExcelXlsxWriter(excelMapping, this.mMaxSheetRecords);
        SXSSFWorkbook workbook = excelXlsxWriter.generateXlsxWorkbook(data, isTemplate);
        POIUtil.write(workbook, this.mOutputStream);
    }

    public static ExcelKit $Import(Class<?> clazz) {
        return new ExcelKit(clazz);
    }

    public void readXlsx(File excelFile, ExcelReadHandler<?> excelReadHandler) {
        this.readXlsx(excelFile, (Integer)-1, excelReadHandler);
    }

    public void readXlsx(File excelFile, Integer sheetIndex, ExcelReadHandler<?> excelReadHandler) {
        try {
            FileInputStream inputStream = new FileInputStream(excelFile);
            this.readXlsx(inputStream, sheetIndex, excelReadHandler);
        }
        catch (Throwable e) {
            throw new ExcelKitRuntimeException("readXlsx error", e);
        }
    }

    public void readXlsx(InputStream inputStream, ExcelReadHandler<?> excelReadHandler) {
        this.readXlsx(inputStream, (Integer)-1, excelReadHandler);
    }

    public void readXlsx(InputStream inputStream, Integer sheetIndex, ExcelReadHandler<?> excelReadHandler) {
        if (!this.mCurrentOptionMode.equals(MODE_IMPORT)) {
            throw new ExcelKitRuntimeException("\u8bf7\u4f7f\u7528com.wuwenze.poi.ExcelKit.$Import(Class<?> clazz)\u6784\u9020\u5668\u521d\u59cb\u5316\u53c2\u6570.");
        }
        ExcelMapping excelMapping = ExcelMappingFactory.get(this.mClass);
        ExcelXlsxReader excelXlsxReader = new ExcelXlsxReader(this.mClass, excelMapping, excelReadHandler);
        if (sheetIndex >= 0) {
            excelXlsxReader.process(inputStream, (int)sheetIndex);
            return;
        }
        excelXlsxReader.process(inputStream);
    }

    public ExcelKit setMaxSheetRecords(Integer mMaxSheetRecords) {
        this.mMaxSheetRecords = mMaxSheetRecords;
        return this;
    }

    protected ExcelKit(Class<?> clazz) {
        this(clazz, null, null);
        this.mCurrentOptionMode = MODE_IMPORT;
    }

    protected ExcelKit(Class<?> clazz, OutputStream outputStream) {
        this(clazz, outputStream, null);
        this.mCurrentOptionMode = MODE_BUILD;
    }

    protected ExcelKit(Class<?> clazz, HttpServletResponse response) {
        this(clazz, null, response);
        this.mCurrentOptionMode = MODE_EXPORT;
    }

    protected ExcelKit(Class<?> clazz, OutputStream outputStream, HttpServletResponse response) {
        this.mClass = clazz;
        this.mOutputStream = outputStream;
        this.mResponse = response;
    }

    protected ExcelKit() {
    }
}

