/*
 * Decompiled with CFR 0.152.
 */
package com.wuyunonline.tracelog.filter;

import com.wuyunonline.tracelog.common.util.TraceIdUtil;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.slf4j.MDC;
import org.springframework.util.StringUtils;

@Activate(group={"provider", "consumer"})
public class TraceLogDubboFilter
implements Filter {
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        String traceId = invocation.getAttachment("traceId");
        if (StringUtils.isEmpty((Object)traceId)) {
            traceId = MDC.get((String)"traceId");
            if (StringUtils.isEmpty((Object)traceId)) {
                traceId = TraceIdUtil.uuid_timestamp();
                MDC.put((String)"traceId", (String)traceId);
            }
            invocation.setAttachment("traceId", traceId);
        } else {
            MDC.put((String)"traceId", (String)traceId);
        }
        Result result = invoker.invoke(invocation);
        return result;
    }
}

