/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.convert;

import com.xiaoleilu.hutool.convert.ConvertException;
import com.xiaoleilu.hutool.convert.Converter;
import com.xiaoleilu.hutool.convert.impl.ArrayConverter;
import com.xiaoleilu.hutool.convert.impl.BooleanArrayConverter;
import com.xiaoleilu.hutool.convert.impl.BooleanConverter;
import com.xiaoleilu.hutool.convert.impl.ByteArrayConverter;
import com.xiaoleilu.hutool.convert.impl.CalendarConverter;
import com.xiaoleilu.hutool.convert.impl.CharArrayConverter;
import com.xiaoleilu.hutool.convert.impl.CharacterConverter;
import com.xiaoleilu.hutool.convert.impl.CharsetConverter;
import com.xiaoleilu.hutool.convert.impl.ClassConverter;
import com.xiaoleilu.hutool.convert.impl.DateConverter;
import com.xiaoleilu.hutool.convert.impl.DateTimeConverter;
import com.xiaoleilu.hutool.convert.impl.DoubleArrayConverter;
import com.xiaoleilu.hutool.convert.impl.FloatArrayConverter;
import com.xiaoleilu.hutool.convert.impl.IntArrayConverter;
import com.xiaoleilu.hutool.convert.impl.LongArrayConverter;
import com.xiaoleilu.hutool.convert.impl.NumberConverter;
import com.xiaoleilu.hutool.convert.impl.PathConverter;
import com.xiaoleilu.hutool.convert.impl.PrimitiveConverter;
import com.xiaoleilu.hutool.convert.impl.ShortArrayConverter;
import com.xiaoleilu.hutool.convert.impl.SqlDateConverter;
import com.xiaoleilu.hutool.convert.impl.SqlTimeConverter;
import com.xiaoleilu.hutool.convert.impl.SqlTimestampConverter;
import com.xiaoleilu.hutool.convert.impl.StringConverter;
import com.xiaoleilu.hutool.convert.impl.TimeZoneConverter;
import com.xiaoleilu.hutool.convert.impl.URIConverter;
import com.xiaoleilu.hutool.convert.impl.URLConverter;
import com.xiaoleilu.hutool.date.DateTime;
import com.xiaoleilu.hutool.util.ClassUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;

public class ConverterRegistry {
    private Map<Class<?>, Converter<?>> defaultConverterMap;
    private Map<Class<?>, Converter<?>> customConverterMap;

    public static ConverterRegistry getInstance() {
        return SingletonHolder.instance;
    }

    public ConverterRegistry() {
        this.defaultConverter();
    }

    public ConverterRegistry putCustom(Class<?> clazz, Class<? extends Converter<?>> converterClass) {
        return this.putCustom(clazz, ClassUtil.newInstance(converterClass));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConverterRegistry putCustom(Class<?> clazz, Converter<?> converter) {
        if (null == this.customConverterMap) {
            ConverterRegistry converterRegistry = this;
            synchronized (converterRegistry) {
                if (null == this.customConverterMap) {
                    this.customConverterMap = new ConcurrentHashMap();
                }
            }
        }
        this.customConverterMap.put(clazz, converter);
        return this;
    }

    public <T> Converter<T> getConverter(Class<T> type, boolean isCustomFirst) {
        Converter<T> converter = null;
        if (isCustomFirst) {
            converter = this.getCustomConverter(type);
            if (null == converter) {
                converter = this.getDefaultConverter(type);
            }
        } else {
            converter = this.getDefaultConverter(type);
            if (null == converter) {
                converter = this.getCustomConverter(type);
            }
        }
        return converter;
    }

    public <T> Converter<T> getDefaultConverter(Class<T> type) {
        return null == this.defaultConverterMap ? null : this.defaultConverterMap.get(type);
    }

    public <T> Converter<T> getCustomConverter(Class<T> type) {
        return null == this.customConverterMap ? null : this.customConverterMap.get(type);
    }

    public <T> T convert(Class<T> type, Object value, T defaultValue, boolean isCustomFirst) throws ConvertException {
        if (null == type && null == defaultValue) {
            throw new NullPointerException("[type] and [defaultValue] are both null, we can not know what type to convert !");
        }
        if (null == value) {
            return defaultValue;
        }
        if (null == type) {
            type = defaultValue.getClass();
        }
        if (type.isInstance(value)) {
            return (T)value;
        }
        Converter<T> converter = this.getConverter(type, isCustomFirst);
        if (null == converter) {
            throw new ConvertException("No Converter for type [{}]", type.getName());
        }
        return converter.convert(value, defaultValue);
    }

    public <T> T convert(Class<T> type, Object value, T defaultValue) throws ConvertException {
        return this.convert(type, value, defaultValue, true);
    }

    public <T> T convert(Class<T> type, Object value) throws ConvertException {
        return this.convert(type, value, null);
    }

    private ConverterRegistry defaultConverter() {
        this.defaultConverterMap = new ConcurrentHashMap();
        this.defaultConverterMap.put(Byte.TYPE, new PrimitiveConverter(Byte.TYPE));
        this.defaultConverterMap.put(Short.TYPE, new PrimitiveConverter(Short.TYPE));
        this.defaultConverterMap.put(Integer.TYPE, new PrimitiveConverter(Integer.TYPE));
        this.defaultConverterMap.put(Long.TYPE, new PrimitiveConverter(Long.TYPE));
        this.defaultConverterMap.put(Float.TYPE, new PrimitiveConverter(Float.TYPE));
        this.defaultConverterMap.put(Double.TYPE, new PrimitiveConverter(Double.TYPE));
        this.defaultConverterMap.put(Character.TYPE, new PrimitiveConverter(Character.TYPE));
        this.defaultConverterMap.put(Boolean.TYPE, new PrimitiveConverter(Boolean.TYPE));
        this.defaultConverterMap.put(String.class, new StringConverter());
        this.defaultConverterMap.put(Boolean.class, new BooleanConverter());
        this.defaultConverterMap.put(Character.class, new CharacterConverter());
        this.defaultConverterMap.put(Number.class, new NumberConverter());
        this.defaultConverterMap.put(Byte.class, new NumberConverter(Byte.class));
        this.defaultConverterMap.put(Short.class, new NumberConverter(Short.class));
        this.defaultConverterMap.put(Integer.class, new NumberConverter(Integer.class));
        this.defaultConverterMap.put(Long.class, new NumberConverter(Long.class));
        this.defaultConverterMap.put(Float.class, new NumberConverter(Float.class));
        this.defaultConverterMap.put(Double.class, new NumberConverter(Double.class));
        this.defaultConverterMap.put(BigDecimal.class, new NumberConverter(BigDecimal.class));
        this.defaultConverterMap.put(BigInteger.class, new NumberConverter(BigInteger.class));
        this.defaultConverterMap.put(Integer[].class, new ArrayConverter<Integer>(Integer.class));
        this.defaultConverterMap.put(Long[].class, new ArrayConverter<Long>(Long.class));
        this.defaultConverterMap.put(Byte[].class, new ArrayConverter<Byte>(Byte.class));
        this.defaultConverterMap.put(Short[].class, new ArrayConverter<Short>(Short.class));
        this.defaultConverterMap.put(Float[].class, new ArrayConverter<Float>(Float.class));
        this.defaultConverterMap.put(Double[].class, new ArrayConverter<Double>(Double.class));
        this.defaultConverterMap.put(Boolean[].class, new ArrayConverter<Boolean>(Boolean.class));
        this.defaultConverterMap.put(Character[].class, new ArrayConverter<Character>(Character.class));
        this.defaultConverterMap.put(String[].class, new ArrayConverter<String>(String.class));
        this.defaultConverterMap.put(byte[].class, new ByteArrayConverter());
        this.defaultConverterMap.put(short[].class, new ShortArrayConverter());
        this.defaultConverterMap.put(int[].class, new IntArrayConverter());
        this.defaultConverterMap.put(long[].class, new LongArrayConverter());
        this.defaultConverterMap.put(float[].class, new FloatArrayConverter());
        this.defaultConverterMap.put(double[].class, new DoubleArrayConverter());
        this.defaultConverterMap.put(boolean[].class, new BooleanArrayConverter());
        this.defaultConverterMap.put(char[].class, new CharArrayConverter());
        this.defaultConverterMap.put(URI.class, new URIConverter());
        this.defaultConverterMap.put(URL.class, new URLConverter());
        this.defaultConverterMap.put(Calendar.class, new CalendarConverter());
        this.defaultConverterMap.put(Date.class, new DateConverter());
        this.defaultConverterMap.put(DateTime.class, new DateTimeConverter());
        this.defaultConverterMap.put(Date.class, new SqlDateConverter());
        this.defaultConverterMap.put(Time.class, new SqlTimeConverter());
        this.defaultConverterMap.put(Timestamp.class, new SqlTimestampConverter());
        this.defaultConverterMap.put(Class.class, new ClassConverter());
        this.defaultConverterMap.put(TimeZone.class, new TimeZoneConverter());
        this.defaultConverterMap.put(Charset.class, new CharsetConverter());
        this.defaultConverterMap.put(Path.class, new PathConverter());
        return this;
    }

    private static class SingletonHolder {
        private static ConverterRegistry instance = new ConverterRegistry();

        private SingletonHolder() {
        }
    }
}

