/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.convert.impl;

import com.xiaoleilu.hutool.convert.AbstractConverter;
import com.xiaoleilu.hutool.convert.ConverterRegistry;
import com.xiaoleilu.hutool.util.ArrayUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ArrayConverter<T>
extends AbstractConverter<T[]> {
    private Class<T> targetComponentType;

    public ArrayConverter(Class<T> targetComponentType) {
        this.targetComponentType = targetComponentType;
    }

    @Override
    protected T[] convertInternal(Object value) {
        return value.getClass().isArray() ? this.convertArrayToArray(value) : this.convertObjectToArray(value);
    }

    @Override
    public Class<T[]> getTargetType() {
        Class<Object[]> targetType = super.getTargetType();
        if (null == targetType) {
            if (Integer.class == this.targetComponentType) {
                targetType = Integer[].class;
            } else if (Long.class == this.targetComponentType) {
                targetType = Long[].class;
            } else if (Float.class == this.targetComponentType) {
                targetType = Float[].class;
            } else if (Double.class == this.targetComponentType) {
                targetType = Double[].class;
            } else if (Short.class == this.targetComponentType) {
                targetType = Short[].class;
            } else if (Byte.class == this.targetComponentType) {
                targetType = Byte[].class;
            } else if (Character.class == this.targetComponentType) {
                targetType = Character[].class;
            } else if (Boolean.class == this.targetComponentType) {
                targetType = Boolean[].class;
            } else if (String.class == this.targetComponentType) {
                targetType = String[].class;
            }
        }
        return targetType;
    }

    private T[] convertArrayToArray(Object value) {
        Class<?> valueComponentType = value.getClass().getComponentType();
        if (valueComponentType == this.targetComponentType) {
            return (Object[])value;
        }
        T[] result = null;
        if (valueComponentType.isPrimitive()) {
            result = this.convertPrimitiveArrayToArray(value, valueComponentType);
        } else {
            Object[] array = (Object[])value;
            result = ArrayUtil.newArray(this.targetComponentType, array.length);
            for (int i = 0; i < array.length; ++i) {
                result[i] = ConverterRegistry.getInstance().convert(this.targetComponentType, array[i]);
            }
        }
        return result;
    }

    private T[] convertObjectToArray(Object value) {
        T[] result = null;
        ConverterRegistry registry = ConverterRegistry.getInstance();
        if (value instanceof List) {
            List list = (List)value;
            result = ArrayUtil.newArray(this.targetComponentType, list.size());
            for (int i = 0; i < list.size(); ++i) {
                result[i] = registry.convert(this.targetComponentType, list.get(i));
            }
        } else if (value instanceof Collection) {
            Collection collection = (Collection)value;
            result = ArrayUtil.newArray(this.targetComponentType, collection.size());
            int i = 0;
            for (Object element : collection) {
                result[i] = registry.convert(this.targetComponentType, element);
                ++i;
            }
        } else if (value instanceof Iterable) {
            Iterable iterable = (Iterable)value;
            ArrayList<T> list = new ArrayList<T>();
            for (Object element : iterable) {
                list.add(registry.convert(this.targetComponentType, element));
            }
            result = ArrayUtil.newArray(this.targetComponentType, list.size());
            result = list.toArray(result);
        }
        if (value instanceof CharSequence) {
            String[] strings = StrUtil.split(value.toString(), ",");
            return this.convertArrayToArray(strings);
        }
        return this.convertToSingleElementArray(value);
    }

    private T[] convertPrimitiveArrayToArray(Object value, Class<?> primitiveComponentType) {
        T[] result;
        block9: {
            ConverterRegistry registry;
            block15: {
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                block10: {
                                    block8: {
                                        result = null;
                                        registry = ConverterRegistry.getInstance();
                                        if (primitiveComponentType != Integer.TYPE) break block8;
                                        int[] array = (int[])value;
                                        result = ArrayUtil.newArray(this.targetComponentType, array.length);
                                        for (int i = 0; i < array.length; ++i) {
                                            result[i] = registry.convert(this.targetComponentType, array[i]);
                                        }
                                        break block9;
                                    }
                                    if (primitiveComponentType != Long.TYPE) break block10;
                                    long[] array = (long[])value;
                                    result = ArrayUtil.newArray(this.targetComponentType, array.length);
                                    for (int i = 0; i < array.length; ++i) {
                                        result[i] = registry.convert(this.targetComponentType, array[i]);
                                    }
                                    break block9;
                                }
                                if (primitiveComponentType != Float.TYPE) break block11;
                                float[] array = (float[])value;
                                result = ArrayUtil.newArray(this.targetComponentType, array.length);
                                for (int i = 0; i < array.length; ++i) {
                                    result[i] = registry.convert(this.targetComponentType, Float.valueOf(array[i]));
                                }
                                break block9;
                            }
                            if (primitiveComponentType != Double.TYPE) break block12;
                            double[] array = (double[])value;
                            result = ArrayUtil.newArray(this.targetComponentType, array.length);
                            for (int i = 0; i < array.length; ++i) {
                                result[i] = registry.convert(this.targetComponentType, array[i]);
                            }
                            break block9;
                        }
                        if (primitiveComponentType != Short.TYPE) break block13;
                        short[] array = (short[])value;
                        result = ArrayUtil.newArray(this.targetComponentType, array.length);
                        for (int i = 0; i < array.length; ++i) {
                            result[i] = registry.convert(this.targetComponentType, array[i]);
                        }
                        break block9;
                    }
                    if (primitiveComponentType != Byte.TYPE) break block14;
                    byte[] array = (byte[])value;
                    result = ArrayUtil.newArray(this.targetComponentType, array.length);
                    for (int i = 0; i < array.length; ++i) {
                        result[i] = registry.convert(this.targetComponentType, array[i]);
                    }
                    break block9;
                }
                if (primitiveComponentType != Character.TYPE) break block15;
                char[] array = (char[])value;
                result = ArrayUtil.newArray(this.targetComponentType, array.length);
                for (int i = 0; i < array.length; ++i) {
                    result[i] = registry.convert(this.targetComponentType, Character.valueOf(array[i]));
                }
                break block9;
            }
            if (primitiveComponentType != Boolean.TYPE) break block9;
            boolean[] array = (boolean[])value;
            result = ArrayUtil.newArray(this.targetComponentType, array.length);
            for (int i = 0; i < array.length; ++i) {
                result[i] = registry.convert(this.targetComponentType, array[i]);
            }
        }
        return result;
    }

    private T[] convertToSingleElementArray(Object value) {
        T[] singleElementArray = ArrayUtil.newArray(this.targetComponentType, 1);
        singleElementArray[0] = ConverterRegistry.getInstance().convert(this.targetComponentType, value);
        return singleElementArray;
    }
}

