/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.convert.impl;

import com.xiaoleilu.hutool.convert.AbstractConverter;
import com.xiaoleilu.hutool.util.StrUtil;

public class PrimitiveConverter
extends AbstractConverter<Object> {
    private Class<?> targetType;

    public PrimitiveConverter(Class<?> clazz) {
        if (null == clazz) {
            throw new NullPointerException("PrimitiveConverter not allow null target type!");
        }
        if (!clazz.isPrimitive()) {
            throw new IllegalArgumentException("[" + clazz + "] is not a primitive class!");
        }
        this.targetType = clazz;
    }

    @Override
    protected Object convertInternal(Object value) {
        try {
            if (Byte.TYPE == this.targetType) {
                if (value instanceof Number) {
                    return ((Number)value).byteValue();
                }
                String valueStr = this.convertToStr(value);
                if (StrUtil.isBlank(valueStr)) {
                    return 0;
                }
                return Byte.parseByte(valueStr);
            }
            if (Short.TYPE == this.targetType) {
                if (value instanceof Number) {
                    return ((Number)value).shortValue();
                }
                String valueStr = this.convertToStr(value);
                if (StrUtil.isBlank(valueStr)) {
                    return 0;
                }
                return Short.parseShort(valueStr);
            }
            if (Integer.TYPE == this.targetType) {
                if (value instanceof Number) {
                    return ((Number)value).intValue();
                }
                String valueStr = this.convertToStr(value);
                if (StrUtil.isBlank(valueStr)) {
                    return 0;
                }
                return Integer.parseInt(valueStr);
            }
            if (Long.TYPE == this.targetType) {
                if (value instanceof Number) {
                    return ((Number)value).longValue();
                }
                String valueStr = this.convertToStr(value);
                if (StrUtil.isBlank(valueStr)) {
                    return 0;
                }
                return Long.parseLong(valueStr);
            }
            if (Float.TYPE == this.targetType) {
                if (value instanceof Number) {
                    return Float.valueOf(((Number)value).floatValue());
                }
                String valueStr = this.convertToStr(value);
                if (StrUtil.isBlank(valueStr)) {
                    return 0;
                }
                return Float.valueOf(Float.parseFloat(valueStr));
            }
            if (Double.TYPE == this.targetType) {
                if (value instanceof Number) {
                    return ((Number)value).doubleValue();
                }
                String valueStr = this.convertToStr(value);
                if (StrUtil.isBlank(valueStr)) {
                    return 0;
                }
                return Double.parseDouble(valueStr);
            }
            if (Character.TYPE == this.targetType) {
                if (value instanceof Character) {
                    return Character.valueOf(((Character)value).charValue());
                }
                String valueStr = this.convertToStr(value);
                if (StrUtil.isBlank(valueStr)) {
                    return 0;
                }
                return Character.valueOf(valueStr.charAt(0));
            }
            if (Boolean.TYPE == this.targetType) {
                if (value instanceof Boolean) {
                    return (boolean)((Boolean)value);
                }
                String valueStr = this.convertToStr(value);
                return PrimitiveConverter.parseBoolean(valueStr);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    static boolean parseBoolean(String valueStr) {
        if (StrUtil.isNotBlank(valueStr)) {
            switch (valueStr = valueStr.trim().toLowerCase()) {
                case "true": {
                    return true;
                }
                case "false": {
                    return false;
                }
                case "yes": {
                    return true;
                }
                case "y": {
                    return true;
                }
                case "ok": {
                    return true;
                }
                case "no": {
                    return false;
                }
                case "n": {
                    return false;
                }
                case "1": {
                    return true;
                }
                case "0": {
                    return false;
                }
            }
        }
        return false;
    }

    @Override
    public Class<Object> getTargetType() {
        return this.targetType;
    }
}

