/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.io.resource;

import com.xiaoleilu.hutool.io.IORuntimeException;
import com.xiaoleilu.hutool.io.resource.UrlResource;
import com.xiaoleilu.hutool.lang.Assert;
import com.xiaoleilu.hutool.util.ClassUtil;
import java.net.URL;

public class ClassPathResource
extends UrlResource {
    private String path;
    private ClassLoader classLoader;
    private Class<?> clazz;

    public ClassPathResource(String path) {
        this(path, null, null);
    }

    public ClassPathResource(String path, ClassLoader classLoader) {
        this(path, classLoader, null);
    }

    public ClassPathResource(String path, Class<?> clazz) {
        this(path, null, clazz);
    }

    public ClassPathResource(String path, ClassLoader classLoader, Class<?> clazz) {
        super((URL)null);
        Assert.notNull(path, "Path must not be null");
        this.path = path;
        this.classLoader = classLoader != null ? classLoader : ClassUtil.getClassLoader();
        this.clazz = clazz;
        this.initUrl();
    }

    public final String getPath() {
        return this.path;
    }

    public final ClassLoader getClassLoader() {
        return this.classLoader;
    }

    private void initUrl() {
        this.url = null != this.clazz ? this.clazz.getResource(this.path) : (null != this.classLoader ? this.classLoader.getResource(this.path) : ClassLoader.getSystemResource(this.path));
        if (null == this.url) {
            throw new IORuntimeException("Resource of path [{}] not exist!", this.path);
        }
    }

    @Override
    public String toString() {
        return null == this.path ? super.toString() : "classpath:" + this.path;
    }
}

