/*
 * Decompiled with CFR 0.152.
 */
package org.reficio.ws.client.core;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import org.reficio.ws.client.SoapClientException;
import org.reficio.ws.client.core.SoapConstants;

public class Security {
    private KeyStore trustStore;
    private char[] trustStorePassword;
    private String trustStoreType;
    private KeyStore keyStore;
    private char[] keyStorePassword;
    private String keyStoreType;
    private String authUsername;
    private String authPassword;
    private String authWorkstation;
    private String authDomain;
    private String authMethod;
    private boolean strictHostVerification;
    private String sslContextProtocol;

    public KeyStore getTrustStore() {
        return this.trustStore;
    }

    public char[] getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public String getTrustStorePasswordAsString() {
        return this.trustStorePassword != null ? new String(this.trustStorePassword) : null;
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public char[] getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public String getKeyStorePasswordAsString() {
        return this.keyStorePassword != null ? new String(this.keyStorePassword) : null;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public String getAuthUsername() {
        return this.authUsername;
    }

    public String getAuthPassword() {
        return this.authPassword;
    }

    public String getAuthWorkstation() {
        return this.authWorkstation;
    }

    public String getAuthDomain() {
        return this.authDomain;
    }

    public String getAuthMethod() {
        return this.authMethod;
    }

    public boolean isAuthEnabled() {
        return !this.authMethod.equals(SoapConstants.AuthMethod.NONE.name());
    }

    public boolean isAuthBasic() {
        return this.authMethod.equals(SoapConstants.AuthMethod.BASIC.name());
    }

    public boolean isAuthDigest() {
        return this.authMethod.equals(SoapConstants.AuthMethod.DIGEST.name());
    }

    public boolean isAuthNtlm() {
        return this.authMethod.equals(SoapConstants.AuthMethod.NTLM.name());
    }

    public boolean isAuthSpnego() {
        return this.authMethod.equals(SoapConstants.AuthMethod.SPNEGO.name());
    }

    public boolean isStrictHostVerification() {
        return this.strictHostVerification;
    }

    public String getSslContextProtocol() {
        return this.sslContextProtocol;
    }

    public static Builder builder() {
        return new Builder();
    }

    private Security() {
    }

    static /* synthetic */ char[] access$302(Security x0, char[] x1) {
        x0.keyStorePassword = x1;
        return x1;
    }

    static /* synthetic */ char[] access$602(Security x0, char[] x1) {
        x0.trustStorePassword = x1;
        return x1;
    }

    public static class Builder {
        private KeyStore trustStore;
        private URL trustStoreUrl;
        private String trustStoreType = "JKS";
        private char[] trustStorePassword;
        private KeyStore keyStore;
        private URL keyStoreUrl;
        private String keyStoreType = "JKS";
        private char[] keyStorePassword;
        private String authUsername;
        private String authPassword;
        private String authWorkstation;
        private String authDomain;
        private String authMethod = SoapConstants.AuthMethod.NONE.name();
        private String sslContextProtocol = "SSLv3";
        private Boolean strictHostVerification = false;

        public Builder authBasic(String user, String password) {
            this.authUsername = (String)Preconditions.checkNotNull((Object)user);
            this.authPassword = (String)Preconditions.checkNotNull((Object)password);
            this.authMethod = SoapConstants.AuthMethod.BASIC.name();
            return this;
        }

        public Builder authDigest(String user, String password) {
            this.authUsername = (String)Preconditions.checkNotNull((Object)user);
            this.authPassword = (String)Preconditions.checkNotNull((Object)password);
            this.authMethod = SoapConstants.AuthMethod.DIGEST.name();
            return this;
        }

        public Builder authNtlm(String user, String password, String workstation, String domain) {
            this.authUsername = (String)Preconditions.checkNotNull((Object)user);
            this.authPassword = (String)Preconditions.checkNotNull((Object)password);
            this.authWorkstation = (String)Preconditions.checkNotNull((Object)workstation);
            this.authDomain = (String)Preconditions.checkNotNull((Object)domain);
            this.authMethod = SoapConstants.AuthMethod.NTLM.name();
            return this;
        }

        public Builder authSpnego() {
            this.authMethod = SoapConstants.AuthMethod.SPNEGO.name();
            return this;
        }

        public Builder keyStore(KeyStore value) {
            Preconditions.checkNotNull((Object)value);
            this.keyStore = value;
            return this;
        }

        public Builder keyStoreUrl(URL value) {
            Preconditions.checkNotNull((Object)value);
            this.keyStoreUrl = value;
            return this;
        }

        public Builder keyStoreUrl(String value) {
            Preconditions.checkNotNull((Object)value);
            try {
                this.keyStoreUrl = new URL(value);
                return this;
            }
            catch (MalformedURLException ex) {
                throw new SoapClientException(String.format("URL [%s] is malformed", value), ex);
            }
        }

        public Builder keyStoreType(String value) {
            Preconditions.checkNotNull((Object)value);
            this.keyStoreType = value;
            return this;
        }

        public Builder keyStorePassword(String value) {
            if (value != null) {
                this.keyStorePassword = value.toCharArray();
            }
            return this;
        }

        public Builder trustStore(KeyStore value) {
            Preconditions.checkNotNull((Object)value);
            this.trustStore = value;
            return this;
        }

        public Builder trustStoreUrl(URL value) {
            Preconditions.checkNotNull((Object)value);
            this.trustStoreUrl = value;
            return this;
        }

        public Builder trustStoreUrl(String value) {
            Preconditions.checkNotNull((Object)value);
            try {
                this.trustStoreUrl = new URL(value);
                return this;
            }
            catch (MalformedURLException ex) {
                throw new SoapClientException(String.format("URL [%s] is malformed", value), ex);
            }
        }

        public Builder trustStoreType(String value) {
            Preconditions.checkNotNull((Object)value);
            this.trustStoreType = value;
            return this;
        }

        public Builder trustStorePassword(String value) {
            if (value != null) {
                this.trustStorePassword = value.toCharArray();
            }
            return this;
        }

        public Builder strictHostVerification(boolean value) {
            this.strictHostVerification = value;
            return this;
        }

        public Builder sslContextProtocol(String value) {
            Preconditions.checkNotNull((Object)value);
            this.sslContextProtocol = value;
            return this;
        }

        public Security build() {
            Security security = new Security();
            security.keyStore = this.initKeyStore(this.keyStore, this.keyStoreUrl, this.keyStoreType, this.keyStorePassword);
            security.keyStoreType = this.keyStoreType;
            Security.access$302(security, this.keyStorePassword);
            security.trustStore = this.initKeyStore(this.trustStore, this.trustStoreUrl, this.trustStoreType, this.trustStorePassword);
            security.trustStoreType = this.trustStoreType;
            Security.access$602(security, this.trustStorePassword);
            security.sslContextProtocol = this.sslContextProtocol;
            security.strictHostVerification = this.strictHostVerification;
            security.authUsername = this.authUsername;
            security.authPassword = this.authPassword;
            security.authWorkstation = this.authWorkstation;
            security.authDomain = this.authDomain;
            security.authMethod = this.authMethod;
            return security;
        }

        private KeyStore initKeyStore(KeyStore keyStore, URL keyStoreUrl, String keyStoreType, char[] keyStorePassword) {
            boolean keyStorePropertiesDefined;
            boolean bl = keyStorePropertiesDefined = keyStoreUrl != null || keyStoreType != null || keyStorePassword != null;
            if (keyStore != null && keyStorePropertiesDefined) {
                throw new SoapClientException("Specify either a keyStore | trustStore instance or properties required to load one (url, type, password)");
            }
            if (keyStoreUrl != null) {
                try {
                    InputStream in = keyStoreUrl.openStream();
                    KeyStore ks = KeyStore.getInstance(keyStoreType);
                    ks.load(in, keyStorePassword);
                    in.close();
                    return ks;
                }
                catch (GeneralSecurityException e) {
                    throw new SoapClientException("KeyStore setup failed", e);
                }
                catch (IOException e) {
                    throw new SoapClientException("KeyStore setup failed", e);
                }
            }
            return null;
        }
    }
}

