/*
 * Decompiled with CFR 0.152.
 */
package org.reficio.ws.client.core;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.routing.RouteInfo;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeLayeredSocketFactory;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.reficio.ws.SoapException;
import org.reficio.ws.annotation.ThreadSafe;
import org.reficio.ws.client.SoapClientException;
import org.reficio.ws.client.TransmissionException;
import org.reficio.ws.client.core.Security;
import org.reficio.ws.client.ssl.SSLUtils;

@ThreadSafe
public final class SoapClient {
    private static final Log log = LogFactory.getLog(SoapClient.class);
    private static final String NULL_SOAP_ACTION = null;
    private int readTimeoutInMillis;
    private int connectTimeoutInMillis;
    private URI endpointUri;
    private Security endpointProperties;
    private boolean endpointTlsEnabled;
    private URI proxyUri;
    private Security proxyProperties;
    private boolean proxyTlsEnabled;
    private DefaultHttpClient client;

    public String post(String requestEnvelope) {
        return this.post(NULL_SOAP_ACTION, requestEnvelope);
    }

    public String post(String soapAction, String requestEnvelope) {
        log.debug((Object)String.format("Sending request to host=[%s] action=[%s] request:%n%s", this.endpointUri.toString(), soapAction, requestEnvelope));
        String response = this.transmit(soapAction, requestEnvelope);
        log.debug((Object)("Received response:\n" + requestEnvelope));
        return response;
    }

    public void disconnect() {
        if (this.client != null) {
            this.client.getConnectionManager().shutdown();
        }
    }

    private HttpPost generatePost(String soapAction, String requestEnvelope) {
        try {
            HttpPost post = new HttpPost(this.endpointUri.toString());
            StringEntity contentEntity = new StringEntity(requestEnvelope);
            post.setEntity((HttpEntity)contentEntity);
            if (requestEnvelope.contains("http://schemas.xmlsoap.org/soap/envelope/")) {
                soapAction = soapAction != null ? "\"" + soapAction + "\"" : "";
                post.addHeader("SOAPAction", soapAction);
                post.addHeader("Content-Type", "text/xml");
                this.client.getParams().setParameter("Content-Type", (Object)"text/xml");
            } else if (requestEnvelope.contains("http://www.w3.org/2003/05/soap-envelope")) {
                String contentType = "application/soap+xml";
                if (soapAction != null) {
                    contentType = contentType + "; " + "action=" + "\"" + soapAction + "\"";
                }
                post.addHeader("Content-Type", contentType);
            }
            return post;
        }
        catch (UnsupportedEncodingException ex) {
            throw new SoapClientException(ex);
        }
    }

    private String transmit(String soapAction, String data) {
        HttpPost post = this.generatePost(soapAction, data);
        return this.executePost(post);
    }

    private String executePost(HttpPost post) {
        try {
            HttpResponse response = this.client.execute((HttpUriRequest)post);
            StatusLine statusLine = response.getStatusLine();
            HttpEntity entity = response.getEntity();
            if (statusLine.getStatusCode() >= 300) {
                EntityUtils.consume((HttpEntity)entity);
                throw new TransmissionException(statusLine.getReasonPhrase(), statusLine.getStatusCode());
            }
            return entity == null ? null : EntityUtils.toString((HttpEntity)entity);
        }
        catch (SoapException ex) {
            throw ex;
        }
        catch (ConnectTimeoutException ex) {
            throw new TransmissionException("Connection timed out", ex);
        }
        catch (IOException ex) {
            throw new TransmissionException("Transmission failed", ex);
        }
        catch (RuntimeException ex) {
            post.abort();
            throw new TransmissionException("Transmission aborted", ex);
        }
    }

    private void initialize() {
        this.configureClient();
        this.configureAuthentication();
        this.configureTls();
        this.configureProxy();
    }

    private void configureClient() {
        this.client = new DefaultHttpClient();
        BasicHttpParams httpParameters = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParameters, (int)this.connectTimeoutInMillis);
        HttpConnectionParams.setSoTimeout((HttpParams)httpParameters, (int)this.readTimeoutInMillis);
        this.client.setParams((HttpParams)httpParameters);
    }

    private void configureAuthentication() {
        this.configureAuthentication(this.endpointUri, this.endpointProperties);
        this.configureAuthentication(this.proxyUri, this.proxyProperties);
    }

    private void configureAuthentication(URI uri, Security security) {
        if (security.isAuthEnabled()) {
            AuthScope scope = new AuthScope(uri.getHost(), uri.getPort());
            UsernamePasswordCredentials credentials = null;
            if (security.isAuthBasic()) {
                credentials = new UsernamePasswordCredentials(security.getAuthUsername(), security.getAuthPassword());
            } else if (security.isAuthDigest()) {
                credentials = new UsernamePasswordCredentials(security.getAuthUsername(), security.getAuthPassword());
            } else if (security.isAuthNtlm()) {
                credentials = new NTCredentials(security.getAuthUsername(), security.getAuthPassword(), null, null);
            } else if (security.isAuthSpnego()) {
                // empty if block
            }
            this.client.getCredentialsProvider().setCredentials(scope, (Credentials)credentials);
        }
    }

    private void configureTls() {
        try {
            if (this.endpointTlsEnabled && this.proxyTlsEnabled) {
                SSLSocketFactory factory = SSLUtils.getMergedSocketFactory(this.endpointProperties, this.proxyProperties);
                this.registerTlsScheme((SchemeLayeredSocketFactory)factory, this.proxyUri.getPort());
            } else if (this.endpointTlsEnabled) {
                SSLSocketFactory factory = SSLUtils.getFactory(this.endpointProperties);
                int port = this.endpointUri.getPort();
                this.registerTlsScheme((SchemeLayeredSocketFactory)factory, port);
            } else if (this.proxyTlsEnabled) {
                SSLSocketFactory factory = SSLUtils.getFactory(this.proxyProperties);
                int port = this.proxyUri.getPort();
                this.registerTlsScheme((SchemeLayeredSocketFactory)factory, port);
            }
        }
        catch (GeneralSecurityException ex) {
            throw new SoapClientException(ex);
        }
    }

    private void registerTlsScheme(SchemeLayeredSocketFactory factory, int port) {
        Scheme sch = new Scheme("HTTPS", port, (SchemeSocketFactory)factory);
        this.client.getConnectionManager().getSchemeRegistry().register(sch);
    }

    private void configureProxy() {
        if (this.proxyUri == null) {
            return;
        }
        if (this.proxyTlsEnabled) {
            final HttpHost proxy = new HttpHost(this.proxyUri.getHost(), this.proxyUri.getPort(), "HTTPS");
            if (!this.endpointTlsEnabled) {
                this.client.setRoutePlanner(new HttpRoutePlanner(){

                    public HttpRoute determineRoute(HttpHost target, HttpRequest request, HttpContext context) {
                        return new HttpRoute(target, null, proxy, true, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
                    }
                });
            }
            this.client.getParams().setParameter("http.route.default-proxy", (Object)proxy);
        } else {
            HttpHost proxy = new HttpHost(this.proxyUri.getHost(), this.proxyUri.getPort());
            this.client.getParams().setParameter("http.route.default-proxy", (Object)proxy);
        }
    }

    private SoapClient() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Integer readTimeoutInMillis = 0;
        private Integer connectTimeoutInMillis = 0;
        private URI endpointUri;
        private Security endpointProperties;
        private boolean endpointTlsEnabled;
        private URI proxyUri;
        private Security proxyProperties;
        private boolean proxyTlsEnabled;

        public Builder endpointUri(String value) {
            Preconditions.checkNotNull((Object)value);
            try {
                URI uri = new URI(value);
                return this.endpointUri(uri);
            }
            catch (URISyntaxException ex) {
                throw new SoapClientException(String.format("URI [%s] is malformed", value), ex);
            }
        }

        public Builder endpointUri(URI value) {
            this.endpointUri = (URI)Preconditions.checkNotNull((Object)value);
            this.endpointTlsEnabled = value.getScheme().equalsIgnoreCase("HTTPS");
            return this;
        }

        public Builder proxyUri(String value) {
            Preconditions.checkNotNull((Object)value);
            try {
                URI uri = new URI(value);
                return this.proxyUri(uri);
            }
            catch (URISyntaxException ex) {
                throw new SoapClientException(String.format("URI [%s] is malformed", value), ex);
            }
        }

        public Builder proxyUri(URI value) {
            this.proxyUri = (URI)Preconditions.checkNotNull((Object)value);
            this.proxyTlsEnabled = value.getScheme().equalsIgnoreCase("HTTPS");
            return this;
        }

        public Builder endpointSecurity(Security value) {
            this.endpointProperties = (Security)Preconditions.checkNotNull((Object)value);
            return this;
        }

        public Builder proxySecurity(Security value) {
            this.proxyProperties = (Security)Preconditions.checkNotNull((Object)value);
            return this;
        }

        public Builder readTimeoutInMillis(int value) {
            Preconditions.checkArgument((value >= 0 ? 1 : 0) != 0);
            this.readTimeoutInMillis = value;
            return this;
        }

        public Builder connectTimeoutInMillis(int value) {
            Preconditions.checkArgument((value >= 0 ? 1 : 0) != 0);
            this.connectTimeoutInMillis = value;
            return this;
        }

        public SoapClient build() {
            return this.initializeClient();
        }

        private SoapClient initializeClient() {
            SoapClient client = new SoapClient();
            client.endpointUri = this.endpointUri;
            if (this.endpointProperties == null) {
                this.endpointProperties = Security.builder().build();
            }
            client.endpointProperties = this.endpointProperties;
            client.endpointTlsEnabled = this.endpointTlsEnabled;
            client.proxyUri = this.proxyUri;
            if (this.proxyProperties == null) {
                this.proxyProperties = Security.builder().build();
            }
            client.proxyProperties = this.proxyProperties;
            client.proxyTlsEnabled = this.proxyTlsEnabled;
            client.readTimeoutInMillis = this.readTimeoutInMillis;
            client.connectTimeoutInMillis = this.connectTimeoutInMillis;
            client.initialize();
            return client;
        }
    }
}

