/*
 * Decompiled with CFR 0.152.
 */
package org.reficio.ws.server.core;

import com.google.common.base.Preconditions;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.reficio.ws.server.core.SoapServer;
import org.reficio.ws.server.responder.RequestResponder;

public class SoapServerFactory {
    private Integer httpPort;
    private Integer httpsPort;
    private Boolean reuseAddress;
    private Integer connectionMaxIdleTimeInSeconds;
    private Integer acceptorThreads;
    private Integer coreThreads;
    private Integer maxThreads;
    private Integer threadKeepAliveTimeInSeconds;
    private URL keyStoreUrl;
    private String keyStoreType;
    private String keyStorePassword;
    private Map<String, RequestResponder> responders;

    public void setHttpPort(Integer value) {
        Preconditions.checkNotNull((Object)value);
        this.httpPort = value;
    }

    public void setHttpsPort(Integer value) {
        Preconditions.checkNotNull((Object)value);
        this.httpsPort = value;
    }

    public void setConnectionMaxIdleTimeInSeconds(Integer value) {
        Preconditions.checkNotNull((Object)value);
        this.connectionMaxIdleTimeInSeconds = value;
    }

    public void setAcceptorThreads(Integer value) {
        Preconditions.checkNotNull((Object)value);
        this.acceptorThreads = value;
    }

    public void setCoreThreads(Integer value) {
        Preconditions.checkNotNull((Object)value);
        this.coreThreads = value;
    }

    public void setMaxThreads(Integer value) {
        Preconditions.checkNotNull((Object)value);
        this.maxThreads = value;
    }

    public void setThreadKeepAliveTimeInSeconds(Integer value) {
        Preconditions.checkNotNull((Object)value);
        this.threadKeepAliveTimeInSeconds = value;
    }

    public void setKeyStoreUrl(URL value) {
        Preconditions.checkNotNull((Object)value);
        this.keyStoreUrl = value;
    }

    public void setKeyStoreType(String value) {
        Preconditions.checkNotNull((Object)value);
        this.keyStoreType = value;
    }

    public void setKeyStorePassword(String value) {
        this.keyStorePassword = value;
    }

    public void setReuseAddress(Boolean value) {
        Preconditions.checkNotNull((Object)value);
        this.reuseAddress = value;
    }

    public void setResponders(Map<String, RequestResponder> responders) {
        Preconditions.checkNotNull(responders);
        this.responders = new HashMap<String, RequestResponder>(responders);
    }

    public SoapServer create() {
        SoapServer.Builder builder = SoapServer.builder();
        this.configureConnection(builder);
        this.configureThreadPools(builder);
        this.configureTimeouts(builder);
        this.configureKeyStore(builder);
        SoapServer server = builder.build();
        this.configureResponders(server);
        return server;
    }

    private void configureResponders(SoapServer server) {
        for (Map.Entry<String, RequestResponder> entry : this.responders.entrySet()) {
            server.registerRequestResponder(entry.getKey(), entry.getValue());
        }
    }

    private void configureThreadPools(SoapServer.Builder builder) {
        if (this.acceptorThreads != null) {
            builder.acceptorThreads(this.acceptorThreads);
        }
        if (this.coreThreads != null) {
            builder.coreThreads(this.coreThreads);
        }
        if (this.maxThreads != null) {
            builder.maxThreads(this.maxThreads);
        }
    }

    private void configureTimeouts(SoapServer.Builder builder) {
        if (this.connectionMaxIdleTimeInSeconds != null) {
            builder.connectionMaxIdleTimeInSeconds(this.connectionMaxIdleTimeInSeconds);
        }
        if (this.threadKeepAliveTimeInSeconds != null) {
            builder.threadKeepAliveTimeInSeconds(this.threadKeepAliveTimeInSeconds);
        }
    }

    private void configureConnection(SoapServer.Builder builder) {
        if (this.httpPort != null) {
            builder.httpPort(this.httpPort);
        }
        if (this.httpsPort != null) {
            builder.httpsPort(this.httpsPort);
        }
        if (this.reuseAddress != null) {
            builder.reuseAddress(this.reuseAddress);
        }
    }

    private void configureKeyStore(SoapServer.Builder builder) {
        if (this.keyStoreUrl != null) {
            builder.keyStoreUrl(this.keyStoreUrl);
        }
        if (this.keyStoreType != null) {
            builder.keyStoreType(this.keyStoreType);
        }
        builder.keyStorePassword(this.keyStorePassword);
    }

    public static void main(String[] args) {
        SoapServerFactory f = new SoapServerFactory();
        f.setHttpPort(9999);
        SoapServer s = f.create();
        s.start();
    }
}

