/*
 * Decompiled with CFR 0.152.
 */
package org.reficio.ws.server.matcher;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.OperationType;
import javax.wsdl.Part;
import javax.xml.namespace.QName;
import javax.xml.transform.dom.DOMSource;
import org.apache.commons.lang3.StringUtils;
import org.reficio.ws.builder.core.SoapUtils;
import org.reficio.ws.common.XmlUtils;
import org.reficio.ws.legacy.SoapLegacyFacade;
import org.reficio.ws.server.OperationNotFoundException;
import org.reficio.ws.server.matcher.AggregatingVisitor;
import org.reficio.ws.server.matcher.BindingOperationVisitor;
import org.springframework.ws.soap.SoapMessage;
import org.w3c.dom.Node;

public class SoapOperationMatcher {
    protected final Binding binding;
    protected final boolean rpc;

    public SoapOperationMatcher(Binding binding) {
        this.binding = binding;
        this.rpc = SoapLegacyFacade.isRpc((Binding)binding);
    }

    protected boolean isRpc() {
        return this.rpc;
    }

    protected boolean isDocument() {
        return !this.isRpc();
    }

    public BindingOperation getInvokedOperation(SoapMessage message) throws OperationNotFoundException {
        BindingOperation invokedOperation = this.getOperationBySoapAction(message);
        if (invokedOperation != null) {
            return invokedOperation;
        }
        Set rootNodes = XmlUtils.getRootNodes((DOMSource)((DOMSource)message.getPayloadSource()));
        if (this.isRpc()) {
            invokedOperation = this.getOperationByRootQName(rootNodes);
            if (invokedOperation != null) {
                return invokedOperation;
            }
        } else {
            invokedOperation = this.getOperationByInputTypes(rootNodes);
            if (invokedOperation != null) {
                return invokedOperation;
            }
            invokedOperation = this.getOperationByInputNames(rootNodes);
            if (invokedOperation != null) {
                return invokedOperation;
            }
        }
        throw new OperationNotFoundException("Cannot match a SOAP operation to the given SOAP request");
    }

    private BindingOperation getOperationBySoapAction(SoapMessage message) {
        final String soapActionToMatch = SoapUtils.normalizeSoapAction((String)message.getSoapAction());
        if (StringUtils.isBlank((CharSequence)soapActionToMatch)) {
            return null;
        }
        AggregatingVisitor<BindingOperation> visitor = new AggregatingVisitor<BindingOperation>(){

            @Override
            public void visit(BindingOperation operation) {
                String soapAction = SoapUtils.normalizeSoapAction((String)SoapUtils.getSOAPActionUri((BindingOperation)operation));
                if (soapAction.equals(soapActionToMatch)) {
                    this.addResult(operation);
                }
            }
        };
        this.visitOperation(visitor);
        return (BindingOperation)visitor.getUniqueResult();
    }

    private BindingOperation getOperationByRootQName(Set<Node> rootNodes) throws OperationNotFoundException {
        if (rootNodes.isEmpty() || rootNodes.size() > 1) {
            throw new OperationNotFoundException("No unique top-level node containing the operation name in the rpc request.");
        }
        QName root = XmlUtils.nodeToQName((Node)rootNodes.iterator().next());
        return this.matchElementNameToOperationName(root);
    }

    private BindingOperation matchElementNameToOperationName(final QName elementName) {
        AggregatingVisitor<BindingOperation> visitor = new AggregatingVisitor<BindingOperation>(){

            @Override
            public void visit(BindingOperation operation) {
                if (operation.getOperation().getName().equals(elementName.getLocalPart())) {
                    this.addResult(operation);
                }
            }
        };
        this.visitOperation(visitor);
        return (BindingOperation)visitor.getUniqueResult();
    }

    private BindingOperation getOperationByInputTypes(final Set<Node> rootNodes) {
        AggregatingVisitor<BindingOperation> visitor = new AggregatingVisitor<BindingOperation>(){

            @Override
            public void visit(BindingOperation operation) {
                Collection expectedParts = operation.getOperation().getInput().getMessage().getParts().values();
                HashSet<QName> expectedTypes = new HashSet<QName>();
                for (Part part : expectedParts) {
                    expectedTypes.add(part.getElementName());
                }
                Set receivedTypes = XmlUtils.getNodeTypes((Set)rootNodes);
                if (expectedTypes.equals(receivedTypes)) {
                    this.addResult(operation);
                } else if (expectedParts.isEmpty() && receivedTypes.size() == 1) {
                    String name;
                    QName receivedType = receivedTypes.toArray(new QName[receivedTypes.size()])[0];
                    String namespaceUri = operation.getOperation().getInput().getMessage().getQName().getNamespaceURI();
                    QName pseudoInputName = new QName(namespaceUri, name = operation.getOperation().getName());
                    if (pseudoInputName.equals(receivedType)) {
                        this.addResult(operation);
                    }
                }
            }
        };
        this.visitOperation(visitor);
        return (BindingOperation)visitor.getUniqueResult();
    }

    private BindingOperation getOperationByInputNames(final Set<Node> rootNodes) {
        AggregatingVisitor<BindingOperation> visitor = new AggregatingVisitor<BindingOperation>(){

            @Override
            public void visit(BindingOperation operation) {
                Set expectedNames = operation.getOperation().getInput().getMessage().getParts().keySet();
                Set receivedNames = XmlUtils.getNodeNames((Set)rootNodes);
                if (receivedNames.equals(expectedNames)) {
                    this.addResult(operation);
                }
            }
        };
        this.visitOperation(visitor);
        return (BindingOperation)visitor.getUniqueResult();
    }

    private <T extends BindingOperationVisitor> T visitOperation(T visitor) {
        for (BindingOperation operation : this.binding.getBindingOperations()) {
            try {
                visitor.visit(operation);
            }
            catch (NullPointerException nullPointerException) {}
        }
        return visitor;
    }

    public boolean isRequestResponseOperation(BindingOperation operation) {
        return operation.getOperation().getStyle().equals(OperationType.REQUEST_RESPONSE);
    }
}

