/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.mq.core.bootstrap.impl;

import com.xxl.mq.core.bootstrap.XxlMqBootstrap;
import com.xxl.mq.core.consumer.annotation.XxlMq;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.annotation.AnnotatedElementUtils;

public class XxlMqSpringBootstrap
extends XxlMqBootstrap
implements ApplicationContextAware,
SmartInitializingSingleton,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(XxlMqSpringBootstrap.class);
    private ApplicationContext applicationContext;

    public void afterSingletonsInstantiated() {
        this.scanConsumers();
        super.start();
    }

    public void destroy() throws Exception {
        super.stop();
    }

    private void scanConsumers() {
        String[] beanDefinitionNames;
        if (this.applicationContext == null) {
            return;
        }
        for (String beanDefinitionName : beanDefinitionNames = this.applicationContext.getBeanNamesForType(Object.class, false, true)) {
            Object bean = null;
            Lazy onBean = (Lazy)this.applicationContext.findAnnotationOnBean(beanDefinitionName, Lazy.class);
            if (onBean != null) {
                logger.debug("xxl-mq annotation scan, skip @Lazy Bean:{}", (Object)beanDefinitionName);
                continue;
            }
            bean = this.applicationContext.getBean(beanDefinitionName);
            Map annotatedMethods = null;
            try {
                annotatedMethods = MethodIntrospector.selectMethods(bean.getClass(), (MethodIntrospector.MetadataLookup)new MethodIntrospector.MetadataLookup<XxlMq>(){

                    public XxlMq inspect(Method method) {
                        return (XxlMq)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, XxlMq.class);
                    }
                });
            }
            catch (Throwable ex) {
                logger.error("xxl-mq method-consumer resolve error for bean[" + beanDefinitionName + "].", ex);
            }
            if (annotatedMethods == null || annotatedMethods.isEmpty()) continue;
            for (Map.Entry methodXxlMqEntry : annotatedMethods.entrySet()) {
                Method executeMethod = (Method)methodXxlMqEntry.getKey();
                XxlMq xxlMq = (XxlMq)methodXxlMqEntry.getValue();
                this.registryMethodConsumer(xxlMq, bean, executeMethod);
            }
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

