/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.tool.cache;

import com.xxl.tool.cache.CacheConf;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class CacheManage {
    private ConcurrentMap<String, Object> cacheData = new ConcurrentHashMap<String, Object>();
    private ConcurrentMap<String, CacheConf> cacheConf = new ConcurrentHashMap<String, CacheConf>();
    private long maxLenth = 10000L;

    public ConcurrentMap<String, Object> getCacheData() {
        return this.cacheData;
    }

    public void setCacheData(ConcurrentMap<String, Object> cacheData) {
        this.cacheData = cacheData;
    }

    public ConcurrentMap<String, CacheConf> getCacheConf() {
        return this.cacheConf;
    }

    public void setCacheConf(ConcurrentMap<String, CacheConf> cacheConf) {
        this.cacheConf = cacheConf;
    }

    public long getMaxLenth() {
        return this.maxLenth;
    }

    public void setMaxLenth(long maxLenth) {
        this.maxLenth = maxLenth;
    }

    public void capacityCheck() {
        if ((double)this.cacheConf.size() < (double)this.maxLenth * 0.5) {
            return;
        }
        if ((double)this.cacheConf.size() < (double)this.maxLenth * 0.9 && new Random().nextBoolean()) {
            return;
        }
        HashSet<String> keysToRemove = new HashSet<String>();
        for (Map.Entry entry : this.cacheConf.entrySet()) {
            if (((CacheConf)entry.getValue()).isValid()) continue;
            keysToRemove.add((String)entry.getKey());
        }
        this.removeKeys(keysToRemove);
        long clearCnt = (long)this.cacheConf.size() - this.maxLenth;
        if (clearCnt > 0L) {
            HashSet<String> keysToCut = new HashSet<String>();
            for (String key : this.cacheConf.keySet()) {
                keysToCut.add(key);
                if ((long)keysToCut.size() < clearCnt) continue;
                break;
            }
            this.removeKeys(keysToCut);
        }
    }

    private void removeKeys(Set<String> keys) {
        if (!keys.isEmpty()) {
            for (String key : keys) {
                this.cacheData.remove(key);
                this.cacheConf.remove(key);
            }
        }
    }
}

