/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.tool.cache;

import com.xxl.tool.cache.CacheConf;
import com.xxl.tool.cache.CacheManage;
import com.xxl.tool.core.StringTool;

public class CacheTool {
    private static CacheManage cacheManage = null;

    public static boolean set(String key, Object val, long liveTime) {
        cacheManage.capacityCheck();
        if (StringTool.isBlank(key)) {
            return false;
        }
        if (val == null || liveTime <= 0L) {
            CacheTool.remove(key);
        }
        long effectTime = System.currentTimeMillis();
        long expireTime = effectTime + liveTime;
        CacheConf cacheConf = new CacheConf(key, effectTime, expireTime);
        cacheManage.getCacheData().put(key, val);
        cacheManage.getCacheConf().put(key, cacheConf);
        return true;
    }

    public static boolean remove(String key) {
        if (StringTool.isBlank(key)) {
            return false;
        }
        cacheManage.getCacheData().remove(key);
        cacheManage.getCacheConf().remove(key);
        return true;
    }

    public static Object get(String key) {
        if (StringTool.isBlank(key)) {
            return false;
        }
        Object cacheVal = cacheManage.getCacheData().get(key);
        CacheConf cacheConf = (CacheConf)cacheManage.getCacheConf().get(key);
        if (cacheVal == null || cacheConf == null) {
            return null;
        }
        if (!cacheConf.isValid()) {
            CacheTool.remove(key);
            return null;
        }
        return cacheVal;
    }

    static {
        cacheManage = new CacheManage();
    }
}

