/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.tool.http;

import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPTool {
    private static Logger logger = LoggerFactory.getLogger(IPTool.class);
    private static final Pattern IPV4_ADDRESS_PATTERN = Pattern.compile("^\\d{1,3}(\\.\\d{1,3}){3}\\:\\d{1,5}$");
    private static final Pattern IPV4_IP_PATTERN = Pattern.compile("\\d{1,3}(\\.\\d{1,3}){3,5}$");
    private static final Pattern LOCAL_IP_PATTERN = Pattern.compile("127(\\.\\d{1,3}){3}$");
    private static final String LOCALHOST_KEY = "localhost";
    private static final String LOCALHOST_VALUE = "127.0.0.1";
    private static final String ANYHOST_VALUE = "0.0.0.0";
    private static final int MIN_PORT = 1;
    private static final int MAX_PORT = 65535;
    private static final int RANDOM_PORT_START = 30000;
    private static final int RANDOM_PORT_RANGE = 10000;
    private static final BitSet USED_PORT = new BitSet(65536);
    private static volatile InetAddress LOCAL_ADDRESS = null;

    public static boolean isPortInUsed(int port) {
        boolean bl;
        ServerSocket ignored = new ServerSocket(port);
        try {
            bl = false;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ignored.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                return true;
            }
        }
        ignored.close();
        return bl;
    }

    public static boolean isValidPort(int port) {
        return port >= 1 && port <= 65535;
    }

    public static int getRandomPort() {
        return 30000 + ThreadLocalRandom.current().nextInt(10000);
    }

    public static synchronized int getAvailablePort() {
        int randomPort = IPTool.getRandomPort();
        return IPTool.getAvailablePort(randomPort);
    }

    public static synchronized int getAvailablePort(int port) {
        int invalidPort = -1;
        if (!IPTool.isValidPort(port)) {
            return invalidPort;
        }
        for (int i = port; i < 65535; ++i) {
            if (!IPTool.isPortAvailable(i)) continue;
            return i;
        }
        return invalidPort;
    }

    public static synchronized int getAvailablePortNotUsed(int port) {
        int invalidPort = -1;
        if (!IPTool.isValidPort(port)) {
            return invalidPort;
        }
        for (int i = port; i < 65535; ++i) {
            if (USED_PORT.get(i) || !IPTool.isPortAvailable(i)) continue;
            USED_PORT.set(i);
            return i;
        }
        return invalidPort;
    }

    private static boolean isPortAvailable(int port) {
        boolean bl;
        ServerSocket ignored = new ServerSocket(port);
        try {
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ignored.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return false;
            }
        }
        ignored.close();
        return bl;
    }

    public static boolean isLocalHost(String host) {
        return host != null && (LOCAL_IP_PATTERN.matcher(host).matches() || host.equalsIgnoreCase(LOCALHOST_KEY));
    }

    public static boolean isAnyHost(String host) {
        return ANYHOST_VALUE.equals(host);
    }

    public static boolean isValidLocalHost(String host) {
        return host != null && !host.isEmpty() && !host.equalsIgnoreCase(LOCALHOST_KEY) && !host.equals(ANYHOST_VALUE) && !host.startsWith("127.");
    }

    public static String toAddressString(InetSocketAddress address) {
        return address.getAddress().getHostAddress() + ":" + address.getPort();
    }

    public static InetSocketAddress toAddress(String address) {
        int port;
        String host;
        int i = address.indexOf(58);
        if (i > -1) {
            host = address.substring(0, i);
            port = Integer.parseInt(address.substring(i + 1));
        } else {
            host = address;
            port = 0;
        }
        return new InetSocketAddress(host, port);
    }

    public static InetSocketAddress toAddress(String host, int port) {
        return new InetSocketAddress(host, port);
    }

    public static boolean isValidV4Address(String address) {
        return IPV4_ADDRESS_PATTERN.matcher(address).matches();
    }

    public static boolean isValidV4Address(InetAddress address) {
        if (address == null || address.isLoopbackAddress()) {
            return false;
        }
        String name = address.getHostAddress();
        return name != null && IPV4_IP_PATTERN.matcher(name).matches() && !ANYHOST_VALUE.equals(name) && !LOCALHOST_VALUE.equals(name);
    }

    private static boolean isPreferIPV6Address() {
        return Boolean.getBoolean("java.net.preferIPv6Addresses");
    }

    private static InetAddress normalizeV6Address(Inet6Address address) {
        String addr = address.getHostAddress();
        int i = addr.lastIndexOf(37);
        if (i > 0) {
            try {
                return InetAddress.getByName(addr.substring(0, i) + '%' + address.getScopeId());
            }
            catch (UnknownHostException e) {
                logger.debug("Unknown IPV6 address: ", (Throwable)e);
            }
        }
        return address;
    }

    public static String getIp() {
        InetAddress localAddress = IPTool.getLocalAddress();
        return localAddress != null ? localAddress.getHostAddress() : null;
    }

    public static InetAddress getLocalAddress() {
        if (LOCAL_ADDRESS != null) {
            return LOCAL_ADDRESS;
        }
        InetAddress localAddress = IPTool.getLocalAddress0();
        if (localAddress != null) {
            LOCAL_ADDRESS = localAddress;
        }
        return localAddress;
    }

    private static InetAddress getLocalAddress0() {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            if (interfaces != null) {
                while (interfaces.hasMoreElements()) {
                    try {
                        NetworkInterface network = interfaces.nextElement();
                        if (network.isLoopback() || network.isVirtual() || !network.isUp()) continue;
                        Enumeration<InetAddress> addresses = network.getInetAddresses();
                        while (addresses.hasMoreElements()) {
                            try {
                                InetAddress addressItem = IPTool.toValidAddress(addresses.nextElement());
                                if (addressItem == null) continue;
                                try {
                                    if (!addressItem.isReachable(100)) continue;
                                    return addressItem;
                                }
                                catch (IOException iOException) {
                                }
                            }
                            catch (Throwable e) {
                                logger.error(e.getMessage(), e);
                            }
                        }
                    }
                    catch (Throwable e) {
                        logger.error(e.getMessage(), e);
                    }
                }
            }
        }
        catch (Throwable e) {
            logger.warn(e.getMessage(), e);
        }
        try {
            InetAddress localAddress = InetAddress.getLocalHost();
            InetAddress addressItem = IPTool.toValidAddress(localAddress);
            if (addressItem != null) {
                return addressItem;
            }
        }
        catch (Throwable e) {
            logger.warn(e.getMessage(), e);
        }
        return null;
    }

    private static InetAddress toValidAddress(InetAddress address) {
        if (address instanceof Inet6Address) {
            Inet6Address v6Address = (Inet6Address)address;
            if (IPTool.isPreferIPV6Address()) {
                return IPTool.normalizeV6Address(v6Address);
            }
        }
        if (IPTool.isValidV4Address(address)) {
            return address;
        }
        return null;
    }
}

