/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.base.cache;

import com.google.common.collect.Maps;
import com.yeepay.yop.sdk.auth.credentials.YopCredentials;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class YopCredentialsCache {
    private static Map<String, YopCredentials<?>> CREDENTIALS_MAP = Maps.newConcurrentMap();

    public static void put(String appKey, YopCredentials<?> credentials) {
        YopCredentialsCache.put("", "", appKey, credentials);
    }

    public static void put(String provider, String env, String appKey, YopCredentials<?> credentials) {
        if (null == credentials) {
            return;
        }
        CREDENTIALS_MAP.put(YopCredentialsCache.cacheKey(provider, env, appKey), credentials);
    }

    public static YopCredentials<?> get(String appKey) {
        return YopCredentialsCache.get("", "", appKey);
    }

    public static YopCredentials<?> get(String provider, String env, String appKey) {
        return CREDENTIALS_MAP.get(YopCredentialsCache.cacheKey(provider, env, appKey));
    }

    public static String cacheKey(String provider, String env, String appKey) {
        return StringUtils.defaultString((String)provider, (String)"") + ":" + StringUtils.defaultString((String)env, (String)"") + ":" + appKey;
    }

    public static void invalidate(String appKey) {
        YopCredentialsCache.invalidate("", "", appKey);
    }

    public static void invalidate(String provider, String env, String appKey) {
        CREDENTIALS_MAP.remove(YopCredentialsCache.cacheKey(provider, env, appKey));
    }

    public static List<String> listKeys() {
        return new ArrayList<String>(CREDENTIALS_MAP.keySet());
    }

    public static List<String> listKeys(String provider, String env) {
        return CREDENTIALS_MAP.keySet().stream().filter(p -> p.startsWith(YopCredentialsCache.cacheKey(provider, env, ""))).collect(Collectors.toList());
    }
}

