/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.client.cmd;

import com.google.common.collect.Maps;
import com.yeepay.yop.sdk.client.cmd.YopCmdExecutor;
import com.yeepay.yop.sdk.client.cmd.impl.YopDefaultCmdExecutor;
import java.util.Map;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YopCmdExecutorRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(YopCmdExecutorRegistry.class);
    private static final Map<String, YopCmdExecutor> EXECUTOR_MAP = Maps.newHashMap();
    private static final YopCmdExecutor DEFAULT_EXECUTOR = new YopDefaultCmdExecutor();

    public static void register(String type, YopCmdExecutor digester) {
        EXECUTOR_MAP.put(type, digester);
    }

    public static YopCmdExecutor get(String type) {
        YopCmdExecutor executor = EXECUTOR_MAP.get(type);
        if (null == executor) {
            LOGGER.warn("No YopCmdExecutor Found, type:{}", (Object)type);
            return DEFAULT_EXECUTOR;
        }
        return executor;
    }

    static {
        ServiceLoader<YopCmdExecutor> serviceLoader = ServiceLoader.load(YopCmdExecutor.class);
        for (YopCmdExecutor cmdExecutor : serviceLoader) {
            for (String alg : cmdExecutor.support()) {
                EXECUTOR_MAP.put(alg, cmdExecutor);
            }
        }
    }
}

