/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.common.callback;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class YopCallback
implements Serializable {
    private static final long serialVersionUID = -1L;
    private String id;
    private String type;
    private String appKey;
    private String bizData;
    private boolean validSign = true;
    private Date createTime;
    private Map<String, Object> metaInfo = Maps.newHashMap();

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public String getBizData() {
        return this.bizData;
    }

    public boolean isValidSign() {
        return this.validSign;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Map<String, Object> getMetaInfo() {
        return this.metaInfo;
    }

    public static Builder builder() {
        Builder builder = new Builder();
        builder.callback = new YopCallback();
        ((Builder)builder).callback.metaInfo = Maps.newHashMap();
        return builder;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public static final class Builder {
        private YopCallback callback;

        public YopCallback build() {
            return this.callback;
        }

        public Builder withId(String id) {
            this.callback.id = id;
            return this;
        }

        public Builder withType(String type) {
            this.callback.type = type;
            return this;
        }

        public Builder withAppKey(String appKey) {
            this.callback.appKey = appKey;
            return this;
        }

        public Builder withBizData(String bizData) {
            this.callback.bizData = bizData;
            return this;
        }

        public Builder withCreateTime(Date createTime) {
            this.callback.createTime = createTime;
            return this;
        }

        public Builder withValidSign(boolean validSign) {
            this.callback.validSign = validSign;
            return this;
        }

        public Builder withMetaInfo(String key, Object value) {
            this.callback.metaInfo.put(key, value);
            return this;
        }

        public Builder withMetaInfo(Map<String, Object> metaInfo) {
            if (MapUtils.isNotEmpty(metaInfo)) {
                this.callback.metaInfo.putAll(metaInfo);
            }
            return this;
        }
    }
}

