/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.invoke.model;

import java.io.Serializable;
import java.net.URI;
import java.util.Objects;

public class UriResource
implements Serializable {
    private static final long serialVersionUID = -1L;
    public static final String RESOURCE_SEPERATOR = "####";
    public static final String RETAIN_RESOURCE_ID = "0000";
    private URI resource;
    private ResourceType resourceType;
    private String resourcePrefix = "";
    private Callback callback;

    public UriResource(URI uri) {
        this.resource = uri;
        this.resourceType = ResourceType.COMMON;
    }

    public UriResource(ResourceType resourceType, String resourcePrefix, URI uri) {
        this.resource = uri;
        this.resourceType = resourceType;
        this.resourcePrefix = resourcePrefix;
    }

    public UriResource(ResourceType resourceType, String resourcePrefix, URI resource, Callback callback) {
        this.resource = resource;
        this.resourceType = resourceType;
        this.resourcePrefix = resourcePrefix;
        this.callback = callback;
    }

    public URI getResource() {
        return this.resource;
    }

    public void setResource(URI resource) {
        this.resource = resource;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(ResourceType resourceType) {
        this.resourceType = resourceType;
    }

    public String getResourcePrefix() {
        return this.resourcePrefix;
    }

    public void setResourcePrefix(String resourcePrefix) {
        this.resourcePrefix = resourcePrefix;
    }

    public boolean isRetained() {
        return RETAIN_RESOURCE_ID.equals(this.resourcePrefix);
    }

    public Callback getCallback() {
        return this.callback;
    }

    public String toString() {
        return (Object)((Object)this.resourceType) + RESOURCE_SEPERATOR + this.resourcePrefix + RESOURCE_SEPERATOR + this.resource.toString();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.resourceType, this.resourcePrefix, this.resource});
    }

    public boolean equals(Object obj) {
        if (obj instanceof UriResource) {
            UriResource that = (UriResource)obj;
            return this.resourceType.equals((Object)that.getResourceType()) && this.resourcePrefix.equals(that.resourcePrefix) && this.resource.equals(that.resource);
        }
        return false;
    }

    public String computeResourceKey() {
        if (ResourceType.COMMON.equals((Object)this.resourceType)) {
            return this.resource.toString();
        }
        return this.toString();
    }

    public static UriResource parseResourceKey(String resourceKey) {
        String[] resourceSeperated = resourceKey.split(RESOURCE_SEPERATOR);
        if (resourceSeperated.length == 1) {
            return new UriResource(URI.create(resourceKey));
        }
        return new UriResource(ResourceType.valueOf(resourceSeperated[0]), resourceSeperated[1], URI.create(resourceSeperated[2]));
    }

    public static interface Callback {
        public void notify(Object ... var1);
    }

    public static enum ResourceType {
        COMMON,
        BLOCKED;

    }
}

