/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.flow.element.condition;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.enums.ConditionTypeEnum;
import com.yomahub.liteflow.exception.NoForNodeException;
import com.yomahub.liteflow.flow.element.Executable;
import com.yomahub.liteflow.flow.element.Node;
import com.yomahub.liteflow.flow.element.condition.LoopCondition;
import com.yomahub.liteflow.flow.parallel.LoopFutureObj;
import com.yomahub.liteflow.slot.DataBus;
import com.yomahub.liteflow.slot.Slot;
import com.yomahub.liteflow.thread.ExecutorHelper;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;

public class ForCondition
extends LoopCondition {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeCondition(Integer slotIndex) throws Exception {
        block8: {
            Slot slot = DataBus.getSlot(slotIndex);
            Node forNode = this.getForNode();
            if (ObjectUtil.isNull((Object)forNode)) {
                String errorInfo = StrUtil.format((CharSequence)"[{}]:no for-node found", (Object[])new Object[]{slot.getRequestId()});
                throw new NoForNodeException(errorInfo);
            }
            forNode.setCurrChainId(this.getCurrChainId());
            if (!forNode.isAccess(slotIndex)) {
                return;
            }
            forNode.execute(slotIndex);
            int forCount = (Integer)forNode.getItemResultMetaValue(slotIndex);
            Executable executableItem = this.getDoExecutor();
            Executable breakItem = this.getBreakItem();
            try {
                if (!this.isParallel()) {
                    for (int i = 0; i < forCount; ++i) {
                        executableItem.setCurrChainId(this.getCurrChainId());
                        this.setLoopIndex(executableItem, i);
                        executableItem.execute(slotIndex);
                        if (!ObjectUtil.isNotNull((Object)breakItem)) continue;
                        breakItem.setCurrChainId(this.getCurrChainId());
                        this.setLoopIndex(breakItem, i);
                        breakItem.execute(slotIndex);
                        boolean isBreak = (Boolean)breakItem.getItemResultMetaValue(slotIndex);
                        if (!isBreak) continue;
                        break block8;
                    }
                    break block8;
                }
                ArrayList<CompletableFuture<LoopFutureObj>> futureList = new ArrayList<CompletableFuture<LoopFutureObj>>();
                ExecutorService parallelExecutor = ExecutorHelper.loadInstance().buildExecutorService(this, slotIndex, this.getConditionType());
                for (int i = 0; i < forCount; ++i) {
                    CompletableFuture<LoopFutureObj> future = CompletableFuture.supplyAsync(new LoopCondition.LoopParallelSupplier(executableItem, this.getCurrChainId(), slotIndex, i), parallelExecutor);
                    futureList.add(future);
                    if (!ObjectUtil.isNotNull((Object)breakItem)) continue;
                    breakItem.setCurrChainId(this.getCurrChainId());
                    this.setLoopIndex(breakItem, i);
                    breakItem.execute(slotIndex);
                    boolean isBreak = (Boolean)breakItem.getItemResultMetaValue(slotIndex);
                    if (isBreak) break;
                }
                this.handleFutureList(futureList);
            }
            finally {
                this.removeLoopIndex(executableItem);
            }
        }
    }

    @Override
    public ConditionTypeEnum getConditionType() {
        return ConditionTypeEnum.TYPE_FOR;
    }

    public Node getForNode() {
        return (Node)this.getExecutableOne("FOR_KEY");
    }

    public void setForNode(Node forNode) {
        this.addExecutable("FOR_KEY", forNode);
    }
}

