/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.builder;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.enums.ConditionTypeEnum;
import com.yomahub.liteflow.flow.FlowBus;
import com.yomahub.liteflow.flow.element.Chain;
import com.yomahub.liteflow.flow.element.condition.Condition;
import com.yomahub.liteflow.flow.element.condition.ThenCondition;
import com.yomahub.liteflow.flow.element.condition.WhenCondition;
import java.util.ArrayList;
import java.util.List;

public class LiteFlowChainBuilder {
    private Chain chain = new Chain();
    private final List<Condition> conditionList = new ArrayList<Condition>();
    private final List<Condition> preConditionList = new ArrayList<Condition>();
    private final List<Condition> finallyConditionList = new ArrayList<Condition>();

    public static LiteFlowChainBuilder createChain() {
        return new LiteFlowChainBuilder();
    }

    public LiteFlowChainBuilder setChainName(String chainName) {
        if (FlowBus.containChain(chainName)) {
            this.chain = FlowBus.getChain(chainName);
        } else {
            this.chain.setChainName(chainName);
        }
        return this;
    }

    public LiteFlowChainBuilder setCondition(Condition condition) {
        this.buildConditions(condition);
        return this;
    }

    public void build() {
        this.chain.setConditionList(this.conditionList);
        this.chain.setPreConditionList(this.preConditionList);
        this.chain.setFinallyConditionList(this.finallyConditionList);
        this.checkBuild();
        FlowBus.addChain(this.chain);
    }

    private void checkBuild() {
        ArrayList<String> errorList = new ArrayList<String>();
        if (StrUtil.isBlank((CharSequence)this.chain.getChainName())) {
            errorList.add("name is blank");
        }
        if (CollUtil.isNotEmpty(errorList)) {
            throw new RuntimeException(CollUtil.join(errorList, (CharSequence)",", (String)"[", (String)"]"));
        }
    }

    private void buildConditions(Condition condition) {
        if (condition.getConditionType().equals((Object)ConditionTypeEnum.TYPE_PRE)) {
            this.preConditionList.add(condition);
        } else if (condition.getConditionType().equals((Object)ConditionTypeEnum.TYPE_FINALLY)) {
            this.finallyConditionList.add(condition);
        } else if (condition.getConditionType().equals((Object)ConditionTypeEnum.TYPE_THEN)) {
            if (this.conditionList.size() >= 1 && CollectionUtil.getLast(this.conditionList) instanceof ThenCondition) {
                ((Condition)CollectionUtil.getLast(this.conditionList)).getExecutableList().addAll(condition.getExecutableList());
            } else {
                this.conditionList.add(condition);
            }
        } else if (condition.getConditionType().equals((Object)ConditionTypeEnum.TYPE_WHEN)) {
            if (this.conditionList.size() >= 1 && CollectionUtil.getLast(this.conditionList) instanceof WhenCondition && ((Condition)CollectionUtil.getLast(this.conditionList)).getGroup().equals(condition.getGroup())) {
                ((Condition)CollectionUtil.getLast(this.conditionList)).getExecutableList().addAll(condition.getExecutableList());
            } else {
                this.conditionList.add(condition);
            }
        }
    }
}

