/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.builder;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.builder.LiteFlowWhenConditionBuilder;
import com.yomahub.liteflow.builder.entity.ExecutableEntity;
import com.yomahub.liteflow.core.NodeComponent;
import com.yomahub.liteflow.enums.ConditionTypeEnum;
import com.yomahub.liteflow.exception.ExecutableItemNotFoundException;
import com.yomahub.liteflow.flow.FlowBus;
import com.yomahub.liteflow.flow.element.Chain;
import com.yomahub.liteflow.flow.element.Node;
import com.yomahub.liteflow.flow.element.condition.Condition;
import com.yomahub.liteflow.flow.element.condition.FinallyCondition;
import com.yomahub.liteflow.flow.element.condition.PreCondition;
import com.yomahub.liteflow.flow.element.condition.SwitchCondition;
import com.yomahub.liteflow.flow.element.condition.ThenCondition;
import com.yomahub.liteflow.flow.element.condition.WhenCondition;
import com.yomahub.liteflow.parser.RegexEntity;
import com.yomahub.liteflow.parser.RegexNodeEntity;
import com.yomahub.liteflow.spi.holder.ContextAwareHolder;
import java.util.List;

public class LiteFlowConditionBuilder {
    protected Condition condition;

    public static LiteFlowConditionBuilder createCondition(ConditionTypeEnum conditionType) {
        switch (conditionType) {
            case TYPE_THEN: {
                return LiteFlowConditionBuilder.createThenCondition();
            }
            case TYPE_WHEN: {
                return LiteFlowConditionBuilder.createWhenCondition();
            }
            case TYPE_PRE: {
                return LiteFlowConditionBuilder.createPreCondition();
            }
            case TYPE_FINALLY: {
                return LiteFlowConditionBuilder.createFinallyCondition();
            }
        }
        return null;
    }

    public static LiteFlowConditionBuilder createThenCondition() {
        return new LiteFlowConditionBuilder(new ThenCondition());
    }

    public static LiteFlowWhenConditionBuilder createWhenCondition() {
        return new LiteFlowWhenConditionBuilder(new WhenCondition());
    }

    public static LiteFlowConditionBuilder createPreCondition() {
        return new LiteFlowConditionBuilder(new PreCondition());
    }

    public static LiteFlowConditionBuilder createFinallyCondition() {
        return new LiteFlowConditionBuilder(new FinallyCondition());
    }

    public LiteFlowConditionBuilder(Condition condition) {
        this.condition = condition;
    }

    public LiteFlowConditionBuilder setValue(String value) {
        String[] condArray;
        if (StrUtil.isBlank((CharSequence)value)) {
            return this;
        }
        for (String s : condArray = value.split(",")) {
            String itemExpression = s.trim();
            RegexEntity regexEntity = RegexEntity.parse(itemExpression);
            ExecutableEntity executableEntity = this.convertExecutableEntity(regexEntity);
            this.setExecutable(executableEntity);
        }
        return this;
    }

    private ExecutableEntity convertExecutableEntity(RegexEntity regexEntity) {
        RegexNodeEntity item = regexEntity.getItem();
        ExecutableEntity executableEntity = new ExecutableEntity(item.getId(), item.getTag());
        if (ObjectUtil.isNotNull((Object)regexEntity.getRealItemArray())) {
            for (RegexNodeEntity realItem : regexEntity.getRealItemArray()) {
                executableEntity.addNodeCondComponent(new ExecutableEntity(realItem.getId(), realItem.getTag()));
            }
        }
        return executableEntity;
    }

    public LiteFlowConditionBuilder setExecutable(ExecutableEntity executableEntity) {
        if (FlowBus.containNode(executableEntity.getId())) {
            Node node = FlowBus.copyNode(executableEntity.getId());
            node.setTag(executableEntity.getTag());
            if (CollUtil.isEmpty(executableEntity.getNodeCondComponents())) {
                this.condition.getExecutableList().add(node);
            } else {
                this.buildSwitchNode(node, executableEntity.getNodeCondComponents());
            }
        } else if (this.hasChain(executableEntity.getId())) {
            Chain chain = FlowBus.getChain(executableEntity.getId());
            this.condition.getExecutableList().add(chain);
        } else {
            NodeComponent nodeComponent = (NodeComponent)ContextAwareHolder.loadContextAware().getBean(executableEntity.getId());
            if (ObjectUtil.isNotNull((Object)nodeComponent)) {
                FlowBus.addSpringScanNode(executableEntity.getId(), nodeComponent);
                this.setExecutable(executableEntity);
            } else {
                String errorMsg = StrUtil.format((CharSequence)"executable node[{}] is not found!", (Object[])new Object[]{executableEntity.getId()});
                throw new ExecutableItemNotFoundException(errorMsg);
            }
        }
        return this;
    }

    private void buildSwitchNode(Node node, List<ExecutableEntity> executableEntities) {
        if (CollUtil.isEmpty(executableEntities)) {
            return;
        }
        SwitchCondition switchCondition = new SwitchCondition();
        switchCondition.setSwitchNode(node);
        for (ExecutableEntity realItem : executableEntities) {
            if (FlowBus.containNode(realItem.getId())) {
                Node targetNode = FlowBus.copyNode(realItem.getId());
                targetNode.setTag(realItem.getTag());
                switchCondition.addTargetItem(targetNode);
                continue;
            }
            if (this.hasChain(realItem.getId())) {
                Chain chain = FlowBus.getChain(realItem.getId());
                switchCondition.addTargetItem(chain);
                continue;
            }
            String errorMsg = StrUtil.format((CharSequence)"executable node[{}] is not found!", (Object[])new Object[]{realItem.getId()});
            throw new ExecutableItemNotFoundException(errorMsg);
        }
        this.condition.getExecutableList().add(switchCondition);
    }

    public Condition build() {
        return this.condition;
    }

    private boolean hasChain(String chainId) {
        return FlowBus.containChain(chainId);
    }
}

