/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.core;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.core.FlowExecutorHolder;
import com.yomahub.liteflow.exception.ChainDuplicateException;
import com.yomahub.liteflow.exception.ChainEndException;
import com.yomahub.liteflow.exception.ChainNotFoundException;
import com.yomahub.liteflow.exception.ConfigErrorException;
import com.yomahub.liteflow.exception.CyclicDependencyException;
import com.yomahub.liteflow.exception.FlowExecutorNotInitException;
import com.yomahub.liteflow.exception.MultipleParsersException;
import com.yomahub.liteflow.exception.NoAvailableSlotException;
import com.yomahub.liteflow.flow.FlowBus;
import com.yomahub.liteflow.flow.LiteflowResponse;
import com.yomahub.liteflow.flow.element.Chain;
import com.yomahub.liteflow.flow.element.Node;
import com.yomahub.liteflow.flow.id.IdGeneratorHolder;
import com.yomahub.liteflow.parser.base.FlowParser;
import com.yomahub.liteflow.parser.factory.FlowParserProvider;
import com.yomahub.liteflow.property.LiteflowConfig;
import com.yomahub.liteflow.property.LiteflowConfigGetter;
import com.yomahub.liteflow.slot.DataBus;
import com.yomahub.liteflow.slot.DefaultContext;
import com.yomahub.liteflow.slot.Slot;
import com.yomahub.liteflow.spi.holder.ContextCmpInitHolder;
import com.yomahub.liteflow.thread.ExecutorHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(FlowExecutor.class);
    private static final String PREFIX_FORMAT_CONFIG_REGEX = "xml:|json:|yml:|el_xml:|el_json:|el_yml:";
    private LiteflowConfig liteflowConfig;

    public FlowExecutor() {
        FlowExecutorHolder.setHolder(this);
        DataBus.init();
    }

    public FlowExecutor(LiteflowConfig liteflowConfig) {
        this.liteflowConfig = liteflowConfig;
        LiteflowConfigGetter.setLiteflowConfig(liteflowConfig);
        FlowExecutorHolder.setHolder(this);
        if (BooleanUtil.isTrue((Boolean)liteflowConfig.isParseOnStart())) {
            this.init();
        }
        DataBus.init();
    }

    public void init() {
        if (ObjectUtil.isNull((Object)this.liteflowConfig)) {
            throw new ConfigErrorException("config error, please check liteflow config property");
        }
        ContextCmpInitHolder.loadContextCmpInit().initCmp();
        IdGeneratorHolder.init();
        if (StrUtil.isBlank((CharSequence)this.liteflowConfig.getRuleSource())) {
            return;
        }
        ArrayList sourceRulePathList = ListUtil.toList((Object[])this.liteflowConfig.getRuleSource().split(",|;"));
        FlowParser parser = null;
        HashSet<String> parserNameSet = new HashSet<String>();
        ArrayList<String> rulePathList = new ArrayList<String>();
        for (String path : sourceRulePathList) {
            try {
                parser = FlowParserProvider.lookup(path);
                parserNameSet.add(parser.getClass().getName());
                path = ReUtil.replaceAll((CharSequence)path, (String)PREFIX_FORMAT_CONFIG_REGEX, (String)"");
                rulePathList.add(path);
                if (!BooleanUtil.isTrue((Boolean)this.liteflowConfig.isSupportMultipleType())) continue;
                parser.parseMain(ListUtil.toList((Object[])new String[]{path}));
            }
            catch (CyclicDependencyException e) {
                LOG.error(e.getMessage());
                throw e;
            }
            catch (Exception e) {
                String errorMsg = StrUtil.format((CharSequence)"init flow executor cause error for path {},reason:{}", (Object[])new Object[]{path, e.getMessage()});
                LOG.error(e.getMessage(), (Throwable)e);
                throw new FlowExecutorNotInitException(errorMsg);
            }
        }
        if (BooleanUtil.isFalse((Boolean)this.liteflowConfig.isSupportMultipleType())) {
            if (parserNameSet.size() > 1) {
                String errorMsg = "cannot have multiple different parsers";
                LOG.error(errorMsg);
                throw new MultipleParsersException(errorMsg);
            }
            try {
                if (parser == null) {
                    throw new ConfigErrorException("parse error, please check liteflow config property");
                }
                parser.parseMain(rulePathList);
            }
            catch (CyclicDependencyException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                LOG.error(e.getMessage());
                throw e;
            }
            catch (ChainDuplicateException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                String errorMsg = StrUtil.format((CharSequence)"init flow executor cause error for path {},reason: {}", (Object[])new Object[]{rulePathList, e.getMessage()});
                LOG.error(e.getMessage(), (Throwable)e);
                throw new FlowExecutorNotInitException(errorMsg);
            }
        }
    }

    public void reloadRule() {
        this.init();
    }

    public void invoke(String chainId, Object param, Integer slotIndex) throws Exception {
        LiteflowResponse response = this.execute2Resp(chainId, param, null, null, slotIndex, true);
        if (!response.isSuccess()) {
            throw response.getCause();
        }
    }

    public LiteflowResponse invoke2Resp(String chainId, Object param, Integer slotIndex) {
        return this.execute2Resp(chainId, param, null, null, slotIndex, true);
    }

    public void invoke(String nodeId, Integer slotIndex) throws Exception {
        Node node = FlowBus.getNode(nodeId);
        node.execute(slotIndex);
    }

    public LiteflowResponse execute2Resp(String chainId) {
        return this.execute2Resp(chainId, (Object)null, (Class<?>[])new Class[]{DefaultContext.class});
    }

    public LiteflowResponse execute2Resp(String chainId, Object param) {
        return this.execute2Resp(chainId, param, DefaultContext.class);
    }

    public LiteflowResponse execute2Resp(String chainId, Object param, Class<?> ... contextBeanClazzArray) {
        return this.execute2Resp(chainId, param, contextBeanClazzArray, null, null, false);
    }

    public Future<LiteflowResponse> execute2Future(String chainId, Object param, Class<?> ... contextBeanClazzArray) {
        return ExecutorHelper.loadInstance().buildMainExecutor(this.liteflowConfig.getMainExecutorClass()).submit(() -> FlowExecutorHolder.loadInstance().execute2Resp(chainId, param, contextBeanClazzArray, null, null, false));
    }

    public LiteflowResponse execute2Resp(String chainId, Object param, Object ... contextBeanArray) {
        return this.execute2Resp(chainId, param, null, contextBeanArray, null, false);
    }

    public Future<LiteflowResponse> execute2Future(String chainId, Object param, Object ... contextBeanArray) {
        return ExecutorHelper.loadInstance().buildMainExecutor(this.liteflowConfig.getMainExecutorClass()).submit(() -> FlowExecutorHolder.loadInstance().execute2Resp(chainId, param, null, contextBeanArray, null, false));
    }

    public DefaultContext execute(String chainId, Object param) throws Exception {
        LiteflowResponse response = this.execute2Resp(chainId, param, DefaultContext.class);
        if (!response.isSuccess()) {
            throw response.getCause();
        }
        return (DefaultContext)response.getFirstContextBean();
    }

    private LiteflowResponse execute2Resp(String chainId, Object param, Class<?>[] contextBeanClazzArray, Object[] contextBeanArray, Integer slotIndex, boolean isInnerChain) {
        Slot slot = this.doExecute(chainId, param, contextBeanClazzArray, contextBeanArray, slotIndex, isInnerChain);
        return new LiteflowResponse(slot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Slot doExecute(String chainId, Object param, Class<?>[] contextBeanClazzArray, Object[] contextBeanArray, Integer slotIndex, boolean isInnerChain) {
        if (FlowBus.needInit()) {
            this.init();
        }
        if (!isInnerChain && ObjectUtil.isNull((Object)slotIndex)) {
            slotIndex = ArrayUtil.isNotEmpty((Object[])contextBeanClazzArray) ? Integer.valueOf(DataBus.offerSlotByClass(ListUtil.toList((Object[])contextBeanClazzArray))) : Integer.valueOf(DataBus.offerSlotByBean(ListUtil.toList((Object[])contextBeanArray)));
            if (BooleanUtil.isTrue((Boolean)this.liteflowConfig.getPrintExecutionLog())) {
                LOG.info("slot[{}] offered", (Object)slotIndex);
            }
        }
        if (slotIndex == -1) {
            throw new NoAvailableSlotException("there is no available slot");
        }
        Slot slot = DataBus.getSlot(slotIndex);
        if (ObjectUtil.isNull((Object)slot)) {
            throw new NoAvailableSlotException(StrUtil.format((CharSequence)"the slot[{}] is not exist", (Object[])new Object[]{slotIndex}));
        }
        if (StrUtil.isBlank((CharSequence)slot.getRequestId())) {
            slot.generateRequestId();
            if (BooleanUtil.isTrue((Boolean)this.liteflowConfig.getPrintExecutionLog())) {
                LOG.info("requestId[{}] has generated", (Object)slot.getRequestId());
            }
        }
        if (!isInnerChain) {
            if (ObjectUtil.isNotNull((Object)param)) {
                slot.setRequestData(param);
            }
        } else if (ObjectUtil.isNotNull((Object)param)) {
            slot.setChainReqData(chainId, param);
        }
        Chain chain = null;
        try {
            chain = FlowBus.getChain(chainId);
            if (ObjectUtil.isNull((Object)chain)) {
                String errorMsg = StrUtil.format((CharSequence)"[{}]:couldn't find chain with the id[{}]", (Object[])new Object[]{slot.getRequestId(), chainId});
                throw new ChainNotFoundException(errorMsg);
            }
            chain.execute(slotIndex);
        }
        catch (ChainEndException e) {
            if (ObjectUtil.isNotNull((Object)chain)) {
                String warnMsg = StrUtil.format((CharSequence)"[{}]:chain[{}] execute end on slot[{}]", (Object[])new Object[]{slot.getRequestId(), chain.getChainName(), slotIndex});
                LOG.warn(warnMsg);
            }
        }
        catch (Exception e) {
            if (ObjectUtil.isNotNull((Object)chain)) {
                String errMsg = StrUtil.format((CharSequence)"[{}]:chain[{}] execute error on slot[{}]", (Object[])new Object[]{slot.getRequestId(), chain.getChainName(), slotIndex});
                if (BooleanUtil.isTrue((Boolean)this.liteflowConfig.getPrintExecutionLog())) {
                    LOG.error(errMsg, (Throwable)e);
                } else {
                    LOG.error(errMsg);
                }
            } else if (BooleanUtil.isTrue((Boolean)this.liteflowConfig.getPrintExecutionLog())) {
                LOG.error(e.getMessage(), (Throwable)e);
            } else {
                LOG.error(e.getMessage());
            }
            slot.setException(e);
        }
        finally {
            if (!isInnerChain) {
                slot.printStep();
                DataBus.releaseSlot(slotIndex);
            }
        }
        return slot;
    }

    public LiteflowConfig getLiteflowConfig() {
        return this.liteflowConfig;
    }

    public void setLiteflowConfig(LiteflowConfig liteflowConfig) {
        this.liteflowConfig = liteflowConfig;
        LiteflowConfigGetter.setLiteflowConfig(liteflowConfig);
    }
}

