/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.parser.base;

import com.fasterxml.jackson.databind.JsonNode;
import com.yomahub.liteflow.parser.base.BaseYmlFlowParser;
import com.yomahub.liteflow.parser.helper.ZkParserHelper;
import java.util.List;
import java.util.function.Consumer;
import org.apache.curator.framework.CuratorFramework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseZookeeperYmlFlowParser
extends BaseYmlFlowParser {
    private static final Logger LOG = LoggerFactory.getLogger(BaseZookeeperYmlFlowParser.class);
    private final String nodePath;
    private final ZkParserHelper zkParserHelper;

    public BaseZookeeperYmlFlowParser(String node) {
        this.nodePath = node;
        Consumer<String> parseConsumer = t -> {
            try {
                this.parse((String)t);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
        this.zkParserHelper = new ZkParserHelper(this.nodePath, parseConsumer);
    }

    @Override
    public void parseMain(List<String> pathList) throws Exception {
        CuratorFramework client = this.zkParserHelper.getZkCuratorFramework(pathList);
        String content = new String((byte[])client.getData().forPath(this.nodePath));
        this.zkParserHelper.checkContent(content);
        JsonNode ruleObject = this.convertToJson(content);
        this.parse(ruleObject.toString());
        this.zkParserHelper.listenZkNode(client);
    }

    @Override
    public abstract void parseOneChain(JsonNode var1);
}

