/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.parser.spi.instanceId;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.flow.entity.InstanceInfoDto;
import com.yomahub.liteflow.flow.instanceId.BaseNodeInstanceIdManageSpi;
import com.yomahub.liteflow.parser.constant.ReadType;
import com.yomahub.liteflow.parser.sql.read.SqlRead;
import com.yomahub.liteflow.parser.sql.read.SqlReadFactory;
import com.yomahub.liteflow.parser.sql.read.vo.InstanceIdVO;
import com.yomahub.liteflow.parser.sql.util.JDBCHelper;
import com.yomahub.liteflow.parser.sql.vo.SQLParserVO;
import com.yomahub.liteflow.util.JsonUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class SqlNodeInstanceIdManageSpiImpl
extends BaseNodeInstanceIdManageSpi {
    public List<String> readInstanceIdFile(String chainId) {
        SqlRead insIdRead = SqlReadFactory.getSqlRead(ReadType.INSTANCE_ID);
        List readResult = insIdRead.read(chainId);
        if (CollectionUtil.isNotEmpty(readResult)) {
            return Arrays.asList(((InstanceIdVO)readResult.get(0)).getElDataMd5(), ((InstanceIdVO)readResult.get(0)).getNodeInstanceIdMapJson());
        }
        return Collections.emptyList();
    }

    public void writeInstanceIdFile(List<InstanceInfoDto> instanceIdList, String elMd5, String chainId) {
        JDBCHelper jdbcHelper = JDBCHelper.getInstance();
        SQLParserVO conf = jdbcHelper.getSqlParserVO();
        String insertSql = StrUtil.format((CharSequence)"INSERT INTO {} ({},{},{},{}) VALUES ('{}','{}','{}','{}')", (Object[])new Object[]{conf.getInstanceIdTableName(), conf.getInstanceIdApplicationNameField(), conf.getNodeInstanceIdMapJsonField(), conf.getElDataMd5Field(), conf.getInstanceChainIdField(), conf.getApplicationName(), JsonUtil.toJsonString(instanceIdList), elMd5, chainId});
        String updateSql = StrUtil.format((CharSequence)"UPDATE {} SET {} = '{}',{} = '{}' WHERE {} = '{}' and {} = '{}'", (Object[])new Object[]{conf.getInstanceIdTableName(), conf.getElDataMd5Field(), elMd5, conf.getNodeInstanceIdMapJsonField(), JsonUtil.toJsonString(instanceIdList), conf.getInstanceChainIdField(), chainId, conf.getInstanceIdApplicationNameField(), conf.getApplicationName()});
        String selectSql = StrUtil.format((CharSequence)"SELECT count(*) FROM {} where {} = '{}' and {} = '{}' ", (Object[])new Object[]{conf.getInstanceIdTableName(), conf.getInstanceChainIdField(), chainId, conf.getInstanceIdApplicationNameField(), conf.getApplicationName()});
        jdbcHelper.executeUpsert(selectSql, insertSql, updateSql);
    }
}

