/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.script.javaxpro;

import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.core.NodeComponent;
import com.yomahub.liteflow.enums.ScriptTypeEnum;
import com.yomahub.liteflow.property.LiteflowConfig;
import com.yomahub.liteflow.property.LiteflowConfigGetter;
import com.yomahub.liteflow.script.ScriptExecuteWrap;
import com.yomahub.liteflow.script.ScriptExecutor;
import com.yomahub.liteflow.script.exception.ScriptLoadException;
import com.yomahub.liteflow.util.CopyOnWriteHashMap;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.noear.liquor.eval.CodeSpec;
import org.noear.liquor.eval.Scripts;

public class JavaxProExecutor
extends ScriptExecutor {
    private final Map<String, NodeComponent> compiledScriptMap = new CopyOnWriteHashMap();
    private boolean isCache;

    public ScriptExecutor init() {
        LiteflowConfig liteflowConfig = LiteflowConfigGetter.get();
        String isCacheValue = (String)liteflowConfig.getScriptSetting().get("javax-is-cache");
        this.isCache = Boolean.parseBoolean(isCacheValue);
        super.lifeCycle(null);
        return this;
    }

    public void load(String nodeId, String script) {
        try {
            this.compiledScriptMap.put(nodeId, (NodeComponent)this.compile(script));
        }
        catch (InvocationTargetException e) {
            String errorMsg = StrUtil.format((CharSequence)"script loading error for node[{}],error msg:{}", (Object[])new Object[]{nodeId, e.getTargetException().getMessage()});
            throw new ScriptLoadException(errorMsg);
        }
        catch (Exception e) {
            String errorMsg = StrUtil.format((CharSequence)"script loading error for node[{}],error msg:{}", (Object[])new Object[]{nodeId, e.getMessage()});
            throw new ScriptLoadException(errorMsg);
        }
    }

    public void unLoad(String nodeId) {
        this.compiledScriptMap.remove(nodeId);
    }

    public List<String> getNodeIds() {
        return new ArrayList<String>(this.compiledScriptMap.keySet());
    }

    public Object executeScript(ScriptExecuteWrap wrap) throws Exception {
        NodeComponent cmp = this.getExecutableCmp(wrap);
        cmp.process();
        return cmp.getItemResultMetaValue(Integer.valueOf(wrap.slotIndex));
    }

    public void cleanCache() {
        this.compiledScriptMap.clear();
    }

    public ScriptTypeEnum scriptType() {
        return ScriptTypeEnum.JAVA;
    }

    public Object compile(String script) throws Exception {
        CodeSpec codeSpec = new CodeSpec(this.convertScript(script)).returnType(Object.class).cached(this.isCache);
        return Scripts.eval((CodeSpec)codeSpec, (Object[])new Object[0]);
    }

    public boolean executeIsAccess(ScriptExecuteWrap wrap) {
        NodeComponent cmp = this.getExecutableCmp(wrap);
        return cmp.isAccess();
    }

    public boolean executeIsContinueOnError(ScriptExecuteWrap wrap) {
        NodeComponent cmp = this.getExecutableCmp(wrap);
        return cmp.isContinueOnError();
    }

    public boolean executeIsEnd(ScriptExecuteWrap wrap) {
        NodeComponent cmp = this.getExecutableCmp(wrap);
        return cmp.isEnd();
    }

    public void executeBeforeProcess(ScriptExecuteWrap wrap) {
        NodeComponent cmp = this.getExecutableCmp(wrap);
        cmp.beforeProcess();
    }

    public void executeAfterProcess(ScriptExecuteWrap wrap) {
        NodeComponent cmp = this.getExecutableCmp(wrap);
        cmp.afterProcess();
    }

    public void executeOnSuccess(ScriptExecuteWrap wrap) throws Exception {
        NodeComponent cmp = this.getExecutableCmp(wrap);
        cmp.onSuccess();
    }

    public void executeOnError(ScriptExecuteWrap wrap, Exception e) throws Exception {
        NodeComponent cmp = this.getExecutableCmp(wrap);
        cmp.onError(e);
    }

    public void executeRollback(ScriptExecuteWrap wrap) throws Exception {
        NodeComponent cmp = this.getExecutableCmp(wrap);
        cmp.rollback();
    }

    private NodeComponent getExecutableCmp(ScriptExecuteWrap wrap) {
        if (!this.compiledScriptMap.containsKey(wrap.getNodeId())) {
            String errorMsg = StrUtil.format((CharSequence)"script for node[{}] is not loaded", (Object[])new Object[]{wrap.getNodeId()});
            throw new ScriptLoadException(errorMsg);
        }
        NodeComponent cmp = this.compiledScriptMap.get(wrap.getNodeId());
        cmp.setRefNode(wrap.getCmp().getRefNode());
        cmp.setNodeId(wrap.getNodeId());
        cmp.setType(wrap.getCmp().getType());
        cmp.setSelf(cmp);
        return cmp;
    }

    private String convertScript(String script) {
        String script1 = script.replaceAll("public class", "class").replaceAll("private class", "class").replaceAll("protected class", "class");
        String className = ReUtil.getGroup1((String)"class\\s+(\\w+)\\s+(implements|extends)", (CharSequence)script1);
        if (StrUtil.isBlank((CharSequence)className)) {
            throw new RuntimeException("cannot find class defined");
        }
        return script1 + "\n" + StrUtil.format((CharSequence)"{} item = new {}();\n", (Object[])new Object[]{className, className}) + "return item;";
    }
}

