/*
 * Decompiled with CFR 0.152.
 */
package com.zengtengpeng.codec;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import javax.xml.datatype.XMLGregorianCalendar;
import org.redisson.client.codec.BaseCodec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.Encoder;

public class MyJsonJacksonCodec
extends BaseCodec {
    public static final MyJsonJacksonCodec INSTANCE = new MyJsonJacksonCodec();
    protected final ObjectMapper mapObjectMapper;
    private final Encoder encoder = new Encoder(){

        public ByteBuf encode(Object in) throws IOException {
            ByteBuf out = ByteBufAllocator.DEFAULT.buffer();
            try {
                ByteBufOutputStream os = new ByteBufOutputStream(out);
                MyJsonJacksonCodec.this.mapObjectMapper.writeValue((OutputStream)os, in);
                return os.buffer();
            }
            catch (IOException e) {
                out.release();
                throw e;
            }
            catch (Exception e) {
                out.release();
                throw new IOException(e);
            }
        }
    };
    private final Decoder<Object> decoder = new Decoder<Object>(){

        public Object decode(ByteBuf buf, State state) throws IOException {
            return MyJsonJacksonCodec.this.mapObjectMapper.readValue((InputStream)new ByteBufInputStream(buf), Object.class);
        }
    };
    private static boolean warmedup = false;

    public MyJsonJacksonCodec() {
        this(new ObjectMapper());
    }

    public MyJsonJacksonCodec(ClassLoader classLoader) {
        this(MyJsonJacksonCodec.createObjectMapper(classLoader, new ObjectMapper()));
    }

    public MyJsonJacksonCodec(ClassLoader classLoader, MyJsonJacksonCodec codec) {
        this(MyJsonJacksonCodec.createObjectMapper(classLoader, codec.mapObjectMapper.copy()));
    }

    private void warmup() {
        if (this.getValueEncoder() == null || this.getValueDecoder() == null || warmedup) {
            return;
        }
        warmedup = true;
        try {
            ByteBuf d = this.getValueEncoder().encode((Object)"testValue");
            this.getValueDecoder().decode(d, null);
            d.release();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected static ObjectMapper createObjectMapper(ClassLoader classLoader, ObjectMapper om) {
        TypeFactory tf = TypeFactory.defaultInstance().withClassLoader(classLoader);
        om.setTypeFactory(tf);
        return om;
    }

    public MyJsonJacksonCodec(ObjectMapper mapObjectMapper) {
        this.mapObjectMapper = mapObjectMapper.copy();
        this.init(this.mapObjectMapper);
        this.initTypeInclusion(this.mapObjectMapper);
        this.warmup();
    }

    protected void initTypeInclusion(ObjectMapper mapObjectMapper) {
        ObjectMapper.DefaultTypeResolverBuilder mapTyper = new ObjectMapper.DefaultTypeResolverBuilder(ObjectMapper.DefaultTyping.NON_FINAL){

            public boolean useForType(JavaType t) {
                switch (this._appliesFor) {
                    case NON_CONCRETE_AND_ARRAYS: {
                        while (t.isArrayType()) {
                            t = t.getContentType();
                        }
                    }
                    case OBJECT_AND_NON_CONCRETE: {
                        return t.getRawClass() == Object.class || !t.isConcrete();
                    }
                    case NON_FINAL: {
                        while (t.isArrayType()) {
                            t = t.getContentType();
                        }
                        if (t.getRawClass() == Long.class) {
                            return true;
                        }
                        if (t.getRawClass() == XMLGregorianCalendar.class) {
                            return false;
                        }
                        return !t.isFinal();
                    }
                }
                return t.getRawClass() == Object.class;
            }
        };
        mapTyper.init(JsonTypeInfo.Id.CLASS, null);
        mapTyper.inclusion(JsonTypeInfo.As.PROPERTY);
        mapObjectMapper.setDefaultTyping((TypeResolverBuilder)mapTyper);
    }

    protected void init(ObjectMapper objectMapper) {
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.setVisibility(objectMapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.enable(new JsonGenerator.Feature[]{JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN});
        objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        objectMapper.enable(new MapperFeature[]{MapperFeature.SORT_PROPERTIES_ALPHABETICALLY});
        objectMapper.addMixIn(Throwable.class, ThrowableMixIn.class);
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        javaTimeModule.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        javaTimeModule.addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerializer(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        javaTimeModule.addSerializer(LocalTime.class, (JsonSerializer)new LocalTimeSerializer(DateTimeFormatter.ofPattern("HH:mm:ss")));
        javaTimeModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        javaTimeModule.addDeserializer(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        javaTimeModule.addDeserializer(LocalTime.class, (JsonDeserializer)new LocalTimeDeserializer(DateTimeFormatter.ofPattern("HH:mm:ss")));
        objectMapper.registerModule((Module)javaTimeModule);
    }

    public Decoder<Object> getValueDecoder() {
        return this.decoder;
    }

    public Encoder getValueEncoder() {
        return this.encoder;
    }

    public ClassLoader getClassLoader() {
        if (this.mapObjectMapper.getTypeFactory().getClassLoader() != null) {
            return this.mapObjectMapper.getTypeFactory().getClassLoader();
        }
        return super.getClassLoader();
    }

    public ObjectMapper getObjectMapper() {
        return this.mapObjectMapper;
    }

    @JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class, property="@id")
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE)
    public static class ThrowableMixIn {
    }
}

