/*
 * Decompiled with CFR 0.152.
 */
package com.zengtengpeng.configuration;

import com.zengtengpeng.aop.LockAop;
import com.zengtengpeng.aop.MQAop;
import com.zengtengpeng.operation.RedissonBinary;
import com.zengtengpeng.operation.RedissonCollection;
import com.zengtengpeng.operation.RedissonCollectionCache;
import com.zengtengpeng.operation.RedissonObject;
import com.zengtengpeng.properties.MultipleServerConfig;
import com.zengtengpeng.properties.RedissonProperties;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.config.ReplicatedServersConfig;
import org.redisson.config.SentinelServersConfig;
import org.redisson.config.SingleServerConfig;
import org.redisson.connection.balancer.LoadBalancer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
@EnableConfigurationProperties(value={RedissonProperties.class})
@ConditionalOnClass(value={RedissonProperties.class})
public class RedissonConfiguration {
    @Autowired
    private RedissonProperties redissonProperties;

    @Bean
    @ConditionalOnMissingBean(value={LockAop.class})
    public LockAop lockAop() {
        return new LockAop();
    }

    @Bean
    @ConditionalOnMissingBean(value={MQAop.class})
    public MQAop MQAop() {
        return new MQAop();
    }

    @Bean
    @ConditionalOnMissingBean(value={RedissonBinary.class})
    public RedissonBinary RedissonBinary() {
        return new RedissonBinary();
    }

    @Bean
    @ConditionalOnMissingBean(value={RedissonObject.class})
    public RedissonObject RedissonObject() {
        return new RedissonObject();
    }

    @Bean
    @ConditionalOnMissingBean(value={RedissonCollection.class})
    public RedissonCollection RedissonCollection() {
        return new RedissonCollection();
    }

    @Bean
    @ConditionalOnMissingBean(value={RedissonCollectionCache.class})
    public RedissonCollectionCache RedissonCollectionCache() {
        return new RedissonCollectionCache();
    }

    @Bean
    @ConditionalOnMissingBean(value={RedissonClient.class})
    public RedissonClient redissonClient() {
        Config config = new Config();
        try {
            if (this.redissonProperties.getCodec() != null && !"".equals(this.redissonProperties.getCodec())) {
                config.setCodec((Codec)Class.forName(this.redissonProperties.getCodec()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        config.setTransportMode(this.redissonProperties.getTransportMode());
        if (this.redissonProperties.getThreads() != null) {
            config.setThreads(this.redissonProperties.getThreads().intValue());
        }
        if (this.redissonProperties.getNettyThreads() != null) {
            config.setNettyThreads(this.redissonProperties.getNettyThreads().intValue());
        }
        config.setReferenceEnabled(this.redissonProperties.getReferenceEnabled().booleanValue());
        config.setLockWatchdogTimeout(this.redissonProperties.getLockWatchdogTimeout().longValue());
        config.setKeepPubSubOrder(this.redissonProperties.getKeepPubSubOrder().booleanValue());
        config.setUseScriptCache(this.redissonProperties.getUseScriptCache().booleanValue());
        config.setMinCleanUpDelay(this.redissonProperties.getMinCleanUpDelay().intValue());
        config.setMaxCleanUpDelay(this.redissonProperties.getMaxCleanUpDelay().intValue());
        MultipleServerConfig multipleServerConfig = this.redissonProperties.getMultipleServerConfig();
        switch (this.redissonProperties.getModel()) {
            case SINGLE: {
                SingleServerConfig singleServerConfig = config.useSingleServer();
                com.zengtengpeng.properties.SingleServerConfig param = this.redissonProperties.getSingleServerConfig();
                singleServerConfig.setAddress(this.prefixAddress(param.getAddress()));
                singleServerConfig.setConnectionMinimumIdleSize(param.getConnectionMinimumIdleSize().intValue());
                singleServerConfig.setConnectionPoolSize(param.getConnectionPoolSize().intValue());
                singleServerConfig.setDatabase(param.getDatabase().intValue());
                singleServerConfig.setDnsMonitoringInterval(param.getDnsMonitoringInterval().longValue());
                singleServerConfig.setSubscriptionConnectionMinimumIdleSize(param.getSubscriptionConnectionMinimumIdleSize().intValue());
                singleServerConfig.setSubscriptionConnectionPoolSize(param.getSubscriptionConnectionPoolSize().intValue());
                singleServerConfig.setClientName(this.redissonProperties.getClientName());
                singleServerConfig.setConnectTimeout(this.redissonProperties.getConnectTimeout());
                singleServerConfig.setIdleConnectionTimeout(this.redissonProperties.getIdleConnectionTimeout());
                singleServerConfig.setKeepAlive(this.redissonProperties.getKeepAlive().booleanValue());
                singleServerConfig.setPassword(this.redissonProperties.getPassword());
                singleServerConfig.setPingConnectionInterval(this.redissonProperties.getPingConnectionInterval());
                singleServerConfig.setRetryAttempts(this.redissonProperties.getRetryAttempts());
                singleServerConfig.setRetryInterval(this.redissonProperties.getRetryInterval());
                singleServerConfig.setSslEnableEndpointIdentification(this.redissonProperties.getSslEnableEndpointIdentification().booleanValue());
                singleServerConfig.setSslKeystore(this.redissonProperties.getSslKeystore());
                singleServerConfig.setSslKeystorePassword(this.redissonProperties.getSslKeystorePassword());
                singleServerConfig.setSslProvider(this.redissonProperties.getSslProvider());
                singleServerConfig.setSslTruststore(this.redissonProperties.getSslTruststore());
                singleServerConfig.setSslTruststorePassword(this.redissonProperties.getSslTruststorePassword());
                singleServerConfig.setSubscriptionsPerConnection(this.redissonProperties.getSubscriptionsPerConnection());
                singleServerConfig.setTcpNoDelay(this.redissonProperties.getTcpNoDelay().booleanValue());
                singleServerConfig.setTimeout(this.redissonProperties.getTimeout());
                break;
            }
            case CLUSTER: {
                ClusterServersConfig clusterServersConfig = config.useClusterServers();
                clusterServersConfig.setScanInterval(multipleServerConfig.getScanInterval().intValue());
                clusterServersConfig.setSlaveConnectionMinimumIdleSize(multipleServerConfig.getSlaveConnectionMinimumIdleSize().intValue());
                clusterServersConfig.setSlaveConnectionPoolSize(multipleServerConfig.getSlaveConnectionPoolSize().intValue());
                clusterServersConfig.setFailedSlaveReconnectionInterval(multipleServerConfig.getFailedSlaveReconnectionInterval().intValue());
                clusterServersConfig.setFailedSlaveCheckInterval(multipleServerConfig.getFailedSlaveCheckInterval().intValue());
                clusterServersConfig.setMasterConnectionMinimumIdleSize(multipleServerConfig.getMasterConnectionMinimumIdleSize().intValue());
                clusterServersConfig.setMasterConnectionPoolSize(multipleServerConfig.getMasterConnectionPoolSize().intValue());
                clusterServersConfig.setReadMode(multipleServerConfig.getReadMode());
                clusterServersConfig.setSubscriptionMode(multipleServerConfig.getSubscriptionMode());
                clusterServersConfig.setSubscriptionConnectionMinimumIdleSize(multipleServerConfig.getSubscriptionConnectionMinimumIdleSize().intValue());
                clusterServersConfig.setSubscriptionConnectionPoolSize(multipleServerConfig.getSubscriptionConnectionPoolSize().intValue());
                clusterServersConfig.setDnsMonitoringInterval(multipleServerConfig.getDnsMonitoringInterval().longValue());
                try {
                    clusterServersConfig.setLoadBalancer((LoadBalancer)Class.forName(multipleServerConfig.getLoadBalancer()).newInstance());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                for (String nodeAddress : multipleServerConfig.getNodeAddresses()) {
                    clusterServersConfig.addNodeAddress(new String[]{this.prefixAddress(nodeAddress)});
                }
                clusterServersConfig.setClientName(this.redissonProperties.getClientName());
                clusterServersConfig.setConnectTimeout(this.redissonProperties.getConnectTimeout());
                clusterServersConfig.setIdleConnectionTimeout(this.redissonProperties.getIdleConnectionTimeout());
                clusterServersConfig.setKeepAlive(this.redissonProperties.getKeepAlive().booleanValue());
                clusterServersConfig.setPassword(this.redissonProperties.getPassword());
                clusterServersConfig.setPingConnectionInterval(this.redissonProperties.getPingConnectionInterval());
                clusterServersConfig.setRetryAttempts(this.redissonProperties.getRetryAttempts());
                clusterServersConfig.setRetryInterval(this.redissonProperties.getRetryInterval());
                clusterServersConfig.setSslEnableEndpointIdentification(this.redissonProperties.getSslEnableEndpointIdentification().booleanValue());
                clusterServersConfig.setSslKeystore(this.redissonProperties.getSslKeystore());
                clusterServersConfig.setSslKeystorePassword(this.redissonProperties.getSslKeystorePassword());
                clusterServersConfig.setSslProvider(this.redissonProperties.getSslProvider());
                clusterServersConfig.setSslTruststore(this.redissonProperties.getSslTruststore());
                clusterServersConfig.setSslTruststorePassword(this.redissonProperties.getSslTruststorePassword());
                clusterServersConfig.setSubscriptionsPerConnection(this.redissonProperties.getSubscriptionsPerConnection());
                clusterServersConfig.setTcpNoDelay(this.redissonProperties.getTcpNoDelay().booleanValue());
                clusterServersConfig.setTimeout(this.redissonProperties.getTimeout());
                break;
            }
            case SENTINEL: {
                SentinelServersConfig sentinelServersConfig = config.useSentinelServers();
                sentinelServersConfig.setDatabase(multipleServerConfig.getDatabase().intValue());
                sentinelServersConfig.setMasterName(multipleServerConfig.getMasterName());
                sentinelServersConfig.setScanInterval(multipleServerConfig.getScanInterval().intValue());
                sentinelServersConfig.setSlaveConnectionMinimumIdleSize(multipleServerConfig.getSlaveConnectionMinimumIdleSize().intValue());
                sentinelServersConfig.setSlaveConnectionPoolSize(multipleServerConfig.getSlaveConnectionPoolSize().intValue());
                sentinelServersConfig.setFailedSlaveReconnectionInterval(multipleServerConfig.getFailedSlaveReconnectionInterval().intValue());
                sentinelServersConfig.setFailedSlaveCheckInterval(multipleServerConfig.getFailedSlaveCheckInterval().intValue());
                sentinelServersConfig.setMasterConnectionMinimumIdleSize(multipleServerConfig.getMasterConnectionMinimumIdleSize().intValue());
                sentinelServersConfig.setMasterConnectionPoolSize(multipleServerConfig.getMasterConnectionPoolSize().intValue());
                sentinelServersConfig.setReadMode(multipleServerConfig.getReadMode());
                sentinelServersConfig.setSubscriptionMode(multipleServerConfig.getSubscriptionMode());
                sentinelServersConfig.setSubscriptionConnectionMinimumIdleSize(multipleServerConfig.getSubscriptionConnectionMinimumIdleSize().intValue());
                sentinelServersConfig.setSubscriptionConnectionPoolSize(multipleServerConfig.getSubscriptionConnectionPoolSize().intValue());
                sentinelServersConfig.setDnsMonitoringInterval(multipleServerConfig.getDnsMonitoringInterval().longValue());
                sentinelServersConfig.setCheckSentinelsList(multipleServerConfig.getCheckSentinelsList().booleanValue());
                try {
                    sentinelServersConfig.setLoadBalancer((LoadBalancer)Class.forName(multipleServerConfig.getLoadBalancer()).newInstance());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                for (String nodeAddress : multipleServerConfig.getNodeAddresses()) {
                    sentinelServersConfig.addSentinelAddress(new String[]{this.prefixAddress(nodeAddress)});
                }
                sentinelServersConfig.setClientName(this.redissonProperties.getClientName());
                sentinelServersConfig.setConnectTimeout(this.redissonProperties.getConnectTimeout());
                sentinelServersConfig.setIdleConnectionTimeout(this.redissonProperties.getIdleConnectionTimeout());
                sentinelServersConfig.setKeepAlive(this.redissonProperties.getKeepAlive().booleanValue());
                sentinelServersConfig.setPassword(this.redissonProperties.getPassword());
                sentinelServersConfig.setPingConnectionInterval(this.redissonProperties.getPingConnectionInterval());
                sentinelServersConfig.setRetryAttempts(this.redissonProperties.getRetryAttempts());
                sentinelServersConfig.setRetryInterval(this.redissonProperties.getRetryInterval());
                sentinelServersConfig.setSslEnableEndpointIdentification(this.redissonProperties.getSslEnableEndpointIdentification().booleanValue());
                sentinelServersConfig.setSslKeystore(this.redissonProperties.getSslKeystore());
                sentinelServersConfig.setSslKeystorePassword(this.redissonProperties.getSslKeystorePassword());
                sentinelServersConfig.setSslProvider(this.redissonProperties.getSslProvider());
                sentinelServersConfig.setSslTruststore(this.redissonProperties.getSslTruststore());
                sentinelServersConfig.setSslTruststorePassword(this.redissonProperties.getSslTruststorePassword());
                sentinelServersConfig.setSubscriptionsPerConnection(this.redissonProperties.getSubscriptionsPerConnection());
                sentinelServersConfig.setTcpNoDelay(this.redissonProperties.getTcpNoDelay().booleanValue());
                sentinelServersConfig.setTimeout(this.redissonProperties.getTimeout());
                break;
            }
            case REPLICATED: {
                ReplicatedServersConfig replicatedServersConfig = config.useReplicatedServers();
                replicatedServersConfig.setDatabase(multipleServerConfig.getDatabase().intValue());
                replicatedServersConfig.setScanInterval(multipleServerConfig.getScanInterval().intValue());
                replicatedServersConfig.setSlaveConnectionMinimumIdleSize(multipleServerConfig.getSlaveConnectionMinimumIdleSize().intValue());
                replicatedServersConfig.setSlaveConnectionPoolSize(multipleServerConfig.getSlaveConnectionPoolSize().intValue());
                replicatedServersConfig.setFailedSlaveReconnectionInterval(multipleServerConfig.getFailedSlaveReconnectionInterval().intValue());
                replicatedServersConfig.setFailedSlaveCheckInterval(multipleServerConfig.getFailedSlaveCheckInterval().intValue());
                replicatedServersConfig.setMasterConnectionMinimumIdleSize(multipleServerConfig.getMasterConnectionMinimumIdleSize().intValue());
                replicatedServersConfig.setMasterConnectionPoolSize(multipleServerConfig.getMasterConnectionPoolSize().intValue());
                replicatedServersConfig.setReadMode(multipleServerConfig.getReadMode());
                replicatedServersConfig.setSubscriptionMode(multipleServerConfig.getSubscriptionMode());
                replicatedServersConfig.setSubscriptionConnectionMinimumIdleSize(multipleServerConfig.getSubscriptionConnectionMinimumIdleSize().intValue());
                replicatedServersConfig.setSubscriptionConnectionPoolSize(multipleServerConfig.getSubscriptionConnectionPoolSize().intValue());
                replicatedServersConfig.setDnsMonitoringInterval(multipleServerConfig.getDnsMonitoringInterval().longValue());
                try {
                    replicatedServersConfig.setLoadBalancer((LoadBalancer)Class.forName(multipleServerConfig.getLoadBalancer()).newInstance());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                for (String nodeAddress : multipleServerConfig.getNodeAddresses()) {
                    replicatedServersConfig.addNodeAddress(new String[]{this.prefixAddress(nodeAddress)});
                }
                replicatedServersConfig.setClientName(this.redissonProperties.getClientName());
                replicatedServersConfig.setConnectTimeout(this.redissonProperties.getConnectTimeout());
                replicatedServersConfig.setIdleConnectionTimeout(this.redissonProperties.getIdleConnectionTimeout());
                replicatedServersConfig.setKeepAlive(this.redissonProperties.getKeepAlive().booleanValue());
                replicatedServersConfig.setPassword(this.redissonProperties.getPassword());
                replicatedServersConfig.setPingConnectionInterval(this.redissonProperties.getPingConnectionInterval());
                replicatedServersConfig.setRetryAttempts(this.redissonProperties.getRetryAttempts());
                replicatedServersConfig.setRetryInterval(this.redissonProperties.getRetryInterval());
                replicatedServersConfig.setSslEnableEndpointIdentification(this.redissonProperties.getSslEnableEndpointIdentification().booleanValue());
                replicatedServersConfig.setSslKeystore(this.redissonProperties.getSslKeystore());
                replicatedServersConfig.setSslKeystorePassword(this.redissonProperties.getSslKeystorePassword());
                replicatedServersConfig.setSslProvider(this.redissonProperties.getSslProvider());
                replicatedServersConfig.setSslTruststore(this.redissonProperties.getSslTruststore());
                replicatedServersConfig.setSslTruststorePassword(this.redissonProperties.getSslTruststorePassword());
                replicatedServersConfig.setSubscriptionsPerConnection(this.redissonProperties.getSubscriptionsPerConnection());
                replicatedServersConfig.setTcpNoDelay(this.redissonProperties.getTcpNoDelay().booleanValue());
                replicatedServersConfig.setTimeout(this.redissonProperties.getTimeout());
                break;
            }
            case MASTERSLAVE: {
                MasterSlaveServersConfig masterSlaveServersConfig = config.useMasterSlaveServers();
                masterSlaveServersConfig.setDatabase(multipleServerConfig.getDatabase().intValue());
                masterSlaveServersConfig.setSlaveConnectionMinimumIdleSize(multipleServerConfig.getSlaveConnectionMinimumIdleSize().intValue());
                masterSlaveServersConfig.setSlaveConnectionPoolSize(multipleServerConfig.getSlaveConnectionPoolSize().intValue());
                masterSlaveServersConfig.setFailedSlaveReconnectionInterval(multipleServerConfig.getFailedSlaveReconnectionInterval().intValue());
                masterSlaveServersConfig.setFailedSlaveCheckInterval(multipleServerConfig.getFailedSlaveCheckInterval().intValue());
                masterSlaveServersConfig.setMasterConnectionMinimumIdleSize(multipleServerConfig.getMasterConnectionMinimumIdleSize().intValue());
                masterSlaveServersConfig.setMasterConnectionPoolSize(multipleServerConfig.getMasterConnectionPoolSize().intValue());
                masterSlaveServersConfig.setReadMode(multipleServerConfig.getReadMode());
                masterSlaveServersConfig.setSubscriptionMode(multipleServerConfig.getSubscriptionMode());
                masterSlaveServersConfig.setSubscriptionConnectionMinimumIdleSize(multipleServerConfig.getSubscriptionConnectionMinimumIdleSize().intValue());
                masterSlaveServersConfig.setSubscriptionConnectionPoolSize(multipleServerConfig.getSubscriptionConnectionPoolSize().intValue());
                masterSlaveServersConfig.setDnsMonitoringInterval(multipleServerConfig.getDnsMonitoringInterval().longValue());
                try {
                    masterSlaveServersConfig.setLoadBalancer((LoadBalancer)Class.forName(multipleServerConfig.getLoadBalancer()).newInstance());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                int index = 0;
                for (String nodeAddress : multipleServerConfig.getNodeAddresses()) {
                    if (index++ == 0) {
                        masterSlaveServersConfig.setMasterAddress(this.prefixAddress(nodeAddress));
                        continue;
                    }
                    masterSlaveServersConfig.addSlaveAddress(this.prefixAddress(nodeAddress));
                }
                masterSlaveServersConfig.setClientName(this.redissonProperties.getClientName());
                masterSlaveServersConfig.setConnectTimeout(this.redissonProperties.getConnectTimeout());
                masterSlaveServersConfig.setIdleConnectionTimeout(this.redissonProperties.getIdleConnectionTimeout());
                masterSlaveServersConfig.setKeepAlive(this.redissonProperties.getKeepAlive().booleanValue());
                masterSlaveServersConfig.setPassword(this.redissonProperties.getPassword());
                masterSlaveServersConfig.setPingConnectionInterval(this.redissonProperties.getPingConnectionInterval());
                masterSlaveServersConfig.setRetryAttempts(this.redissonProperties.getRetryAttempts());
                masterSlaveServersConfig.setRetryInterval(this.redissonProperties.getRetryInterval());
                masterSlaveServersConfig.setSslEnableEndpointIdentification(this.redissonProperties.getSslEnableEndpointIdentification().booleanValue());
                masterSlaveServersConfig.setSslKeystore(this.redissonProperties.getSslKeystore());
                masterSlaveServersConfig.setSslKeystorePassword(this.redissonProperties.getSslKeystorePassword());
                masterSlaveServersConfig.setSslProvider(this.redissonProperties.getSslProvider());
                masterSlaveServersConfig.setSslTruststore(this.redissonProperties.getSslTruststore());
                masterSlaveServersConfig.setSslTruststorePassword(this.redissonProperties.getSslTruststorePassword());
                masterSlaveServersConfig.setSubscriptionsPerConnection(this.redissonProperties.getSubscriptionsPerConnection());
                masterSlaveServersConfig.setTcpNoDelay(this.redissonProperties.getTcpNoDelay().booleanValue());
                masterSlaveServersConfig.setTimeout(this.redissonProperties.getTimeout());
            }
        }
        return Redisson.create((Config)config);
    }

    private String prefixAddress(String address) {
        if (!StringUtils.isEmpty((Object)address) && !address.startsWith("redis")) {
            return "redis://" + address;
        }
        return address;
    }
}

