/*
 * Decompiled with CFR 0.152.
 */
package com.zengtengpeng.mq;

import com.zengtengpeng.annotation.MQListener;
import org.redisson.api.RPatternTopic;
import org.redisson.api.RTopic;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.util.ReflectionUtils;

public class RedissonMQListener
implements BeanPostProcessor {
    Logger logger = LoggerFactory.getLogger(RedissonMQListener.class);
    @Autowired
    private RedissonClient redissonClient;

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        ReflectionUtils.doWithMethods(bean.getClass(), method -> {
            MQListener annotation = method.getDeclaredAnnotation(MQListener.class);
            if (annotation != null) {
                switch (annotation.model()) {
                    case PRECISE: {
                        RTopic topic = this.redissonClient.getTopic(annotation.name());
                        this.logger.info("\u6ce8\u89e3redisson\u7cbe\u51c6\u76d1\u542c\u5668name={}", (Object)annotation.name());
                        topic.addListener(Object.class, (channel, msg) -> {
                            try {
                                Object[] aras = new Object[method.getParameterTypes().length];
                                int index = 0;
                                for (Class<?> parameterType : method.getParameterTypes()) {
                                    String simpleName = parameterType.getSimpleName();
                                    aras[index++] = "CharSequence".equals(simpleName) ? channel : (msg.getClass().getSimpleName().equals(simpleName) || "Object".equals(simpleName) ? msg : null);
                                }
                                method.invoke(bean, aras);
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        });
                        break;
                    }
                    case PATTERN: {
                        RPatternTopic patternTopic = this.redissonClient.getPatternTopic(annotation.name());
                        this.logger.info("\u6ce8\u89e3redisson\u6a21\u7cca\u76d1\u542c\u5668name={}", (Object)annotation.name());
                        patternTopic.addListener(Object.class, (pattern, channel, msg) -> {
                            try {
                                Object[] aras = new Object[method.getParameterTypes().length];
                                int index = 0;
                                boolean patternFlag = false;
                                for (Class<?> parameterType : method.getParameterTypes()) {
                                    String simpleName = parameterType.getSimpleName();
                                    if ("CharSequence".equals(simpleName)) {
                                        if (!patternFlag) {
                                            patternFlag = true;
                                            aras[index++] = pattern;
                                            continue;
                                        }
                                        aras[index++] = channel;
                                        continue;
                                    }
                                    aras[index++] = msg.getClass().getSimpleName().equals(simpleName) || "Object".equals(simpleName) ? msg : null;
                                }
                                method.invoke(bean, aras);
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        });
                    }
                }
            }
        }, (ReflectionUtils.MethodFilter)ReflectionUtils.USER_DECLARED_METHODS);
        return bean;
    }
}

