/*
 * Decompiled with CFR 0.152.
 */
package com.zengtengpeng.operation;

import com.zengtengpeng.func.DataCache;
import com.zengtengpeng.func.RealData;
import com.zengtengpeng.func.RealDataList;
import com.zengtengpeng.func.RealDataMap;
import com.zengtengpeng.func.RealDataSet;
import com.zengtengpeng.properties.RedissonProperties;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.redisson.api.RList;
import org.redisson.api.RMap;
import org.redisson.api.RSet;
import org.redisson.api.RedissonClient;
import org.springframework.util.ObjectUtils;

public class RedissonCollection {
    @Resource
    private RedissonClient redissonClient;
    @Resource
    private RedissonProperties redissonProperties;

    public <K, V> RMap<K, V> getMap(String name) {
        return this.redissonClient.getMap(name);
    }

    public <K, V> RMap<K, V> getMap(String name, RealDataMap<K, V> realDataMap) {
        return this.getMap(name, realDataMap, this.redissonProperties.getDataValidTime());
    }

    public <K, V> RMap<K, V> getMap(String name, RealDataMap<K, V> realDataMap, Long time) {
        RMap map = this.redissonClient.getMap(name);
        if (map == null || map.size() == 0) {
            Map<K, V> objectObjectMap = realDataMap.get();
            this.setMapValues(name, objectObjectMap, time);
        }
        return this.redissonClient.getMap(name);
    }

    public <T> T getMapValue(String name, String key) {
        RMap map = this.getMap(name);
        return (T)map.get((Object)key);
    }

    public <T> T getMapValue(String name, String key, RealData<T> realData) {
        return this.getMapValue(name, key, realData, this.redissonProperties.getDataValidTime());
    }

    public <T> T getMapValue(String name, String key, RealData<T> realData, Long time) {
        RMap map = this.getMap(name);
        Object o = map.get((Object)key);
        if (o == null) {
            o = realData.get();
            if (ObjectUtils.isEmpty((Object)o)) {
                map.remove((Object)key);
            } else {
                this.setMapValue(name, key, o, time);
            }
        }
        return (T)o;
    }

    public <T> T getMapValue(String name, String key, RealData<T> realData, DataCache<T> dataCache, Long time) {
        RMap map = this.getMap(name);
        Object o = map.get((Object)key);
        if (o == null) {
            o = realData.get();
            if (ObjectUtils.isEmpty((Object)o)) {
                map.remove((Object)key);
            } else {
                Boolean cache = dataCache.isCache(o);
                if (cache.booleanValue()) {
                    this.setMapValue(name, key, o, time);
                }
            }
        }
        return (T)o;
    }

    public <K, V> void setMapValues(String name, Map<K, V> data, Long time) {
        RMap map = this.redissonClient.getMap(name);
        map.putAll(data);
        Long dataValidTime = this.redissonProperties.getDataValidTime();
        if (time == null) {
            map.expire(Duration.ofMillis(dataValidTime));
        } else if (time != -1L) {
            map.expire(Duration.ofMillis(time));
        }
    }

    public <T> void setMapValue(String name, String key, T value, Long time) {
        RMap map = this.redissonClient.getMap(name);
        map.put((Object)key, value);
        Long dataValidTime = this.redissonProperties.getDataValidTime();
        if (time == null) {
            map.expire(Duration.ofMillis(dataValidTime));
        } else if (time != -1L) {
            map.expire(Duration.ofMillis(time));
        }
    }

    public <K, V> void setMapValues(String name, Map<K, V> data) {
        this.setMapValues(name, data, this.redissonProperties.getDataValidTime());
    }

    public void setMapValue(String name, String key, Object value) {
        this.setMapValue(name, key, value, this.redissonProperties.getDataValidTime());
    }

    public <T> RList<T> getList(String name) {
        return this.redissonClient.getList(name);
    }

    public <T> RList<T> getList(String name, RealDataList<T> realDataList, Long time) {
        RList<T> list = this.getList(name);
        if (list == null || list.size() == 0) {
            List<T> objects = realDataList.get();
            this.setListValues(name, objects, time);
        }
        return this.getList(name);
    }

    public <T> RList<T> getList(String name, RealDataList<T> realDataList) {
        return this.getList(name, realDataList, this.redissonProperties.getDataValidTime());
    }

    public <T> T getListValue(String name, Integer index) {
        RList<T> list = this.getList(name);
        return (T)list.get(index.intValue());
    }

    public <T> void setListValues(String name, List<T> data, Long time) {
        RList list = this.redissonClient.getList(name);
        list.addAll(data);
        Long dataValidTime = this.redissonProperties.getDataValidTime();
        if (time == null) {
            list.expire(Duration.ofMillis(dataValidTime));
        } else if (time != -1L) {
            list.expire(Duration.ofMillis(time));
        }
    }

    public <T> void setListValue(String name, T data, Long time) {
        RList list = this.redissonClient.getList(name);
        list.add(data);
        Long dataValidTime = this.redissonProperties.getDataValidTime();
        if (time == null) {
            list.expire(Duration.ofMillis(dataValidTime));
        } else if (time != -1L) {
            list.expire(Duration.ofMillis(time));
        }
    }

    public <T> void setListValues(String name, List<T> data) {
        this.setListValues(name, data, this.redissonProperties.getDataValidTime());
    }

    public void setListValue(String name, Object data) {
        this.setListValue(name, data, this.redissonProperties.getDataValidTime());
    }

    public <T> RSet<T> getSet(String name) {
        return this.redissonClient.getSet(name);
    }

    public <T> RSet<T> getSet(String name, RealDataSet<T> realDataSet, Long time) {
        RSet<T> set = this.getSet(name);
        if (set == null || set.size() == 0) {
            Set<T> objects = realDataSet.get();
            this.setSetValues(name, objects, time);
        }
        return this.getSet(name);
    }

    public <T> RSet<T> getSet(String name, RealDataSet<T> realDataSet) {
        return this.getSet(name, realDataSet, this.redissonProperties.getDataValidTime());
    }

    public <T> void setSetValues(String name, Set<T> data, Long time) {
        RSet set = this.redissonClient.getSet(name);
        set.addAll(data);
        Long dataValidTime = this.redissonProperties.getDataValidTime();
        if (time == null) {
            set.expire(Duration.ofMillis(dataValidTime));
        } else if (time != -1L) {
            set.expire(Duration.ofMillis(time));
        }
    }

    public <T> void setSetValue(String name, T data, Long time) {
        RSet set = this.redissonClient.getSet(name);
        set.add(data);
        Long dataValidTime = this.redissonProperties.getDataValidTime();
        if (time == null) {
            set.expire(Duration.ofMillis(dataValidTime));
        } else if (time != -1L) {
            set.expire(Duration.ofMillis(time));
        }
    }

    public <T> void setSetValues(String name, Set<T> data) {
        this.setSetValues(name, data, this.redissonProperties.getDataValidTime());
    }

    public void setSetValues(String name, Object data) {
        this.setSetValue(name, data, this.redissonProperties.getDataValidTime());
    }
}

