/*
 * Decompiled with CFR 0.152.
 */
package com.zengtengpeng.operation;

import com.zengtengpeng.func.DataCache;
import com.zengtengpeng.func.RealData;
import com.zengtengpeng.properties.RedissonProperties;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.redisson.api.RBucket;
import org.redisson.api.RedissonClient;
import org.springframework.util.ObjectUtils;

public class RedissonObject {
    @Resource
    private RedissonClient redissonClient;
    @Resource
    private RedissonProperties redissonProperties;

    public <T> T getValue(String name) {
        RBucket bucket = this.redissonClient.getBucket(name);
        return (T)bucket.get();
    }

    public <T> T getValue(String name, RealData<T> realData) {
        return this.getValue(name, realData, this.redissonProperties.getDataValidTime());
    }

    public <T> T getValue(String name, RealData<T> realData, Long time) {
        T value = this.getValue(name);
        if (value == null) {
            value = realData.get();
            if (ObjectUtils.isEmpty(value)) {
                this.delete(name);
            } else {
                this.setValue(name, value, time);
            }
        }
        return value;
    }

    public <T> T getValue(String name, RealData<T> realData, DataCache<T> dataCache, Long time) {
        T value = this.getValue(name);
        if (value == null) {
            value = realData.get();
            if (ObjectUtils.isEmpty(value)) {
                this.delete(name);
            } else {
                Boolean cache = dataCache.isCache(value);
                if (cache.booleanValue()) {
                    this.setValue(name, value, time);
                }
            }
        }
        return value;
    }

    public <T> RBucket<T> getBucket(String name) {
        return this.redissonClient.getBucket(name);
    }

    public <T> void setValue(String name, T value) {
        this.setValue(name, value, this.redissonProperties.getDataValidTime());
    }

    public <T> void setValue(String name, T value, Long time) {
        RBucket bucket = this.redissonClient.getBucket(name);
        if (time == -1L) {
            bucket.set(value);
        } else {
            bucket.set(value, time.longValue(), TimeUnit.MILLISECONDS);
        }
    }

    public <T> Boolean trySetValue(String name, T value, Long time) {
        RBucket bucket = this.redissonClient.getBucket(name);
        boolean b = time == -1L ? bucket.trySet(value) : bucket.trySet(value, time.longValue(), TimeUnit.MILLISECONDS);
        return b;
    }

    public <T> Boolean trySetValue(String name, T value) {
        return this.trySetValue(name, value, this.redissonProperties.getDataValidTime());
    }

    public Boolean delete(String name) {
        return this.redissonClient.getBucket(name).delete();
    }
}

