/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.FileSet;

public class Slice2FreezeJTask
extends SliceTask {
    private File _translator = null;
    private List<Dict> _dicts = new LinkedList<Dict>();
    private List<Dictindex> _dictIndices = new LinkedList<Dictindex>();
    private List<Index> _indices = new LinkedList<Index>();

    public void setTranslator(File prog) {
        this._translator = prog;
    }

    public Dict createDict() {
        Dict d = new Dict();
        this._dicts.add(d);
        return d;
    }

    public Index createIndex() {
        Index i = new Index();
        this._indices.add(i);
        return i;
    }

    public Dictindex createDictindex() {
        Dictindex i = new Dictindex();
        this._dictIndices.add(i);
        return i;
    }

    public void execute() throws BuildException {
        if (this._dicts.isEmpty() && this._indices.isEmpty()) {
            throw new BuildException("No dictionary or index specified");
        }
        HashMap<String, SliceTask.SliceDependency> dependencies = this.readDependencies();
        boolean build = false;
        LinkedList<File> sliceFiles = new LinkedList<File>();
        for (FileSet fileSet : this._fileSets) {
            String[] stringArray;
            DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
            for (String file : stringArray = directoryScanner.getIncludedFiles()) {
                SliceTask.SliceDependency depend;
                File file2 = new File(fileSet.getDir(this.getProject()), file);
                sliceFiles.add(file2);
                if (build || (depend = dependencies.get(this.getSliceTargetKey(file2.toString()))) != null && depend.isUpToDate()) continue;
                build = true;
            }
        }
        if (!build) {
            for (Dict dict : this._dicts) {
                SliceTask.SliceDependency sliceDependency = dependencies.get(this.getDictTargetKey(dict));
                if (sliceDependency != null) continue;
                build = true;
                break;
            }
            for (Index index : this._indices) {
                SliceTask.SliceDependency sliceDependency = dependencies.get(this.getIndexTargetKey(index));
                if (sliceDependency != null) continue;
                build = true;
                break;
            }
        }
        StringBuilder dictString = new StringBuilder(128);
        for (Dict dict : this._dicts) {
            dictString.append(" --dict ");
            dictString.append(dict.getName());
            dictString.append(",");
            dictString.append(dict.getKey());
            dictString.append(",");
            dictString.append(dict.getValue());
        }
        StringBuilder stringBuilder = new StringBuilder(128);
        for (Dictindex dictindex : this._dictIndices) {
            stringBuilder.append(" --dict-index ");
            stringBuilder.append(dictindex.getName());
            if (dictindex.getMember() != null) {
                stringBuilder.append(",");
                stringBuilder.append(dictindex.getMember());
            }
            if (dictindex.getCasesensitive()) continue;
            stringBuilder.append(",case-insensitive");
        }
        StringBuilder stringBuilder2 = new StringBuilder();
        for (Index i : this._indices) {
            stringBuilder2.append(" --index ");
            stringBuilder2.append(i.getName());
            stringBuilder2.append(",");
            stringBuilder2.append(i.getType());
            stringBuilder2.append(",");
            stringBuilder2.append(i.getMember());
            if (i.getCasesensitive()) continue;
            stringBuilder2.append(",case-insensitive");
        }
        if (!build) {
            this.log("skipping" + dictString + stringBuilder2);
            return;
        }
        StringBuilder stringBuilder3 = new StringBuilder(256);
        if (this._ice) {
            stringBuilder3.append(" --ice");
        }
        if (this._underscore) {
            stringBuilder3.append(" --underscore");
        }
        if (this._outputDir != null) {
            stringBuilder3.append(" --output-dir ");
            stringBuilder3.append(this._outputDirString);
        }
        if (this._includePath != null) {
            String[] dirs = this._includePath.list();
            for (String string : dirs) {
                stringBuilder3.append(" -I");
                if (string.indexOf(32) != -1) {
                    stringBuilder3.append('\"' + string + '\"');
                    continue;
                }
                stringBuilder3.append(string);
            }
        }
        if (!this._defines.isEmpty()) {
            for (SliceDefine define : this._defines) {
                stringBuilder3.append(" -D");
                stringBuilder3.append(define.getName());
                String value = define.getValue();
                if (value == null) continue;
                stringBuilder3.append("=");
                stringBuilder3.append(value);
            }
        }
        stringBuilder3.append(dictString.toString());
        stringBuilder3.append(stringBuilder.toString());
        stringBuilder3.append(stringBuilder2.toString());
        if (!this._meta.isEmpty()) {
            for (SliceMeta m : this._meta) {
                stringBuilder3.append(" --meta " + m.getValue());
            }
        }
        for (File f : sliceFiles) {
            stringBuilder3.append(" ");
            String s = f.toString();
            if (s.indexOf(32) != -1) {
                stringBuilder3.append('\"' + s + '\"');
                continue;
            }
            stringBuilder3.append(s);
        }
        String translator = this._translator == null ? this.getDefaultTranslator("slice2freezej") : this._translator.toString();
        this.log(translator + " " + stringBuilder3);
        ExecTask task = (ExecTask)this.getProject().createTask("exec");
        this.addLdLibraryPath(task);
        task.setFailonerror(true);
        Commandline.Argument arg = task.createArg();
        arg.setLine(stringBuilder3.toString());
        task.setExecutable(translator);
        task.execute();
        if (!sliceFiles.isEmpty()) {
            StringBuilder stringBuilder4 = new StringBuilder(256);
            stringBuilder4.append("--depend-xml");
            if (this._ice) {
                stringBuilder4.append(" --ice");
            }
            if (this._underscore) {
                stringBuilder4.append(" --underscore");
            }
            if (this._includePath != null) {
                String[] dirs;
                for (String dir : dirs = this._includePath.list()) {
                    stringBuilder4.append(" -I");
                    if (dir.indexOf(32) != -1) {
                        stringBuilder4.append('\"');
                        stringBuilder4.append(dir);
                        stringBuilder4.append('\"');
                        continue;
                    }
                    stringBuilder4.append(dir);
                }
            }
            stringBuilder4.append(dictString.toString());
            stringBuilder4.append(stringBuilder.toString());
            stringBuilder4.append(stringBuilder2.toString());
            for (File file : sliceFiles) {
                stringBuilder4.append(" ");
                String s = file.toString();
                if (s.indexOf(32) != -1) {
                    stringBuilder4.append('\"');
                    stringBuilder4.append(s);
                    stringBuilder4.append('\"');
                    continue;
                }
                stringBuilder4.append(s);
            }
            String outputProperty = "slice2freezej.depend." + System.currentTimeMillis();
            task = (ExecTask)this.getProject().createTask("exec");
            this.addLdLibraryPath(task);
            task.setFailonerror(true);
            arg = task.createArg();
            arg.setLine(stringBuilder4.toString());
            task.setExecutable(translator);
            task.setOutputproperty(outputProperty);
            task.execute();
            List<SliceTask.SliceDependency> list = this.parseDependencies(this.getProject().getProperty(outputProperty));
            for (SliceTask.SliceDependency dep : list) {
                dependencies.put(this.getSliceTargetKey(dep._dependencies[0]), dep);
            }
        }
        for (Dict dict : this._dicts) {
            dependencies.put(this.getDictTargetKey(dict), new SliceTask.SliceDependency(this));
        }
        for (Index index : this._indices) {
            dependencies.put(this.getIndexTargetKey(index), new SliceTask.SliceDependency(this));
        }
        this.writeDependencies(dependencies);
    }

    private String getSliceTargetKey(String slice) {
        String name = this._dicts.size() > 0 ? this._dicts.get(0).getName() : this._indices.get(0).getName();
        return "slice2freezej " + this._outputDir.toString() + name + slice;
    }

    private String getDictTargetKey(Dict d) {
        return "slice2freezej " + this._outputDir.toString() + d.getName();
    }

    private String getIndexTargetKey(Index i) {
        return "slice2freezej " + this._outputDir.toString() + i.getName();
    }

    public class Index {
        private String _name;
        private String _type;
        private String _member;
        private boolean _caseSensitive = true;

        public void setName(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }

        public void setType(String type) {
            this._type = type;
        }

        public String getType() {
            return this._type;
        }

        public void setMember(String member) {
            this._member = member;
        }

        public String getMember() {
            return this._member;
        }

        public void setCasesensitive(boolean caseSensitive) {
            this._caseSensitive = caseSensitive;
        }

        public boolean getCasesensitive() {
            return this._caseSensitive;
        }
    }

    public class Dictindex {
        private String _name;
        private String _member;
        private boolean _caseSensitive = true;

        public void setName(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }

        public void setMember(String member) {
            this._member = member;
        }

        public String getMember() {
            return this._member;
        }

        public void setCasesensitive(boolean caseSensitive) {
            this._caseSensitive = caseSensitive;
        }

        public boolean getCasesensitive() {
            return this._caseSensitive;
        }
    }

    public class Dict {
        private String _name;
        private String _key;
        private String _value;

        public void setName(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }

        public void setKey(String key) {
            this._key = key;
        }

        public String getKey() {
            return this._key;
        }

        public void setValue(String value) {
            this._value = value;
        }

        public String getValue() {
            return this._value;
        }
    }
}

