/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.FileSet;

public class Slice2JavaTask
extends SliceTask {
    private File _translator = null;
    private boolean _tie = false;
    private boolean _compat = false;
    private String _checksum = null;
    private boolean _stream;

    public void setTranslator(File prog) {
        this._translator = prog;
    }

    public void setTie(boolean tie) {
        this._tie = tie;
    }

    public void setCompat(boolean compat) {
        this._compat = compat;
    }

    public void setChecksum(String checksum) {
        this._checksum = checksum;
    }

    public void setStream(boolean stream) {
        this._stream = stream;
    }

    public void execute() throws BuildException {
        if (this._fileSets.isEmpty()) {
            throw new BuildException("No fileset specified");
        }
        HashMap<String, SliceTask.SliceDependency> dependencies = this.readDependencies();
        HashSet<File> buildList = new HashSet<File>();
        HashSet<File> skipList = new HashSet<File>();
        for (FileSet fileset : this._fileSets) {
            String[] files;
            DirectoryScanner scanner = fileset.getDirectoryScanner(this.getProject());
            scanner.scan();
            String[] stringArray = files = scanner.getIncludedFiles();
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String file = stringArray[i];
                File slice = new File(fileset.getDir(this.getProject()), file);
                SliceTask.SliceDependency depend = dependencies.get(this.getTargetKey(slice.toString()));
                if (depend == null || !depend.isUpToDate()) {
                    buildList.add(slice);
                    continue;
                }
                skipList.add(slice);
            }
        }
        if (this._checksum != null && this._checksum.length() > 0 && !buildList.isEmpty()) {
            buildList.addAll(skipList);
        } else {
            for (File file : skipList) {
                this.log("skipping " + file.getName());
            }
        }
        if (!buildList.isEmpty()) {
            String translator = this._translator == null ? this.getDefaultTranslator("slice2java") : this._translator.toString();
            StringBuilder cmd = new StringBuilder(256);
            if (this._outputDir != null) {
                cmd.append(" --output-dir ");
                cmd.append(this._outputDirString);
            }
            if (this._includePath != null) {
                String[] dirs = this._includePath.list();
                for (String dir : dirs) {
                    cmd.append(" -I");
                    if (dir.indexOf(32) != -1) {
                        cmd.append('\"');
                        cmd.append(dir);
                        cmd.append('\"');
                        continue;
                    }
                    cmd.append(dir);
                }
            }
            if (!this._defines.isEmpty()) {
                for (SliceDefine define : this._defines) {
                    cmd.append(" -D");
                    cmd.append(define.getName());
                    String value = define.getValue();
                    if (value == null) continue;
                    cmd.append("=");
                    cmd.append(value);
                }
            }
            if (this._tie) {
                cmd.append(" --tie");
            }
            if (this._compat) {
                cmd.append(" --compat");
            }
            if (this._checksum != null && this._checksum.length() > 0) {
                cmd.append(" --checksum ");
                cmd.append(this._checksum);
            }
            if (this._stream) {
                cmd.append(" --stream");
            }
            if (!this._meta.isEmpty()) {
                for (SliceMeta m : this._meta) {
                    cmd.append(" --meta ");
                    cmd.append(m.getValue());
                }
            }
            if (this._ice) {
                cmd.append(" --ice");
            }
            if (this._underscore) {
                cmd.append(" --underscore");
            }
            for (File f : buildList) {
                cmd.append(" ");
                String s = f.toString();
                if (s.indexOf(32) != -1) {
                    cmd.append('\"');
                    cmd.append(s);
                    cmd.append('\"');
                    continue;
                }
                cmd.append(s);
            }
            this.log(translator + " " + cmd);
            ExecTask task = (ExecTask)this.getProject().createTask("exec");
            this.addLdLibraryPath(task);
            task.setFailonerror(true);
            Commandline.Argument arg = task.createArg();
            arg.setLine(cmd.toString());
            task.setExecutable(translator);
            task.execute();
            cmd = new StringBuilder(256);
            cmd.append("--depend-xml");
            if (this._ice) {
                cmd.append(" --ice");
            }
            if (this._underscore) {
                cmd.append(" --underscore");
            }
            if (this._includePath != null) {
                String[] dirs;
                for (String dir : dirs = this._includePath.list()) {
                    cmd.append(" -I");
                    if (dir.indexOf(32) != -1) {
                        cmd.append('\"');
                        cmd.append(dir);
                        cmd.append('\"');
                        continue;
                    }
                    cmd.append(dir);
                }
            }
            for (File f : buildList) {
                cmd.append(" ");
                String s = f.toString();
                if (s.indexOf(32) != -1) {
                    cmd.append('\"');
                    cmd.append(s);
                    cmd.append('\"');
                    continue;
                }
                cmd.append(s);
            }
            String outputProperty = "slice2java.depend." + System.currentTimeMillis();
            String errorProperty = "slice2java.error." + System.currentTimeMillis();
            task = (ExecTask)this.getProject().createTask("exec");
            this.addLdLibraryPath(task);
            task.setFailonerror(true);
            arg = task.createArg();
            arg.setLine(cmd.toString());
            task.setExecutable(translator);
            task.setOutputproperty(outputProperty);
            task.setErrorProperty(errorProperty);
            task.execute();
            List<SliceTask.SliceDependency> newDependencies = this.parseDependencies(this.getProject().getProperty(outputProperty));
            for (SliceTask.SliceDependency dep : newDependencies) {
                dependencies.put(this.getTargetKey(dep._dependencies[0]), dep);
            }
            this.writeDependencies(dependencies);
        }
    }

    private String getTargetKey(String slice) {
        return "slice2java " + this._outputDir.toString() + " " + slice;
    }
}

