/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SliceTask
extends Task {
    protected File _dependencyFile = null;
    protected File _outputDir = null;
    protected String _outputDirString = null;
    protected boolean _ice = false;
    protected boolean _underscore;
    protected Path _includePath = null;
    protected List<FileSet> _fileSets = new LinkedList<FileSet>();
    protected List<SliceDefine> _defines = new LinkedList<SliceDefine>();
    protected List<SliceMeta> _meta = new LinkedList<SliceMeta>();
    private String _iceHome;

    public void setDependencyFile(File file) {
        this._dependencyFile = file;
    }

    public void setOutputdir(File dir) {
        this._outputDir = dir;
        this._outputDirString = this._outputDir.toString();
        if (this._outputDirString.indexOf(32) != -1) {
            this._outputDirString = '\"' + this._outputDirString + '\"';
        }
    }

    public void setIce(boolean ice) {
        this._ice = ice;
    }

    public void setUnderscore(boolean underscore) {
        this._underscore = underscore;
    }

    public Path createIncludePath() {
        if (this._includePath == null) {
            this._includePath = new Path(this.getProject());
        }
        return this._includePath.createPath();
    }

    public void setIncludePathRef(Reference ref) {
        this.createIncludePath().setRefid(ref);
    }

    public void setIncludePath(Path includePath) {
        if (this._includePath == null) {
            this._includePath = includePath;
        } else {
            this._includePath.append(includePath);
        }
    }

    public FileSet createFileset() {
        FileSet fileset = new FileSet();
        this._fileSets.add(fileset);
        return fileset;
    }

    public void addConfiguredDefine(SliceDefine define) throws BuildException {
        if (define.getName() == null) {
            throw new BuildException("The name attribute must be supplied in a <define> element");
        }
        this._defines.add(define);
    }

    public void addConfiguredMeta(SliceMeta meta) {
        if (meta.getValue().length() > 0) {
            this._meta.add(meta);
        }
    }

    protected HashMap<String, SliceDependency> readDependencies() {
        if (this._dependencyFile == null) {
            this._dependencyFile = this._outputDir != null ? new File(this._outputDir, ".depend") : new File(".depend");
        }
        try {
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(this._dependencyFile));
            HashMap dependencies = (HashMap)in.readObject();
            in.close();
            return dependencies;
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return new HashMap<String, SliceDependency>();
    }

    protected void writeDependencies(HashMap<String, SliceDependency> dependencies) {
        try {
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(this._dependencyFile));
            out.writeObject(dependencies);
            out.close();
        }
        catch (IOException ex) {
            throw new BuildException("Unable to write dependencies in file " + this._dependencyFile.getPath() + ": " + ex);
        }
    }

    protected List<SliceDependency> parseDependencies(String allDependencies) {
        Slice2JavaDependenciesParser parser = new Slice2JavaDependenciesParser();
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(allDependencies.getBytes());
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new BufferedInputStream(in));
            parser.visit(doc);
        }
        catch (SAXException ex) {
            throw new BuildException("Unable to read dependencies from slice translator: " + ex);
        }
        catch (ParserConfigurationException ex) {
            throw new BuildException("Unable to read dependencies from slice translator: " + ex);
        }
        catch (IOException ex) {
            throw new BuildException("Unable to read dependencies from slice translator: " + ex);
        }
        return parser.dependencies;
    }

    protected String getDefaultTranslator(String name) {
        String iceInstall = this.getIceHome();
        if (iceInstall != null) {
            return new File(iceInstall + File.separator + "bin" + File.separator + name).toString();
        }
        return name;
    }

    protected void addLdLibraryPath(ExecTask task) {
        String iceInstall = this.getIceHome();
        boolean srcdist = this.getProject().getProperties().containsKey("ice.src.dist");
        if (iceInstall != null) {
            Environment.Variable v;
            String ldLibPathEnv = null;
            String ldLib64PathEnv = null;
            String libPath = new File(iceInstall + File.separator + "lib").toString();
            String lib64Path = null;
            String os = System.getProperty("os.name");
            if (os.equals("Mac OS X")) {
                ldLibPathEnv = "DYLD_LIBRARY_PATH";
            } else if (os.equals("AIX")) {
                ldLibPathEnv = "LIBPATH";
            } else if (os.equals("HP-UX")) {
                ldLibPathEnv = "SHLIB_PATH";
                ldLib64PathEnv = "LD_LIBRARY_PATH";
                lib64Path = srcdist ? libPath : new File(iceInstall + File.separator + "lib" + File.separator + "pa20_64").toString();
            } else if (!os.startsWith("Windows")) {
                if (os.equals("SunOS")) {
                    ldLibPathEnv = "LD_LIBRARY_PATH";
                    ldLib64PathEnv = "LD_LIBRARY_PATH_64";
                    String arch = System.getProperty("os.arch");
                    lib64Path = srcdist ? libPath : (arch.equals("x86") ? new File(iceInstall + File.separator + "lib" + File.separator + "amd64").toString() : new File(iceInstall + File.separator + "lib" + File.separator + "sparcv9").toString());
                } else {
                    ldLibPathEnv = "LD_LIBRARY_PATH";
                    ldLib64PathEnv = "LD_LIBRARY_PATH";
                    lib64Path = srcdist ? libPath : new File(iceInstall + File.separator + "lib64").toString();
                }
            }
            if (ldLibPathEnv != null) {
                String envLibPath;
                if (ldLibPathEnv.equals(ldLib64PathEnv)) {
                    libPath = libPath + File.pathSeparator + lib64Path;
                }
                if ((envLibPath = this.getEnvironment(ldLibPathEnv)) != null) {
                    libPath = libPath + File.pathSeparator + envLibPath;
                }
                v = new Environment.Variable();
                v.setKey(ldLibPathEnv);
                v.setValue(libPath);
                task.addEnv(v);
            }
            if (ldLib64PathEnv != null && !ldLib64PathEnv.equals(ldLibPathEnv)) {
                String envLib64Path = this.getEnvironment(ldLib64PathEnv);
                if (envLib64Path != null) {
                    lib64Path = lib64Path + File.pathSeparator + envLib64Path;
                }
                v = new Environment.Variable();
                v.setKey(ldLib64PathEnv);
                v.setValue(lib64Path);
                task.addEnv(v);
            }
        }
    }

    protected String getIceHome() {
        if (this._iceHome == null) {
            this._iceHome = this.getProject().getProperties().containsKey("ice.home") ? (String)this.getProject().getProperties().get("ice.home") : this.getEnvironment("ICE_HOME");
        }
        return this._iceHome;
    }

    private String getEnvironment(String key) {
        Vector env = Execute.getProcEnvironment();
        Enumeration e = env.elements();
        while (e.hasMoreElements()) {
            String entry = (String)e.nextElement();
            if (!entry.startsWith(key + "=")) continue;
            return entry.substring(entry.indexOf(61) + 1);
        }
        return null;
    }

    private class Slice2JavaDependenciesParser {
        List<SliceDependency> dependencies = new LinkedList<SliceDependency>();

        private Slice2JavaDependenciesParser() {
        }

        private Node findNode(Node n, String qName) throws SAXException {
            NodeList children = n.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (child.getNodeType() != 1 || !child.getNodeName().equals(qName)) continue;
                return child;
            }
            throw new SAXException("no such node: " + qName);
        }

        private void visitDependencies(Node n) throws SAXException {
            NodeList children = n.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                if (children.item(i).getNodeType() != 1 || !children.item(i).getNodeName().equals("source")) continue;
                String source = ((Element)children.item(i)).getAttribute("name");
                if (source.length() == 0) {
                    throw new SAXException("empty name attribute");
                }
                List<String> dependsOn = this.visitDependsOn(children.item(i));
                SliceDependency depend = new SliceDependency();
                depend._timeStamp = new Date().getTime();
                depend._dependencies = new String[dependsOn.size() + 1];
                depend._dependencies[0] = source;
                for (int j = 0; j < dependsOn.size(); ++j) {
                    depend._dependencies[j + 1] = dependsOn.get(j);
                }
                this.dependencies.add(depend);
            }
        }

        private List<String> visitDependsOn(Node source) throws SAXException {
            ArrayList<String> depends = new ArrayList<String>();
            NodeList dependencies = source.getChildNodes();
            for (int j = 0; j < dependencies.getLength(); ++j) {
                if (dependencies.item(j).getNodeType() != 1 || !dependencies.item(j).getNodeName().equals("dependsOn")) continue;
                Element dependsOn = (Element)dependencies.item(j);
                String name = dependsOn.getAttribute("name");
                if (name.length() == 0) {
                    throw new SAXException("empty name attribute");
                }
                depends.add(name);
            }
            return depends;
        }

        public void visit(Node doc) throws SAXException {
            Node n = this.findNode(doc, "dependencies");
            this.visitDependencies(n);
        }
    }

    protected class SliceDependency
    implements Serializable {
        public String[] _dependencies;
        public long _timeStamp;
        public static final long serialVersionUID = 0L;

        protected SliceDependency() {
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeObject(this._dependencies);
            out.writeLong(this._timeStamp);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            this._dependencies = (String[])in.readObject();
            this._timeStamp = in.readLong();
        }

        public boolean isUpToDate() {
            for (String d : this._dependencies) {
                File dep = new File(d);
                if (dep.exists() && this._timeStamp >= dep.lastModified()) continue;
                return false;
            }
            return true;
        }
    }
}

