/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.client.registration;

import de.codecentric.boot.admin.client.config.InstanceProperties;
import de.codecentric.boot.admin.client.registration.Application;
import de.codecentric.boot.admin.client.registration.ApplicationFactory;
import de.codecentric.boot.admin.client.registration.metadata.MetadataContributor;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementServerProperties;
import org.springframework.boot.actuate.endpoint.EndpointId;
import org.springframework.boot.actuate.endpoint.web.PathMappedEndpoints;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.boot.web.server.Ssl;
import org.springframework.context.event.EventListener;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

public class DefaultApplicationFactory
implements ApplicationFactory {
    private final InstanceProperties instance;
    private final ServerProperties server;
    private final ManagementServerProperties management;
    private final PathMappedEndpoints pathMappedEndpoints;
    private final WebEndpointProperties webEndpoint;
    private final MetadataContributor metadataContributor;
    @Nullable
    private Integer localServerPort;
    @Nullable
    private Integer localManagementPort;

    public DefaultApplicationFactory(InstanceProperties instance, ManagementServerProperties management, ServerProperties server, PathMappedEndpoints pathMappedEndpoints, WebEndpointProperties webEndpoint, MetadataContributor metadataContributor) {
        this.instance = instance;
        this.management = management;
        this.server = server;
        this.pathMappedEndpoints = pathMappedEndpoints;
        this.webEndpoint = webEndpoint;
        this.metadataContributor = metadataContributor;
    }

    @Override
    public Application createApplication() {
        return Application.create(this.getName()).healthUrl(this.getHealthUrl()).managementUrl(this.getManagementUrl()).serviceUrl(this.getServiceUrl()).metadata(this.getMetadata()).build();
    }

    protected String getName() {
        return this.instance.getName();
    }

    protected String getServiceUrl() {
        if (this.instance.getServiceUrl() != null) {
            return this.instance.getServiceUrl();
        }
        return UriComponentsBuilder.fromUriString((String)this.getServiceBaseUrl()).path(this.getServicePath()).toUriString();
    }

    protected String getServiceBaseUrl() {
        String baseUrl = this.instance.getServiceBaseUrl();
        if (StringUtils.hasText((String)baseUrl)) {
            return baseUrl;
        }
        return UriComponentsBuilder.newInstance().scheme(this.getScheme(this.server.getSsl())).host(this.getServiceHost()).port(this.getLocalServerPort().intValue()).toUriString();
    }

    protected String getServicePath() {
        String path = this.instance.getServicePath();
        if (StringUtils.hasText((String)path)) {
            return path;
        }
        return "/";
    }

    protected String getManagementUrl() {
        if (this.instance.getManagementUrl() != null) {
            return this.instance.getManagementUrl();
        }
        return UriComponentsBuilder.fromUriString((String)this.getManagementBaseUrl()).path("/").path(this.getEndpointsWebPath()).toUriString();
    }

    protected String getManagementBaseUrl() {
        String baseUrl = this.instance.getManagementBaseUrl();
        if (StringUtils.hasText((String)baseUrl)) {
            return baseUrl;
        }
        if (this.isManagementPortEqual()) {
            return this.getServiceUrl();
        }
        Ssl ssl = this.management.getSsl() != null ? this.management.getSsl() : this.server.getSsl();
        return UriComponentsBuilder.newInstance().scheme(this.getScheme(ssl)).host(this.getManagementHost()).port(this.getLocalManagementPort().intValue()).toUriString();
    }

    protected boolean isManagementPortEqual() {
        return this.localManagementPort == null || this.localManagementPort.equals(this.localServerPort);
    }

    protected String getEndpointsWebPath() {
        return this.webEndpoint.getBasePath();
    }

    protected String getHealthUrl() {
        if (this.instance.getHealthUrl() != null) {
            return this.instance.getHealthUrl();
        }
        return UriComponentsBuilder.fromHttpUrl((String)this.getManagementBaseUrl()).path("/").path(this.getHealthEndpointPath()).toUriString();
    }

    protected Map<String, String> getMetadata() {
        LinkedHashMap<String, String> metadata = new LinkedHashMap<String, String>();
        metadata.putAll(this.metadataContributor.getMetadata());
        metadata.putAll(this.instance.getMetadata());
        return metadata;
    }

    protected String getServiceHost() {
        InetAddress address = this.server.getAddress();
        if (address == null) {
            address = this.getLocalHost();
        }
        return this.getHost(address);
    }

    protected String getManagementHost() {
        InetAddress address = this.management.getAddress();
        if (address != null) {
            return this.getHost(address);
        }
        return this.getServiceHost();
    }

    protected InetAddress getLocalHost() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException ex) {
            throw new IllegalArgumentException(ex.getMessage(), ex);
        }
    }

    protected Integer getLocalServerPort() {
        if (this.localServerPort == null) {
            throw new IllegalStateException("couldn't determine local port. Please set spring.boot.admin.client.instance.service-base-url.");
        }
        return this.localServerPort;
    }

    protected Integer getLocalManagementPort() {
        if (this.localManagementPort == null) {
            return this.getLocalServerPort();
        }
        return this.localManagementPort;
    }

    protected String getHealthEndpointPath() {
        String health = this.pathMappedEndpoints.getPath(EndpointId.of((String)"health"));
        if (StringUtils.hasText((String)health)) {
            return health;
        }
        String status = this.pathMappedEndpoints.getPath(EndpointId.of((String)"status"));
        if (StringUtils.hasText((String)status)) {
            return status;
        }
        throw new IllegalStateException("Either health or status endpoint must be enabled!");
    }

    protected String getScheme(@Nullable Ssl ssl) {
        return ssl != null && ssl.isEnabled() ? "https" : "http";
    }

    protected String getHost(InetAddress address) {
        return this.instance.isPreferIp() ? address.getHostAddress() : address.getCanonicalHostName();
    }

    @EventListener
    public void onWebServerInitialized(WebServerInitializedEvent event) {
        String name = event.getApplicationContext().getServerNamespace();
        if ("server".equals(name) || !StringUtils.hasText((String)name)) {
            this.localServerPort = event.getWebServer().getPort();
        } else if ("management".equals(name)) {
            this.localManagementPort = event.getWebServer().getPort();
        }
    }
}

