/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.client.config;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.convert.DurationUnit;
import org.springframework.core.env.Environment;

@ConfigurationProperties(prefix="spring.boot.admin.client")
public class ClientProperties {
    private String[] url = new String[0];
    private String apiPath = "instances";
    @DurationUnit(value=ChronoUnit.MILLIS)
    private Duration period = Duration.ofMillis(10000L);
    @DurationUnit(value=ChronoUnit.MILLIS)
    private Duration connectTimeout = Duration.ofMillis(5000L);
    @DurationUnit(value=ChronoUnit.MILLIS)
    private Duration readTimeout = Duration.ofMillis(5000L);
    @Nullable
    private String username;
    @Nullable
    private String password;
    @Nullable
    private Boolean autoDeregistration = null;
    private boolean autoRegistration = true;
    private boolean registerOnce = true;
    private boolean enabled = true;

    public String[] getAdminUrl() {
        String[] adminUrls = (String[])this.url.clone();
        int i = 0;
        while (i < adminUrls.length) {
            int n = i++;
            adminUrls[n] = adminUrls[n] + "/" + this.apiPath;
        }
        return adminUrls;
    }

    public boolean isAutoDeregistration(Environment environment) {
        return this.autoDeregistration != null ? this.autoDeregistration : CloudPlatform.getActive((Environment)environment) != null;
    }

    public String[] getUrl() {
        return this.url;
    }

    public String getApiPath() {
        return this.apiPath;
    }

    public Duration getPeriod() {
        return this.period;
    }

    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    public Duration getReadTimeout() {
        return this.readTimeout;
    }

    @Nullable
    public String getUsername() {
        return this.username;
    }

    @Nullable
    public String getPassword() {
        return this.password;
    }

    @Nullable
    public Boolean getAutoDeregistration() {
        return this.autoDeregistration;
    }

    public boolean isAutoRegistration() {
        return this.autoRegistration;
    }

    public boolean isRegisterOnce() {
        return this.registerOnce;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setUrl(String[] url) {
        this.url = url;
    }

    public void setApiPath(String apiPath) {
        this.apiPath = apiPath;
    }

    public void setPeriod(Duration period) {
        this.period = period;
    }

    public void setConnectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setReadTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setUsername(@Nullable String username) {
        this.username = username;
    }

    public void setPassword(@Nullable String password) {
        this.password = password;
    }

    public void setAutoDeregistration(@Nullable Boolean autoDeregistration) {
        this.autoDeregistration = autoDeregistration;
    }

    public void setAutoRegistration(boolean autoRegistration) {
        this.autoRegistration = autoRegistration;
    }

    public void setRegisterOnce(boolean registerOnce) {
        this.registerOnce = registerOnce;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientProperties)) {
            return false;
        }
        ClientProperties other = (ClientProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAutoRegistration() != other.isAutoRegistration()) {
            return false;
        }
        if (this.isRegisterOnce() != other.isRegisterOnce()) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        Boolean this$autoDeregistration = this.getAutoDeregistration();
        Boolean other$autoDeregistration = other.getAutoDeregistration();
        if (this$autoDeregistration == null ? other$autoDeregistration != null : !((Object)this$autoDeregistration).equals(other$autoDeregistration)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getUrl(), other.getUrl())) {
            return false;
        }
        String this$apiPath = this.getApiPath();
        String other$apiPath = other.getApiPath();
        if (this$apiPath == null ? other$apiPath != null : !this$apiPath.equals(other$apiPath)) {
            return false;
        }
        Duration this$period = this.getPeriod();
        Duration other$period = other.getPeriod();
        if (this$period == null ? other$period != null : !((Object)this$period).equals(other$period)) {
            return false;
        }
        Duration this$connectTimeout = this.getConnectTimeout();
        Duration other$connectTimeout = other.getConnectTimeout();
        if (this$connectTimeout == null ? other$connectTimeout != null : !((Object)this$connectTimeout).equals(other$connectTimeout)) {
            return false;
        }
        Duration this$readTimeout = this.getReadTimeout();
        Duration other$readTimeout = other.getReadTimeout();
        if (this$readTimeout == null ? other$readTimeout != null : !((Object)this$readTimeout).equals(other$readTimeout)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        return !(this$password == null ? other$password != null : !this$password.equals(other$password));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAutoRegistration() ? 79 : 97);
        result = result * 59 + (this.isRegisterOnce() ? 79 : 97);
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        Boolean $autoDeregistration = this.getAutoDeregistration();
        result = result * 59 + ($autoDeregistration == null ? 43 : ((Object)$autoDeregistration).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getUrl());
        String $apiPath = this.getApiPath();
        result = result * 59 + ($apiPath == null ? 43 : $apiPath.hashCode());
        Duration $period = this.getPeriod();
        result = result * 59 + ($period == null ? 43 : ((Object)$period).hashCode());
        Duration $connectTimeout = this.getConnectTimeout();
        result = result * 59 + ($connectTimeout == null ? 43 : ((Object)$connectTimeout).hashCode());
        Duration $readTimeout = this.getReadTimeout();
        result = result * 59 + ($readTimeout == null ? 43 : ((Object)$readTimeout).hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        return result;
    }

    public String toString() {
        return "ClientProperties(url=" + Arrays.deepToString(this.getUrl()) + ", apiPath=" + this.getApiPath() + ", period=" + this.getPeriod() + ", connectTimeout=" + this.getConnectTimeout() + ", readTimeout=" + this.getReadTimeout() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", autoDeregistration=" + this.getAutoDeregistration() + ", autoRegistration=" + this.isAutoRegistration() + ", registerOnce=" + this.isRegisterOnce() + ", enabled=" + this.isEnabled() + ")";
    }
}

