/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.services.endpoints;

import de.codecentric.boot.admin.server.domain.entities.Instance;
import de.codecentric.boot.admin.server.domain.values.Endpoint;
import de.codecentric.boot.admin.server.domain.values.Endpoints;
import de.codecentric.boot.admin.server.services.endpoints.EndpointDetectionStrategy;
import de.codecentric.boot.admin.server.web.client.InstanceWebClient;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ProbeEndpointsStrategy
implements EndpointDetectionStrategy {
    private final Collection<EndpointDefinition> endpoints;
    private final InstanceWebClient instanceWebClient;

    public ProbeEndpointsStrategy(InstanceWebClient instanceWebClient, String[] endpoints) {
        Assert.notNull((Object)endpoints, (String)"'endpoints' must not be null.");
        Assert.noNullElements((Object[])endpoints, (String)"'endpoints' must not contain null.");
        this.endpoints = Arrays.stream(endpoints).map(x$0 -> EndpointDefinition.create(x$0)).collect(Collectors.toList());
        this.instanceWebClient = instanceWebClient;
    }

    @Override
    public Mono<Endpoints> detectEndpoints(Instance instance) {
        return Flux.fromIterable(this.endpoints).flatMap(endpoint -> this.detectEndpoint(instance, (EndpointDefinition)endpoint)).collectList().flatMap(list -> list.isEmpty() ? Mono.empty() : Mono.just((Object)Endpoints.of(list)));
    }

    private Mono<Endpoint> detectEndpoint(Instance instance, EndpointDefinition endpoint) {
        URI uri = UriComponentsBuilder.fromUriString((String)instance.getRegistration().getManagementUrl()).path("/").path(endpoint.getPath()).build().toUri();
        return this.instanceWebClient.instance(instance).options().uri(uri).exchange().flatMap(this.convert(endpoint, uri));
    }

    private Function<ClientResponse, Mono<Endpoint>> convert(EndpointDefinition endpoint, URI uri) {
        return response -> response.bodyToMono(Void.class).then(response.statusCode().is2xxSuccessful() ? Mono.just((Object)Endpoint.of(endpoint.getId(), uri.toString())) : Mono.empty());
    }

    private static class EndpointDefinition {
        private final String id;
        private final String path;

        private static EndpointDefinition create(String idWithPath) {
            int idxDelimiter = idWithPath.indexOf(58);
            if (idxDelimiter < 0) {
                return new EndpointDefinition(idWithPath, idWithPath);
            }
            return new EndpointDefinition(idWithPath.substring(0, idxDelimiter), idWithPath.substring(idxDelimiter + 1));
        }

        public EndpointDefinition(String id, String path) {
            this.id = id;
            this.path = path;
        }

        public String getId() {
            return this.id;
        }

        public String getPath() {
            return this.path;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EndpointDefinition)) {
                return false;
            }
            EndpointDefinition other = (EndpointDefinition)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$path = this.getPath();
            String other$path = other.getPath();
            return !(this$path == null ? other$path != null : !this$path.equals(other$path));
        }

        protected boolean canEqual(Object other) {
            return other instanceof EndpointDefinition;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            return result;
        }

        public String toString() {
            return "ProbeEndpointsStrategy.EndpointDefinition(id=" + this.getId() + ", path=" + this.getPath() + ")";
        }
    }
}

