/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.domain.entities;

import de.codecentric.boot.admin.server.domain.entities.Instance;
import de.codecentric.boot.admin.server.domain.entities.InstanceRepository;
import de.codecentric.boot.admin.server.domain.events.InstanceEvent;
import de.codecentric.boot.admin.server.domain.values.InstanceId;
import de.codecentric.boot.admin.server.eventstore.InstanceEventStore;
import de.codecentric.boot.admin.server.eventstore.OptimisticLockingException;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.retry.Retry;

public class EventsourcingInstanceRepository
implements InstanceRepository {
    private static final Logger log = LoggerFactory.getLogger(EventsourcingInstanceRepository.class);
    private final InstanceEventStore eventStore;
    private final Retry<?> retryOnOptimisticLockException = Retry.anyOf((Class[])new Class[]{OptimisticLockingException.class}).fixedBackoff(Duration.ofMillis(50L)).retryMax(10).doOnRetry(ctx -> log.debug("Retrying after OptimisticLockingException", ctx.exception()));

    public EventsourcingInstanceRepository(InstanceEventStore eventStore) {
        this.eventStore = eventStore;
    }

    @Override
    public Mono<Instance> save(Instance instance) {
        return this.eventStore.append(instance.getUnsavedEvents()).then(Mono.just((Object)instance.clearUnsavedEvents()));
    }

    @Override
    public Flux<Instance> findAll() {
        return this.eventStore.findAll().groupBy(InstanceEvent::getInstance).flatMap(f -> f.reduce((Object)Instance.create((InstanceId)f.key()), Instance::apply));
    }

    @Override
    public Mono<Instance> find(InstanceId id) {
        return this.eventStore.find(id).collect(AtomicReference::new, (ref, event) -> {
            Instance instance = ref.get() != null ? (Instance)ref.get() : Instance.create(id);
            ref.set(instance.apply((InstanceEvent)event));
        }).flatMap(ref -> Mono.justOrEmpty(ref.get()));
    }

    @Override
    public Flux<Instance> findByName(String name) {
        return this.findAll().filter(a -> a.isRegistered() && name.equals(a.getRegistration().getName()));
    }

    @Override
    public Mono<Instance> compute(InstanceId id, BiFunction<InstanceId, Instance, Mono<Instance>> remappingFunction) {
        return this.find(id).flatMap(application -> (Mono)remappingFunction.apply(id, (Instance)application)).switchIfEmpty(Mono.defer(() -> (Mono)remappingFunction.apply(id, null))).flatMap(this::save).retryWhen(this.retryOnOptimisticLockException);
    }

    @Override
    public Mono<Instance> computeIfPresent(InstanceId id, BiFunction<InstanceId, Instance, Mono<Instance>> remappingFunction) {
        return this.find(id).flatMap(application -> (Mono)remappingFunction.apply(id, (Instance)application)).flatMap(this::save).retryWhen(this.retryOnOptimisticLockException);
    }

    protected final InstanceEventStore getEventStore() {
        return this.eventStore;
    }
}

