/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.notify;

import de.codecentric.boot.admin.server.domain.entities.Instance;
import de.codecentric.boot.admin.server.domain.entities.InstanceRepository;
import de.codecentric.boot.admin.server.domain.events.InstanceEvent;
import de.codecentric.boot.admin.server.notify.Notifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public abstract class AbstractEventNotifier
implements Notifier {
    private final InstanceRepository repository;
    private boolean enabled = true;

    protected AbstractEventNotifier(InstanceRepository repository) {
        this.repository = repository;
    }

    @Override
    public Mono<Void> notify(InstanceEvent event) {
        if (!this.enabled) {
            return Mono.empty();
        }
        return this.repository.find(event.getInstance()).filter(instance -> this.shouldNotify(event, (Instance)instance)).flatMap(instance -> this.doNotify(event, (Instance)instance)).doOnError(ex -> this.getLogger().error("Couldn't notify for event {} ", (Object)event, ex)).then();
    }

    protected boolean shouldNotify(InstanceEvent event, Instance instance) {
        return true;
    }

    protected abstract Mono<Void> doNotify(InstanceEvent var1, Instance var2);

    private Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

