/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.domain.values;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class Registration
implements Serializable {
    private final String name;
    @Nullable
    private final String managementUrl;
    private final String healthUrl;
    @Nullable
    private final String serviceUrl;
    private final String source;
    private final Map<String, String> metadata;

    private Registration(String name, @Nullable String managementUrl, String healthUrl, @Nullable String serviceUrl, String source, Map<String, String> metadata) {
        Assert.hasText((String)name, (String)"'name' must not be empty.");
        Assert.hasText((String)healthUrl, (String)"'healthUrl' must not be empty.");
        Assert.isTrue((boolean)this.checkUrl(healthUrl), (String)("'healthUrl' is not valid: " + healthUrl));
        Assert.isTrue((!StringUtils.hasText((String)managementUrl) || this.checkUrl(managementUrl) ? 1 : 0) != 0, (String)("'managementUrl' is not valid: " + managementUrl));
        Assert.isTrue((!StringUtils.hasText((String)serviceUrl) || this.checkUrl(serviceUrl) ? 1 : 0) != 0, (String)("'serviceUrl' is not valid: " + serviceUrl));
        this.name = name;
        this.managementUrl = managementUrl;
        this.healthUrl = healthUrl;
        this.serviceUrl = serviceUrl;
        this.source = source;
        this.metadata = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> entry : metadata.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            this.metadata.put(key, value);
        }
    }

    public static Builder create(String name, String healthUrl) {
        return Registration.builder().name(name).healthUrl(healthUrl);
    }

    public static Builder copyOf(Registration registration) {
        return registration.toBuilder();
    }

    public Map<String, String> getMetadata() {
        return Collections.unmodifiableMap(this.metadata);
    }

    private boolean checkUrl(String url) {
        try {
            URI uri = new URI(url);
            return uri.isAbsolute();
        }
        catch (URISyntaxException ex) {
            return false;
        }
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public Builder toBuilder() {
        Builder builder = new Builder().name(this.name).managementUrl(this.managementUrl).healthUrl(this.healthUrl).serviceUrl(this.serviceUrl).source(this.source);
        if (this.metadata != null) {
            builder.metadata(this.metadata);
        }
        return builder;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Nullable
    @Generated
    public String getManagementUrl() {
        return this.managementUrl;
    }

    @Generated
    public String getHealthUrl() {
        return this.healthUrl;
    }

    @Nullable
    @Generated
    public String getServiceUrl() {
        return this.serviceUrl;
    }

    @Generated
    public String getSource() {
        return this.source;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Registration)) {
            return false;
        }
        Registration other = (Registration)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$managementUrl = this.getManagementUrl();
        String other$managementUrl = other.getManagementUrl();
        if (this$managementUrl == null ? other$managementUrl != null : !this$managementUrl.equals(other$managementUrl)) {
            return false;
        }
        String this$healthUrl = this.getHealthUrl();
        String other$healthUrl = other.getHealthUrl();
        if (this$healthUrl == null ? other$healthUrl != null : !this$healthUrl.equals(other$healthUrl)) {
            return false;
        }
        String this$serviceUrl = this.getServiceUrl();
        String other$serviceUrl = other.getServiceUrl();
        if (this$serviceUrl == null ? other$serviceUrl != null : !this$serviceUrl.equals(other$serviceUrl)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        return !(this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $managementUrl = this.getManagementUrl();
        result = result * 59 + ($managementUrl == null ? 43 : $managementUrl.hashCode());
        String $healthUrl = this.getHealthUrl();
        result = result * 59 + ($healthUrl == null ? 43 : $healthUrl.hashCode());
        String $serviceUrl = this.getServiceUrl();
        result = result * 59 + ($serviceUrl == null ? 43 : $serviceUrl.hashCode());
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Registration(name=" + this.getName() + ", managementUrl=" + this.getManagementUrl() + ", healthUrl=" + this.getHealthUrl() + ", serviceUrl=" + this.getServiceUrl() + ", source=" + this.getSource() + ")";
    }

    public static class Builder {
        @Generated
        private String name;
        @Generated
        private String managementUrl;
        @Generated
        private String healthUrl;
        @Generated
        private String serviceUrl;
        @Generated
        private String source;
        @Generated
        private ArrayList<String> metadata$key;
        @Generated
        private ArrayList<String> metadata$value;

        @Generated
        Builder() {
        }

        @Generated
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public Builder managementUrl(@Nullable String managementUrl) {
            this.managementUrl = managementUrl;
            return this;
        }

        @Generated
        public Builder healthUrl(String healthUrl) {
            this.healthUrl = healthUrl;
            return this;
        }

        @Generated
        public Builder serviceUrl(@Nullable String serviceUrl) {
            this.serviceUrl = serviceUrl;
            return this;
        }

        @Generated
        public Builder source(String source) {
            this.source = source;
            return this;
        }

        @Generated
        public Builder metadata(String metadataKey, String metadataValue) {
            if (this.metadata$key == null) {
                this.metadata$key = new ArrayList();
                this.metadata$value = new ArrayList();
            }
            this.metadata$key.add(metadataKey);
            this.metadata$value.add(metadataValue);
            return this;
        }

        @Generated
        public Builder metadata(Map<? extends String, ? extends String> metadata) {
            if (metadata == null) {
                throw new NullPointerException("metadata cannot be null");
            }
            if (this.metadata$key == null) {
                this.metadata$key = new ArrayList();
                this.metadata$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : metadata.entrySet()) {
                this.metadata$key.add($lombokEntry.getKey());
                this.metadata$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @Generated
        public Builder clearMetadata() {
            if (this.metadata$key != null) {
                this.metadata$key.clear();
                this.metadata$value.clear();
            }
            return this;
        }

        @Generated
        public Registration build() {
            Map<String, String> metadata;
            switch (this.metadata$key == null ? 0 : this.metadata$key.size()) {
                case 0: {
                    metadata = Collections.emptyMap();
                    break;
                }
                case 1: {
                    metadata = Collections.singletonMap(this.metadata$key.get(0), this.metadata$value.get(0));
                    break;
                }
                default: {
                    metadata = new LinkedHashMap(this.metadata$key.size() < 0x40000000 ? 1 + this.metadata$key.size() + (this.metadata$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.metadata$key.size(); ++$i) {
                        metadata.put(this.metadata$key.get($i), this.metadata$value.get($i));
                    }
                    metadata = Collections.unmodifiableMap(metadata);
                }
            }
            return new Registration(this.name, this.managementUrl, this.healthUrl, this.serviceUrl, this.source, metadata);
        }

        @Generated
        public String toString() {
            return "Registration.Builder(name=" + this.name + ", managementUrl=" + this.managementUrl + ", healthUrl=" + this.healthUrl + ", serviceUrl=" + this.serviceUrl + ", source=" + this.source + ", metadata$key=" + String.valueOf(this.metadata$key) + ", metadata$value=" + String.valueOf(this.metadata$value) + ")";
        }
    }
}

