/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.data.document.graph;

import com.fasterxml.jackson.annotation.JsonProperty;
import dev.langchain4j.Experimental;
import dev.langchain4j.community.data.document.graph.GraphNode;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import java.util.Map;
import java.util.Objects;

@Experimental
public class GraphEdge {
    private final GraphNode sourceNode;
    private final GraphNode targetNode;
    private final String type;
    private final Map<String, String> properties;

    public GraphEdge(GraphNode sourceNode, GraphNode targetNode, String type, Map<String, String> properties) {
        this.sourceNode = (GraphNode)ValidationUtils.ensureNotNull((Object)sourceNode, (String)"sourceNode");
        this.targetNode = (GraphNode)ValidationUtils.ensureNotNull((Object)targetNode, (String)"targetNode");
        this.type = type;
        this.properties = Utils.copy(properties);
    }

    @JsonProperty
    public GraphNode sourceNode() {
        return this.sourceNode;
    }

    @JsonProperty
    public GraphNode targetNode() {
        return this.targetNode;
    }

    @JsonProperty
    public String type() {
        return this.type;
    }

    @JsonProperty
    public Map<String, String> properties() {
        return this.properties;
    }

    public static GraphEdge from(GraphNode sourceNode, GraphNode targetNode, String type, Map<String, String> properties) {
        return new GraphEdge(sourceNode, targetNode, type, properties);
    }

    public static GraphEdge from(GraphNode sourceNode, GraphNode targetNode, String type) {
        return new GraphEdge(sourceNode, targetNode, type, Map.of());
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GraphEdge graphEdge = (GraphEdge)o;
        return Objects.equals(this.sourceNode, graphEdge.sourceNode) && Objects.equals(this.targetNode, graphEdge.targetNode) && Objects.equals(this.type, graphEdge.type) && Objects.equals(this.properties, graphEdge.properties);
    }

    public int hashCode() {
        return Objects.hash(this.sourceNode, this.targetNode, this.type, this.properties);
    }

    public String toString() {
        return "GraphEdge{sourceNode=" + String.valueOf(this.sourceNode) + ", targetNode=" + String.valueOf(this.targetNode) + ", type='" + this.type + "', properties=" + String.valueOf(this.properties) + "}";
    }
}

