/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.rag.content.retriever.neo4j;

import dev.langchain4j.community.rag.content.retriever.neo4j.Neo4jException;
import dev.langchain4j.community.rag.content.retriever.neo4j.Neo4jGraphSchemaUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import java.util.List;
import java.util.Map;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.driver.Record;
import org.neo4j.driver.Session;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.summary.ResultSummary;

public class Neo4jGraph
implements AutoCloseable {
    private final Driver driver;
    private final Long sample;
    private final Long maxRels;
    private String schema;

    public Neo4jGraph(Driver driver, Long sample, Long maxRels) {
        this.sample = (Long)Utils.getOrDefault((Object)sample, (Object)1000L);
        this.maxRels = (Long)Utils.getOrDefault((Object)maxRels, (Object)100L);
        this.driver = (Driver)ValidationUtils.ensureNotNull((Object)driver, (String)"driver");
        this.driver.verifyConnectivity();
        try {
            this.refreshSchema();
        }
        catch (ClientException e) {
            if ("Neo.ClientError.Procedure.ProcedureNotFound".equals(e.code())) {
                throw new Neo4jException("Please ensure the APOC plugin is installed in Neo4j", e);
            }
            throw e;
        }
    }

    public String getSchema() {
        return this.schema;
    }

    public ResultSummary executeWrite(String queryString) {
        return this.executeWrite(queryString, Map.of());
    }

    public ResultSummary executeWrite(String queryString, Map<String, Object> params) {
        ResultSummary resultSummary;
        block8: {
            Session session = this.driver.session();
            try {
                resultSummary = (ResultSummary)session.executeWrite(tx -> tx.run(queryString, params).consume());
                if (session == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ClientException e) {
                    throw new Neo4jException("Error executing query: " + queryString, e);
                }
            }
            session.close();
        }
        return resultSummary;
    }

    public List<Record> executeRead(String queryString) {
        return this.executeRead(queryString, Map.of());
    }

    public List<Record> executeRead(String queryString, Map<String, Object> parameters) {
        return this.driver.executableQuery(queryString).withParameters(parameters).execute().records();
    }

    public void refreshSchema() {
        this.schema = Neo4jGraphSchemaUtils.getSchemaFromMetadata(this, this.sample, this.maxRels);
    }

    @Override
    public void close() {
        this.driver.close();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Driver driver;
        private Long sample;
        private Long maxRels;

        public Builder driver(Driver driver) {
            this.driver = driver;
            return this;
        }

        public Builder sample(Long sample) {
            this.sample = sample;
            return this;
        }

        public Builder maxRels(Long maxRels) {
            this.maxRels = maxRels;
            return this;
        }

        public Builder withBasicAuth(String uri, String user, String password) {
            this.driver = GraphDatabase.driver((String)uri, (AuthToken)AuthTokens.basic((String)user, (String)password));
            return this;
        }

        public Neo4jGraph build() {
            return new Neo4jGraph(this.driver, this.sample, this.maxRels);
        }
    }
}

