/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.input;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheFactory;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.input.Prompt;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.time.Clock;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class PromptTemplate {
    private static final MustacheFactory MUSTACHE_FACTORY = new DefaultMustacheFactory();
    private final Mustache mustache;
    private final Clock clock;

    public PromptTemplate(String template) {
        this(template, Clock.systemDefaultZone());
    }

    PromptTemplate(String template, Clock clock) {
        StringReader stringReader = new StringReader(ValidationUtils.ensureNotBlank(template, "template"));
        this.mustache = MUSTACHE_FACTORY.compile((Reader)stringReader, "template");
        this.clock = ValidationUtils.ensureNotNull(clock, "clock");
    }

    public Prompt apply(Object value) {
        return this.apply(Collections.singletonMap("it", value));
    }

    public Prompt apply(Map<String, Object> variables) {
        StringWriter writer = new StringWriter();
        this.mustache.execute((Writer)writer, this.injectDateTimeVariables(variables));
        return Prompt.from(writer.toString());
    }

    private Map<String, Object> injectDateTimeVariables(Map<String, Object> variables) {
        HashMap<String, Object> variablesCopy = new HashMap<String, Object>(variables);
        variablesCopy.put("current_date", LocalDate.now(this.clock));
        variablesCopy.put("current_time", LocalTime.now(this.clock));
        variablesCopy.put("current_date_time", LocalDateTime.now(this.clock));
        return variablesCopy;
    }

    public static PromptTemplate from(String template) {
        return new PromptTemplate(template);
    }
}

