/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.image;

import dev.langchain4j.internal.Utils;
import java.net.URI;
import java.util.Objects;

public final class Image {
    private URI url;
    private String base64Data;
    private String revisedPrompt;

    private Image(Builder builder) {
        this.url = builder.url;
        this.base64Data = builder.base64Data;
        this.revisedPrompt = builder.revisedPrompt;
    }

    public static Builder builder() {
        return new Builder();
    }

    public URI url() {
        return this.url;
    }

    public String base64Data() {
        return this.base64Data;
    }

    public String revisedPrompt() {
        return this.revisedPrompt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Image image = (Image)o;
        return Objects.equals(this.url, image.url) && Objects.equals(this.base64Data, image.base64Data) && Objects.equals(this.revisedPrompt, image.revisedPrompt);
    }

    public int hashCode() {
        return Objects.hash(this.url, this.revisedPrompt);
    }

    public String toString() {
        return "Image{ url=" + Utils.quoted(this.url.toString()) + ", base64Data=" + Utils.quoted(this.base64Data) + ", revisedPrompt=" + Utils.quoted(this.revisedPrompt) + '}';
    }

    public static class Builder {
        private URI url;
        private String base64Data;
        private String revisedPrompt;

        public Builder url(URI url) {
            this.url = url;
            return this;
        }

        public Builder base64Data(String base64Data) {
            this.base64Data = base64Data;
            return this;
        }

        public Builder revisedPrompt(String revisedPrompt) {
            this.revisedPrompt = revisedPrompt;
            return this;
        }

        public Image build() {
            return new Image(this);
        }
    }
}

