/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.zhipu;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import dev.langchain4j.model.zhipu.Json;
import dev.langchain4j.model.zhipu.chat.AssistantMessage;
import dev.langchain4j.model.zhipu.chat.ToolCall;
import java.io.IOException;
import java.util.List;

class AssistantMessageTypeAdapter
extends TypeAdapter<AssistantMessage> {
    static final TypeAdapterFactory ASSISTANT_MESSAGE_TYPE_ADAPTER_FACTORY = new TypeAdapterFactory(){

        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (type.getRawType() != AssistantMessage.class) {
                return null;
            }
            TypeAdapter delegate = gson.getDelegateAdapter((TypeAdapterFactory)this, type);
            return new AssistantMessageTypeAdapter(delegate);
        }
    };
    private final TypeAdapter<AssistantMessage> delegate;

    private AssistantMessageTypeAdapter(TypeAdapter<AssistantMessage> delegate) {
        this.delegate = delegate;
    }

    public void write(JsonWriter out, AssistantMessage assistantMessage) throws IOException {
        List<ToolCall> toolCalls;
        out.beginObject();
        out.name("role");
        out.value(assistantMessage.getRole().toString().toLowerCase());
        out.name("content");
        if (assistantMessage.getContent() == null) {
            boolean serializeNulls = out.getSerializeNulls();
            out.setSerializeNulls(true);
            out.nullValue();
            out.setSerializeNulls(serializeNulls);
        } else {
            out.value(assistantMessage.getContent());
        }
        if (assistantMessage.getName() != null) {
            out.name("name");
            out.value(assistantMessage.getName());
        }
        if ((toolCalls = assistantMessage.getToolCalls()) != null && !toolCalls.isEmpty()) {
            out.name("tool_calls");
            out.beginArray();
            TypeAdapter toolCallTypeAdapter = Json.GSON.getAdapter(ToolCall.class);
            for (ToolCall toolCall : toolCalls) {
                toolCallTypeAdapter.write(out, (Object)toolCall);
            }
            out.endArray();
        }
        out.endObject();
    }

    public AssistantMessage read(JsonReader in) throws IOException {
        return (AssistantMessage)this.delegate.read(in);
    }
}

